/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.view.wrappers.TreeNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SearchViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private Comparator<SchemaObject> firstNameSorter = new Comparator<SchemaObject>(){

        @Override
        public int compare(SchemaObject o1, SchemaObject o2) {
            List o1Names = null;
            List o2Names = null;
            if (o1 instanceof AttributeType && o2 instanceof AttributeType) {
                AttributeType at1 = (AttributeType)o1;
                AttributeType at2 = (AttributeType)o2;
                o1Names = at1.getNames();
                o2Names = at2.getNames();
            } else if (o1 instanceof ObjectClass && o2 instanceof ObjectClass) {
                ObjectClass oc1 = (ObjectClass)o1;
                ObjectClass oc2 = (ObjectClass)o2;
                o1Names = oc1.getNames();
                o2Names = oc2.getNames();
            } else if (o1 instanceof AttributeType && o2 instanceof ObjectClass) {
                AttributeType at = (AttributeType)o1;
                ObjectClass oc = (ObjectClass)o2;
                o1Names = at.getNames();
                o2Names = oc.getNames();
            } else if (o1 instanceof ObjectClass && o2 instanceof AttributeType) {
                ObjectClass oc = (ObjectClass)o1;
                AttributeType at = (AttributeType)o2;
                o1Names = oc.getNames();
                o2Names = at.getNames();
            }
            if (o1Names != null && o2Names != null) {
                if (o1Names.size() > 0 && o2Names.size() > 0) {
                    return ((String)o1Names.get(0)).compareToIgnoreCase((String)o2Names.get(0));
                }
                if (o1Names.size() == 0 && o2Names.size() > 0) {
                    return "".compareToIgnoreCase((String)o2Names.get(0));
                }
                if (o1Names.size() > 0 && o2Names.size() == 0) {
                    return ((String)o1Names.get(0)).compareToIgnoreCase("");
                }
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    };
    private Comparator<SchemaObject> oidSorter = new Comparator<SchemaObject>(){

        @Override
        public int compare(SchemaObject o1, SchemaObject o2) {
            if (o1 instanceof AttributeType && o2 instanceof AttributeType) {
                AttributeType at1 = (AttributeType)o1;
                AttributeType at2 = (AttributeType)o2;
                return at1.getOid().compareToIgnoreCase(at2.getOid());
            }
            if (o1 instanceof ObjectClass && o2 instanceof ObjectClass) {
                ObjectClass oc1 = (ObjectClass)o1;
                ObjectClass oc2 = (ObjectClass)o2;
                return oc1.getOid().compareToIgnoreCase(oc2.getOid());
            }
            if (o1 instanceof AttributeType && o2 instanceof ObjectClass) {
                AttributeType at = (AttributeType)o1;
                ObjectClass oc = (ObjectClass)o2;
                return at.getOid().compareToIgnoreCase(oc.getOid());
            }
            if (o1 instanceof ObjectClass && o2 instanceof AttributeType) {
                ObjectClass oc = (ObjectClass)o1;
                AttributeType at = (AttributeType)o2;
                return oc.getOid().compareToIgnoreCase(at.getOid());
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    };

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList children = new ArrayList();
        int group = this.store.getInt(PluginConstants.PREFS_SEARCH_VIEW_GROUPING);
        int sortBy = this.store.getInt(PluginConstants.PREFS_SEARCH_VIEW_SORTING_BY);
        int sortOrder = this.store.getInt(PluginConstants.PREFS_SEARCH_VIEW_SORTING_ORDER);
        if (parentElement instanceof List) {
            List searchResults = (List)parentElement;
            if (group == 0) {
                ArrayList<AttributeType> attributeTypes = new ArrayList<AttributeType>();
                ArrayList<ObjectClass> objectClasses = new ArrayList<ObjectClass>();
                for (SchemaObject searchResult : searchResults) {
                    if (searchResult instanceof AttributeType) {
                        attributeTypes.add((AttributeType)searchResult);
                        continue;
                    }
                    if (!(searchResult instanceof ObjectClass)) continue;
                    objectClasses.add((ObjectClass)searchResult);
                }
                if (sortBy == 0) {
                    Collections.sort(attributeTypes, this.firstNameSorter);
                    Collections.sort(objectClasses, this.firstNameSorter);
                } else if (sortBy == 1) {
                    Collections.sort(attributeTypes, this.oidSorter);
                    Collections.sort(objectClasses, this.oidSorter);
                }
                if (sortOrder == 1) {
                    Collections.reverse(attributeTypes);
                    Collections.reverse(objectClasses);
                }
                children.addAll(attributeTypes);
                children.addAll(objectClasses);
            } else if (group == 1) {
                ArrayList<AttributeType> attributeTypes = new ArrayList<AttributeType>();
                ArrayList<ObjectClass> objectClasses = new ArrayList<ObjectClass>();
                for (SchemaObject searchResult : searchResults) {
                    if (searchResult instanceof AttributeType) {
                        attributeTypes.add((AttributeType)searchResult);
                        continue;
                    }
                    if (!(searchResult instanceof ObjectClass)) continue;
                    objectClasses.add((ObjectClass)searchResult);
                }
                if (sortBy == 0) {
                    Collections.sort(attributeTypes, this.firstNameSorter);
                    Collections.sort(objectClasses, this.firstNameSorter);
                } else if (sortBy == 1) {
                    Collections.sort(attributeTypes, this.oidSorter);
                    Collections.sort(objectClasses, this.oidSorter);
                }
                if (sortOrder == 1) {
                    Collections.reverse(attributeTypes);
                    Collections.reverse(objectClasses);
                }
                children.addAll(objectClasses);
                children.addAll(attributeTypes);
            } else if (group == 2) {
                children.addAll(searchResults);
                if (sortBy == 0) {
                    Collections.sort(children, this.firstNameSorter);
                } else if (sortBy == 1) {
                    Collections.sort(children, this.oidSorter);
                }
                if (sortOrder == 1) {
                    Collections.reverse(children);
                }
            }
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).hasChildren();
        }
        return false;
    }
}

