/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.table;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.table.TableContainer;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableContainer
implements TableContainer {
    private final Table.TableBuilder tableBuilder = new Table.TableBuilder(this);

    protected AbstractTableContainer() {
    }

    @Override
    public Table addTable() {
        return Table.newTable(this);
    }

    @Override
    public Table addTable(int numRows, int numCols) {
        return Table.newTable(this, numRows, numCols);
    }

    @Override
    public Table getTableByName(String name) {
        try {
            OdfElement containerEle = this.getTableContainerElement();
            NodeList nodeList = containerEle.getElementsByTagName(TableTableElement.ELEMENT_NAME.getQName());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                TableTableElement table = (TableTableElement)nodeList.item(i);
                if (!table.getOdfAttributeValue(OdfName.newName((NamespaceName)OdfDocumentNamespace.TABLE, (String)"name")).equals(name)) continue;
                return this.getTableBuilder().getTableInstance(table);
            }
        }
        catch (Exception e) {
            Logger.getLogger(AbstractTableContainer.class.getName()).log(Level.SEVERE, null, e);
        }
        return null;
    }

    @Override
    public List<Table> getTableList() {
        ArrayList<Table> tableList = new ArrayList<Table>();
        try {
            OdfElement containerEle = this.getTableContainerElement();
            NodeList nodeList = containerEle.getElementsByTagName(TableTableElement.ELEMENT_NAME.getQName());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                tableList.add(this.getTableBuilder().getTableInstance((TableTableElement)nodeList.item(i)));
            }
        }
        catch (Exception e) {
            Logger.getLogger(AbstractTableContainer.class.getName()).log(Level.SEVERE, null, e);
        }
        return tableList;
    }

    @Override
    public Table.TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }
}

