/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.style;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfDefaultStyle;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.style.GraphicProperties;
import org.odftoolkit.simple.style.ParagraphProperties;
import org.odftoolkit.simple.style.TableCellProperties;
import org.odftoolkit.simple.style.TextProperties;
import org.odftoolkit.simple.table.CellStyleHandler;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DefaultStyleHandler {
    protected OdfStyleBase mStyleElement;
    protected OdfStyle mWritableStyleElement;
    protected boolean isUseDefaultStyle = false;
    protected OdfStylableElement mOdfElement;
    protected Document mDocument;
    protected TextProperties mTextProperties;
    protected TextProperties mWritableTextProperties;
    protected TableCellProperties mTableCellProperties;
    protected TableCellProperties mWritableTableCellProperties;
    protected ParagraphProperties mParagraphProperties;
    protected ParagraphProperties mWritableParagraphProperties;
    protected GraphicProperties mGraphicProperties;
    protected GraphicProperties mWritableGraphicProperties;
    protected static HashMap<OdfStyleFamily, EnumSet<OdfStylePropertiesSet>> mFamilyProperties = new HashMap();

    public DefaultStyleHandler(OdfStylableElement element) {
        mFamilyProperties.put(OdfStyleFamily.Text, EnumSet.of(OdfStylePropertiesSet.TextProperties));
        mFamilyProperties.put(OdfStyleFamily.Paragraph, EnumSet.of(OdfStylePropertiesSet.TextProperties, OdfStylePropertiesSet.ParagraphProperties));
        mFamilyProperties.put(OdfStyleFamily.TableCell, EnumSet.of(OdfStylePropertiesSet.TextProperties, OdfStylePropertiesSet.ParagraphProperties, OdfStylePropertiesSet.TableCellProperties));
        mFamilyProperties.put(OdfStyleFamily.Graphic, EnumSet.of(OdfStylePropertiesSet.TextProperties, OdfStylePropertiesSet.ParagraphProperties, OdfStylePropertiesSet.GraphicProperties));
        mFamilyProperties.put(OdfStyleFamily.Presentation, EnumSet.of(OdfStylePropertiesSet.TextProperties, OdfStylePropertiesSet.ParagraphProperties, OdfStylePropertiesSet.GraphicProperties));
        mFamilyProperties.put(OdfStyleFamily.Section, EnumSet.of(OdfStylePropertiesSet.SectionProperties));
        mFamilyProperties.put(OdfStyleFamily.Ruby, EnumSet.of(OdfStylePropertiesSet.RubyProperties));
        mFamilyProperties.put(OdfStyleFamily.Table, EnumSet.of(OdfStylePropertiesSet.TableProperties));
        mFamilyProperties.put(OdfStyleFamily.TableRow, EnumSet.of(OdfStylePropertiesSet.TableRowProperties));
        mFamilyProperties.put(OdfStyleFamily.TableColumn, EnumSet.of(OdfStylePropertiesSet.TableColumnProperties));
        mFamilyProperties.put(OdfStyleFamily.DrawingPage, EnumSet.of(OdfStylePropertiesSet.DrawingPageProperties));
        mFamilyProperties.put(OdfStyleFamily.Chart, EnumSet.of(OdfStylePropertiesSet.TextProperties, OdfStylePropertiesSet.ParagraphProperties, OdfStylePropertiesSet.GraphicProperties, OdfStylePropertiesSet.ChartProperties));
        this.mOdfElement = element;
        this.mDocument = (Document)((OdfFileDom)this.mOdfElement.getOwnerDocument()).getDocument();
    }

    public TextProperties getTextPropertiesForRead() {
        if (!mFamilyProperties.get(this.mOdfElement.getStyleFamily()).contains(OdfStylePropertiesSet.TextProperties)) {
            Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "Text properties are not supported by style family: " + this.mOdfElement.getStyleFamily() + "!", "");
            return null;
        }
        if (this.mWritableTextProperties != null) {
            return this.mWritableTextProperties;
        }
        if (this.mTextProperties != null) {
            return this.mTextProperties;
        }
        OdfStyleBase style = this.getStyleElementForRead();
        if (style == null) {
            Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "No style definition is found!", "");
            return null;
        }
        this.mTextProperties = TextProperties.getTextProperties(style);
        if (this.mTextProperties != null) {
            return this.mTextProperties;
        }
        Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "No explicit text properties definition is found!", "");
        return null;
    }

    public TextProperties getTextPropertiesForWrite() {
        if (!mFamilyProperties.get(this.mOdfElement.getStyleFamily()).contains(OdfStylePropertiesSet.TextProperties)) {
            Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "Text properties are not supported by style family: " + this.mOdfElement.getStyleFamily() + "!", "");
            return null;
        }
        if (this.mWritableTextProperties != null) {
            return this.mWritableTextProperties;
        }
        OdfStyle style = this.getStyleElementForWrite();
        this.mWritableTextProperties = TextProperties.getOrCreateTextProperties((OdfStyleBase)style);
        return this.mWritableTextProperties;
    }

    public TableCellProperties getTableCellPropertiesForRead() {
        if (!mFamilyProperties.get(this.mOdfElement.getStyleFamily()).contains(OdfStylePropertiesSet.TableCellProperties)) {
            Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "TableCell properties are not supported by style family: " + this.mOdfElement.getStyleFamily() + "!", "");
            return null;
        }
        if (this.mWritableTableCellProperties != null) {
            return this.mWritableTableCellProperties;
        }
        if (this.mTableCellProperties != null) {
            return this.mTableCellProperties;
        }
        OdfStyleBase style = this.getStyleElementForRead();
        if (style == null) {
            Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "No style definition is found!", "");
            return null;
        }
        this.mTableCellProperties = TableCellProperties.getTableCellProperties(style);
        if (this.mTableCellProperties != null) {
            return this.mTableCellProperties;
        }
        Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "No explicit table cell properties definition is found!", "");
        return null;
    }

    public TableCellProperties getTableCellPropertiesForWrite() {
        if (!mFamilyProperties.get(this.mOdfElement.getStyleFamily()).contains(OdfStylePropertiesSet.TableCellProperties)) {
            Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "TableCell properties are not supported by style family: " + this.mOdfElement.getStyleFamily() + "!", "");
            return null;
        }
        if (this.mWritableTableCellProperties != null) {
            return this.mWritableTableCellProperties;
        }
        OdfStyle style = this.getStyleElementForWrite();
        this.mWritableTableCellProperties = TableCellProperties.getOrCreateTableCellProperties((OdfStyleBase)style);
        return this.mWritableTableCellProperties;
    }

    public ParagraphProperties getParagraphPropertiesForRead() {
        if (!mFamilyProperties.get(this.mOdfElement.getStyleFamily()).contains(OdfStylePropertiesSet.ParagraphProperties)) {
            Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "Paragraph properties are not supported by style family: " + this.mOdfElement.getStyleFamily() + "!", "");
            return null;
        }
        if (this.mWritableParagraphProperties != null) {
            return this.mWritableParagraphProperties;
        }
        if (this.mParagraphProperties != null) {
            return this.mParagraphProperties;
        }
        OdfStyleBase style = this.getStyleElementForRead();
        if (style == null) {
            Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "No style definition is found!", "");
            return null;
        }
        this.mParagraphProperties = ParagraphProperties.getParagraphProperties(style);
        if (this.mParagraphProperties != null) {
            return this.mParagraphProperties;
        }
        Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "No explicit paragraph properties definition is found!", "");
        return null;
    }

    public ParagraphProperties getParagraphPropertiesForWrite() {
        if (!mFamilyProperties.get(this.mOdfElement.getStyleFamily()).contains(OdfStylePropertiesSet.ParagraphProperties)) {
            Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "Paragraph properties are not supported by style family: " + this.mOdfElement.getStyleFamily() + "!", "");
            return null;
        }
        if (this.mWritableParagraphProperties != null) {
            return this.mWritableParagraphProperties;
        }
        OdfStyle style = this.getStyleElementForWrite();
        this.mWritableParagraphProperties = ParagraphProperties.getOrCreateParagraphProperties((OdfStyleBase)style);
        return this.mWritableParagraphProperties;
    }

    public GraphicProperties getGraphicPropertiesForRead() {
        if (!mFamilyProperties.get(this.mOdfElement.getStyleFamily()).contains(OdfStylePropertiesSet.GraphicProperties)) {
            Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "Graphics properties are not supported by style family: " + this.mOdfElement.getStyleFamily() + "!", "");
            return null;
        }
        if (this.mWritableGraphicProperties != null) {
            return this.mWritableGraphicProperties;
        }
        if (this.mGraphicProperties != null) {
            return this.mGraphicProperties;
        }
        OdfStyleBase style = this.getStyleElementForRead();
        if (style == null) {
            Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "No style definition is found!", "");
            return null;
        }
        this.mGraphicProperties = GraphicProperties.getGraphicProperties(style);
        if (this.mGraphicProperties != null) {
            return this.mGraphicProperties;
        }
        Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "No explicit graphic properties definition is found!", "");
        return null;
    }

    public GraphicProperties getGraphicPropertiesForWrite() {
        if (!mFamilyProperties.get(this.mOdfElement.getStyleFamily()).contains(OdfStylePropertiesSet.GraphicProperties)) {
            Logger.getLogger(CellStyleHandler.class.getName()).log(Level.FINE, "Graphics properties are not supported by style family: " + this.mOdfElement.getStyleFamily() + "!", "");
            return null;
        }
        if (this.mWritableGraphicProperties != null) {
            return this.mWritableGraphicProperties;
        }
        OdfStyle style = this.getStyleElementForWrite();
        this.mWritableGraphicProperties = GraphicProperties.getOrCreateGraphicProperties((OdfStyleBase)style);
        return this.mWritableGraphicProperties;
    }

    protected String getUsedStyleName() {
        return this.mOdfElement.getStyleName();
    }

    protected OdfStyleBase getReadableStyleElementByName(String styleName) {
        OdfDefaultStyle defaultStyleElement = null;
        if (styleName == null || styleName.equals("")) {
            defaultStyleElement = this.mDocument.getDocumentStyles().getDefaultStyle(this.mOdfElement.getStyleFamily());
            this.isUseDefaultStyle = true;
            return defaultStyleElement;
        }
        OdfStyle styleElement = this.mOdfElement.getAutomaticStyles().getStyle(styleName, this.mOdfElement.getStyleFamily());
        if (styleElement == null) {
            styleElement = this.mDocument.getDocumentStyles().getStyle(styleName, this.mOdfElement.getStyleFamily());
        }
        if (styleElement == null) {
            styleElement = this.mOdfElement.getDocumentStyle();
        }
        if (styleElement == null) {
            return null;
        }
        return styleElement;
    }

    protected OdfStyle getWritableStyleElementByName(String styleName, boolean isShared) {
        boolean createNew = isShared;
        OdfStyle styleElement = null;
        OdfDefaultStyle defaultStyleElement = null;
        if (styleName == null || styleName.equals("")) {
            createNew = true;
            defaultStyleElement = this.mDocument.getDocumentStyles().getDefaultStyle(this.mOdfElement.getStyleFamily());
        } else {
            OdfOfficeAutomaticStyles styles = this.mOdfElement.getAutomaticStyles();
            styleElement = styles.getStyle(styleName, this.mOdfElement.getStyleFamily());
            if (styleElement == null && defaultStyleElement == null) {
                styleElement = this.mDocument.getDocumentStyles().getStyle(styleName, this.mOdfElement.getStyleFamily());
            }
            if (styleElement == null && defaultStyleElement == null) {
                styleElement = this.mOdfElement.getDocumentStyle();
            }
            if (styleElement == null || styleElement.getStyleUserCount() > 1) {
                createNew = true;
            }
        }
        if (createNew) {
            NamedNodeMap attributes;
            OdfStyle newStyle = this.mOdfElement.getAutomaticStyles().newStyle(this.mOdfElement.getStyleFamily());
            if (styleElement != null) {
                newStyle.setProperties(styleElement.getStylePropertiesDeep());
                attributes = styleElement.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attr = attributes.item(i);
                    if (attr.getNodeName().equals("style:name")) continue;
                    newStyle.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
                }
            } else if (defaultStyleElement != null) {
                newStyle.setProperties(defaultStyleElement.getStylePropertiesDeep());
                attributes = defaultStyleElement.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attr = attributes.item(i);
                    if (attr.getNodeName().equals("style:name")) continue;
                    newStyle.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
                }
                this.isUseDefaultStyle = true;
            }
            String newname = newStyle.getStyleNameAttribute();
            this.mOdfElement.setStyleName(newname);
            return newStyle;
        }
        return styleElement;
    }

    public OdfStyleBase getStyleElementForRead() {
        if (this.getCurrentUsedStyle() != null) {
            return this.getCurrentUsedStyle();
        }
        String styleName = this.getUsedStyleName();
        this.mStyleElement = this.getReadableStyleElementByName(styleName);
        return this.mStyleElement;
    }

    public OdfStyle getStyleElementForWrite() {
        if (this.mWritableStyleElement != null) {
            return this.mWritableStyleElement;
        }
        String styleName = this.getUsedStyleName();
        this.mWritableStyleElement = this.getWritableStyleElementByName(styleName, false);
        return this.mWritableStyleElement;
    }

    private OdfStyleBase getCurrentUsedStyle() {
        if (this.mWritableStyleElement != null) {
            return this.mWritableStyleElement;
        }
        return this.mStyleElement;
    }
}

