/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io;

import java.util.ArrayList;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IConnectionListener;
import org.apache.directory.studio.connection.core.IReferralHandler;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;

public class ConnectionWrapperUtils {
    public static Connection getReferralConnection(Referral referral, StudioProgressMonitor monitor, Object source) {
        Connection referralConnection = null;
        IReferralHandler referralHandler = ConnectionCorePlugin.getDefault().getReferralHandler();
        if (referralHandler != null && (referralConnection = referralHandler.getReferralConnection(new ArrayList<String>(referral.getLdapUrls()))) != null && !referralConnection.getConnectionWrapper().isConnected()) {
            referralConnection.getConnectionWrapper().connect(monitor);
            referralConnection.getConnectionWrapper().bind(monitor);
            for (IConnectionListener listener : ConnectionCorePlugin.getDefault().getConnectionListeners()) {
                listener.connectionOpened(referralConnection, monitor);
            }
            ConnectionEventRegistry.fireConnectionOpened(referralConnection, source);
        }
        return referralConnection;
    }
}

