/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor.text;

import org.apache.directory.studio.ldifeditor.LdifEditorActivator;
import org.apache.directory.studio.ldifparser.model.LdifEOFPart;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.LdifInvalidPart;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.lines.LdifLineBase;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifValueLineBase;
import org.apache.directory.studio.ldifparser.parser.LdifParser;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;

public class LdifDoubleClickStrategy
implements ITextDoubleClickStrategy {
    private static final int OFFSET = 0;
    private static final int LENGTH = 1;
    private DefaultTextDoubleClickStrategy delegateDoubleClickStrategy = new DefaultTextDoubleClickStrategy();

    public void doubleClicked(ITextViewer viewer) {
        if (!LdifEditorActivator.getDefault().getPreferenceStore().getBoolean("ldifEditorDoubleClickUserLdifDoubleClick")) {
            this.delegateDoubleClickStrategy.doubleClicked(viewer);
        } else {
            int cursorPos = viewer.getSelectedRange().x;
            if (cursorPos < 0) {
                return;
            }
            try {
                LdifParser parser = new LdifParser();
                IDocument document = viewer.getDocument();
                ITypedRegion partition = document.getPartition(cursorPos);
                int offset = partition.getOffset();
                int relativePos = cursorPos - offset;
                String s = document.get(partition.getOffset(), partition.getLength());
                LdifFile model = parser.parse(s);
                LdifContainer container = LdifFile.getContainer((LdifFile)model, (int)relativePos);
                if (container != null) {
                    LdifPart part = LdifFile.getContainerContent((LdifContainer)container, (int)relativePos);
                    if (!(part == null || part instanceof LdifSepLine || part instanceof LdifInvalidPart || part instanceof LdifEOFPart)) {
                        LdifValueLineBase line;
                        int[] range = null;
                        if (part instanceof LdifValueLineBase) {
                            line = (LdifValueLineBase)part;
                            range = this.getRange(relativePos, part.getOffset(), new String[]{line.getRawLineStart(), line.getRawValueType(), line.getRawValue()});
                        } else if (part instanceof LdifLineBase) {
                            line = (LdifLineBase)part;
                            range = new int[]{part.getOffset(), part.getLength() - line.getRawNewLine().length()};
                        }
                        int start = range != null ? range[0] : part.getOffset();
                        int length = range != null ? range[1] : part.getLength();
                        viewer.setSelectedRange(start += offset, length);
                    } else {
                        this.delegateDoubleClickStrategy.doubleClicked(viewer);
                    }
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private int[] getRange(int pos, int offset, String[] parts) {
        int i = 0;
        while (i < parts.length) {
            if (parts[i] != null) {
                if (pos < offset + parts[i].length()) {
                    return new int[]{offset, parts[i].length()};
                }
                offset += parts[i].length();
            }
            ++i;
        }
        return null;
    }
}

