/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.actions;

import java.text.MessageFormat;
import org.apache.directory.studio.Messages;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private String filterPath;

    public OpenFileAction() {
        this.setId("org.apache.directory.studio.openFile");
        this.setText(Messages.getString("OpenFileAction.Open_File"));
        this.setToolTipText(Messages.getString("OpenFileAction.Open_file_from_filesystem"));
        this.setEnabled(true);
    }

    public OpenFileAction(IWorkbenchWindow window) {
        this();
        this.init(window);
    }

    public void dispose() {
        this.window = null;
        this.filterPath = null;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        this.filterPath = System.getProperty("user.home");
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run() {
        FileDialog dialog = new FileDialog(this.window.getShell(), 4098);
        dialog.setText(Messages.getString("OpenFileAction.Open_File"));
        dialog.setFilterPath(this.filterPath);
        dialog.open();
        String[] names = dialog.getFileNames();
        if (names != null) {
            this.filterPath = dialog.getFilterPath();
            int numberOfFilesNotFound = 0;
            StringBuffer notFound = new StringBuffer();
            IWorkbenchPage page = this.window.getActivePage();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(this.filterPath)).getChild(name);
                IFileInfo fetchInfo = fileStore.fetchInfo();
                if (!fetchInfo.isDirectory() && fetchInfo.exists()) {
                    try {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    }
                    catch (PartInitException e) {
                        MessageDialog.openError((Shell)this.window.getShell(), (String)Messages.getString("OpenFileAction.Error"), (String)e.getMessage());
                    }
                } else {
                    if (++numberOfFilesNotFound > 1) {
                        notFound.append('\n');
                    }
                    notFound.append(fileStore.getName());
                }
                ++n2;
            }
            if (numberOfFilesNotFound > 0) {
                String msg = MessageFormat.format(numberOfFilesNotFound == 1 ? Messages.getString("OpenFileAction.File_not_found") : Messages.getString("OpenFileAction.Files_not_found"), notFound.toString());
                MessageDialog.openError((Shell)this.window.getShell(), (String)Messages.getString("OpenFileAction.Error"), (String)msg);
            }
        }
    }
}

