/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.entry;

import java.util.List;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.entryeditors.EntryEditorInput;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.apache.directory.studio.ldapbrowser.core.utils.AttributeComparator;
import org.apache.directory.studio.ldapbrowser.core.utils.CompoundModification;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.LdifEntryEditor;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.Messages;
import org.apache.directory.studio.ldifeditor.editor.LdifDocumentProvider;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifInvalidContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;

public class LdifEntryEditorDocumentProvider
extends LdifDocumentProvider {
    private EntryEditorInput input;
    private boolean inSetContent = false;
    private LdifEntryEditor editor;

    public LdifEntryEditorDocumentProvider(LdifEntryEditor editor) {
        this.editor = editor;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        LdifRecord[] records = this.getLdifModel().getRecords();
        if (records.length != 1 || !(records[0] instanceof LdifContentRecord)) {
            throw new CoreException((IStatus)new Status(4, BrowserUIConstants.PLUGIN_ID, Messages.getString("LdifEntryEditorDocumentProvider.InvalidRecordType")));
        }
        if (!records[0].isValid()) {
            throw new CoreException((IStatus)new Status(4, BrowserUIConstants.PLUGIN_ID, NLS.bind((String)Messages.getString("LdifEntryEditorDocumentProvider.InvalidLdif"), (Object)records[0].getInvalidString())));
        }
        for (LdifContainer ldifContainer : this.getLdifModel().getContainers()) {
            if (!(ldifContainer instanceof LdifInvalidContainer)) continue;
            LdifInvalidContainer cont = (LdifInvalidContainer)ldifContainer;
            throw new CoreException((IStatus)new Status(4, BrowserUIConstants.PLUGIN_ID, NLS.bind((String)Messages.getString("LdifEntryEditorDocumentProvider.InvalidLdif"), (Object)cont.getInvalidString())));
        }
        EntryEditorInput input = this.getEntryEditorInput(element);
        try {
            Dn newDn = new Dn(new String[]{records[0].getDnLine().getValueAsString()});
            if (!newDn.equals((Object)input.getResolvedEntry().getDn())) {
                throw new CoreException((IStatus)new Status(4, BrowserUIConstants.PLUGIN_ID, NLS.bind((String)Messages.getString("LdifEntryEditorDocumentProvider.ModDnNotSupported"), (Object)records[0].getInvalidString())));
            }
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {
            throw new CoreException((IStatus)new Status(4, BrowserUIConstants.PLUGIN_ID, Messages.getString("LdifEntryEditorDocumentProvider.InvalidDN")));
        }
        IStatus status = input.saveSharedWorkingCopy(false, this.editor);
        if (status != null && !status.isOK()) {
            BrowserUIPlugin.getDefault().getLog().log(status);
            throw new CoreException(status);
        }
    }

    public void documentChanged(DocumentEvent event) {
        super.documentChanged(event);
        if (this.inSetContent) {
            return;
        }
        LdifRecord[] records = this.getLdifModel().getRecords();
        if (!(records.length == 1 && records[0] instanceof LdifContentRecord && records[0].isValid() && records[0].getDnLine().isValid())) {
            return;
        }
        for (LdifContainer ldifContainer : this.getLdifModel().getContainers()) {
            if (!(ldifContainer instanceof LdifInvalidContainer)) continue;
            return;
        }
        try {
            LdifContentRecord modifiedRecord = (LdifContentRecord)records[0];
            IBrowserConnection browserConnection = this.input.getSharedWorkingCopy(this.editor).getBrowserConnection();
            DummyEntry modifiedEntry = ModelConverter.ldifContentRecordToEntry((LdifContentRecord)modifiedRecord, (IBrowserConnection)browserConnection);
            ((DummyEntry)this.input.getSharedWorkingCopy(this.editor)).setDn(modifiedEntry.getDn());
            new CompoundModification().replaceAttributes((IEntry)modifiedEntry, this.input.getSharedWorkingCopy(this.editor), (Object)this);
        }
        catch (LdapInvalidDnException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doResetDocument(Object element, IProgressMonitor monitor) throws CoreException {
        if (this.input != null) {
            this.input.resetSharedWorkingCopy(this.editor);
        }
        super.doResetDocument(element, monitor);
    }

    public void workingCopyModified(EntryEditorInput input, Object source) {
        if (source == this) {
            return;
        }
        IDocument document = this.getDocument(input);
        if (document != null) {
            try {
                try {
                    this.inSetContent = true;
                    IEntry sharedWorkingCopy = input.getSharedWorkingCopy(this.editor);
                    this.setDocumentInput(document, sharedWorkingCopy);
                    if (!input.isSharedWorkingCopyDirty(this.editor)) {
                        super.doResetDocument((Object)input, null);
                    }
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.inSetContent = false;
            }
        }
    }

    private void setDocumentInput(IDocument document, IEntry entry) {
        List sortedValues = AttributeComparator.toSortedValues((IEntry)entry);
        LdifContentRecord newRecord = LdifContentRecord.create((String)entry.getDn().getName());
        for (IValue value : sortedValues) {
            newRecord.addAttrVal(ModelConverter.valueToLdifAttrValLine((IValue)value));
        }
        newRecord.finish(LdifSepLine.create());
        String newContent = newRecord.toFormattedString(Utils.getLdifFormatParameters());
        document.set(newContent);
    }

    public IDocument getDocument(Object element) {
        EntryEditorInput input;
        if (element instanceof EntryEditorInput && (input = (EntryEditorInput)element).getExtension() == null) {
            return null;
        }
        return super.getDocument(element);
    }

    protected IDocument createDocument(Object element) throws CoreException {
        this.input = this.getEntryEditorInput(element);
        IEntry entry = this.getEntryEditorInput(element).getSharedWorkingCopy(this.editor);
        Document document = new Document();
        if (entry != null) {
            this.setDocumentInput((IDocument)document, entry);
        }
        this.setupDocument((IDocument)document);
        return document;
    }

    private EntryEditorInput getEntryEditorInput(Object element) throws CoreException {
        if (element instanceof EntryEditorInput) {
            EntryEditorInput input = (EntryEditorInput)element;
            return input;
        }
        throw new CoreException((IStatus)new Status(4, BrowserUIConstants.PLUGIN_ID, "Expected EntryEditorInput, was " + element));
    }

    public boolean isModifiable(Object element) {
        if (element instanceof EntryEditorInput) {
            EntryEditorInput editorInput = (EntryEditorInput)element;
            IEntry entry = editorInput.getSharedWorkingCopy(this.editor);
            return entry != null;
        }
        return false;
    }
}

