/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.rest;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.fortress.core.AuditMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.model.AuthZ;
import org.apache.directory.fortress.core.model.Bind;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.Mod;
import org.apache.directory.fortress.core.model.UserAudit;
import org.apache.directory.fortress.core.rest.RestUtils;
import org.apache.directory.fortress.core.util.VUtil;

public class AuditMgrRestImpl
extends Manageable
implements AuditMgr {
    private static final String CLS_NM = AuditMgrRestImpl.class.getName();

    @Override
    public List<AuthZ> getUserAuthZs(UserAudit uAudit) throws SecurityException {
        List<AuthZ> outRecords;
        VUtil.assertNotNull(uAudit, 7001, CLS_NM + ".getUserAuthZs");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(uAudit);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "auditUserAuthzs");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() == 0) {
            outRecords = response.getEntities();
            if (outRecords == null) {
                outRecords = new ArrayList<AuthZ>();
            }
        } else {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        return outRecords;
    }

    @Override
    public List<AuthZ> searchAuthZs(UserAudit uAudit) throws SecurityException {
        List<AuthZ> outRecords;
        VUtil.assertNotNull(uAudit, 7001, CLS_NM + ".searchAuthZs");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(uAudit);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "auditAuthzs");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() == 0) {
            outRecords = response.getEntities();
            if (outRecords == null) {
                outRecords = new ArrayList<AuthZ>();
            }
        } else {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        return outRecords;
    }

    @Override
    public List<Bind> searchBinds(UserAudit uAudit) throws SecurityException {
        List<Bind> outRecords;
        VUtil.assertNotNull(uAudit, 7001, CLS_NM + ".searchBinds");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(uAudit);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "auditBinds");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() == 0) {
            outRecords = response.getEntities();
            if (outRecords == null) {
                outRecords = new ArrayList<Bind>();
            }
        } else {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        return outRecords;
    }

    @Override
    public List<Mod> searchUserSessions(UserAudit uAudit) throws SecurityException {
        List<Mod> outRecords;
        VUtil.assertNotNull(uAudit, 7001, CLS_NM + ".searchUserSessions");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(uAudit);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "auditSessions");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() == 0) {
            outRecords = response.getEntities();
            if (outRecords == null) {
                outRecords = new ArrayList<Mod>();
            }
        } else {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        return outRecords;
    }

    @Override
    public List<Mod> searchAdminMods(UserAudit uAudit) throws SecurityException {
        List<Mod> outRecords;
        VUtil.assertNotNull(uAudit, 7001, CLS_NM + ".searchAdminMods");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(uAudit);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "auditMods");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() == 0) {
            outRecords = response.getEntities();
            if (outRecords == null) {
                outRecords = new ArrayList<Mod>();
            }
        } else {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        return outRecords;
    }

    @Override
    public List<AuthZ> searchInvalidUsers(UserAudit uAudit) throws SecurityException {
        List<AuthZ> outRecords;
        VUtil.assertNotNull(uAudit, 7001, CLS_NM + ".searchInvalidUsers");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(uAudit);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "auditInvld");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() == 0) {
            outRecords = response.getEntities();
            if (outRecords == null) {
                outRecords = new ArrayList<AuthZ>();
            }
        } else {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        return outRecords;
    }
}

