/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name="fortAddress")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="address", propOrder={"addresses", "city", "state", "country", "postalCode", "postOfficeBox", "building", "departmentNumber", "roomNumber"})
public class Address
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> addresses;
    private String city;
    private String state;
    private String country;
    private String postalCode;
    private String postOfficeBox;
    private String building;
    private String departmentNumber;
    private String roomNumber;

    public void setAddress(String address) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.add(address);
    }

    public List<String> getAddresses() {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        return this.addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getPostOfficeBox() {
        return this.postOfficeBox;
    }

    public void setPostOfficeBox(String postOfficeBox) {
        this.postOfficeBox = postOfficeBox;
    }

    public String getBuilding() {
        return this.building;
    }

    public void setBuilding(String building) {
        this.building = building;
    }

    public String getDepartmentNumber() {
        return this.departmentNumber;
    }

    public void setDepartmentNumber(String departmentNumber) {
        this.departmentNumber = departmentNumber;
    }

    public String getRoomNumber() {
        return this.roomNumber;
    }

    public void setRoomNumber(String roomNumber) {
        this.roomNumber = roomNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        if (this.addresses != null ? !this.addresses.equals(address.addresses) : address.addresses != null) {
            return false;
        }
        if (this.building != null ? !this.building.equals(address.building) : address.building != null) {
            return false;
        }
        if (this.city != null ? !this.city.equals(address.city) : address.city != null) {
            return false;
        }
        if (this.country != null ? !this.country.equals(address.country) : address.country != null) {
            return false;
        }
        if (this.departmentNumber != null ? !this.departmentNumber.equals(address.departmentNumber) : address.departmentNumber != null) {
            return false;
        }
        if (this.postOfficeBox != null ? !this.postOfficeBox.equals(address.postOfficeBox) : address.postOfficeBox != null) {
            return false;
        }
        if (this.postalCode != null ? !this.postalCode.equals(address.postalCode) : address.postalCode != null) {
            return false;
        }
        if (this.roomNumber != null ? !this.roomNumber.equals(address.roomNumber) : address.roomNumber != null) {
            return false;
        }
        return !(this.state == null ? address.state != null : !this.state.equals(address.state));
    }

    public int hashCode() {
        int result = this.addresses != null ? this.addresses.hashCode() : 0;
        result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
        result = 31 * result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
        result = 31 * result + (this.postOfficeBox != null ? this.postOfficeBox.hashCode() : 0);
        result = 31 * result + (this.building != null ? this.building.hashCode() : 0);
        result = 31 * result + (this.departmentNumber != null ? this.departmentNumber.hashCode() : 0);
        result = 31 * result + (this.roomNumber != null ? this.roomNumber.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Address object: \n");
        if (this.roomNumber != null) {
            sb.append("    roomNumber :").append(this.roomNumber).append('\n');
        }
        if (this.departmentNumber != null) {
            sb.append("    departmentNumber :").append(this.departmentNumber).append('\n');
        }
        if (this.building != null) {
            sb.append("    building :").append(this.building).append('\n');
        }
        if (this.addresses != null) {
            sb.append("    addresses : ");
            boolean isFirst = true;
            for (String addr : this.addresses) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(addr);
            }
            sb.append('\n');
        }
        if (this.city != null) {
            sb.append("    city :").append(this.city).append('\n');
        }
        if (this.postalCode != null) {
            sb.append("    postalCode :").append(this.postalCode).append('\n');
        }
        if (this.postOfficeBox != null) {
            sb.append("    postOfficeBox :").append(this.postOfficeBox).append('\n');
        }
        if (this.state != null) {
            sb.append("    state :").append(this.state).append('\n');
        }
        if (this.country != null) {
            sb.append("    country :").append(this.country).append('\n');
        }
        return sb.toString();
    }
}

