/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.fortress.annotation.AdminPermissionOperation;
import org.apache.directory.fortress.core.AccessMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.GroupP;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.impl.PermP;
import org.apache.directory.fortress.core.impl.RoleUtil;
import org.apache.directory.fortress.core.impl.SDUtil;
import org.apache.directory.fortress.core.impl.UserP;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.RoleConstraint;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.VUtil;

public class AccessMgrImpl
extends Manageable
implements AccessMgr,
Serializable {
    private static final String CLS_NM = AccessMgrImpl.class.getName();
    private static final UserP userP = new UserP();
    private static final GroupP groupP = new GroupP();
    private static final PermP permP = new PermP();

    @Override
    public Session authenticate(String userId, String password) throws SecurityException {
        String methodName = "authenticate";
        VUtil.assertNotNullOrEmpty(userId, 1006, this.getFullMethodName(CLS_NM, methodName));
        VUtil.assertNotNullOrEmpty(password, 1009, this.getFullMethodName(CLS_NM, methodName));
        User inUser = new User(userId);
        inUser.setContextId(this.contextId);
        User user = userP.read(inUser, false);
        user.setPassword(password);
        user.setContextId(this.contextId);
        Session ftSess = userP.authenticate(user);
        ftSess.setUser(user);
        return ftSess;
    }

    @Override
    public Session createSession(User user, boolean isTrusted) throws SecurityException {
        String methodName = "createSession";
        this.assertContext(CLS_NM, methodName, user, 1008);
        return userP.createSession(user, isTrusted);
    }

    @Override
    public Session createSession(User user, List<RoleConstraint> constraints, boolean isTrusted) throws SecurityException {
        String methodName = "createSession";
        this.assertContext(CLS_NM, methodName, user, 1008);
        VUtil.assertNotNull(constraints, 5102, methodName);
        return userP.createSession(user, constraints, isTrusted);
    }

    @Override
    public Session createSession(Group group) throws SecurityException {
        String methodName = "createSession";
        this.assertContext(CLS_NM, methodName, group, 10308);
        return groupP.createSession(group);
    }

    @Override
    @AdminPermissionOperation
    public boolean checkAccess(Session session, Permission perm) throws SecurityException {
        String methodName = "checkAccess";
        this.assertContext(CLS_NM, methodName, perm, 3008);
        this.assertContext(CLS_NM, methodName, session, 1030);
        VUtil.assertNotNullOrEmpty(perm.getOpName(), 3009, this.getFullMethodName(CLS_NM, methodName));
        VUtil.assertNotNullOrEmpty(perm.getObjName(), 3010, this.getFullMethodName(CLS_NM, methodName));
        VUtil.getInstance().validateConstraints(session, VUtil.ConstraintType.USER, false);
        VUtil.getInstance().validateConstraints(session, VUtil.ConstraintType.ROLE, false);
        this.setEntitySession(CLS_NM, methodName, session);
        return permP.checkPermission(session, perm);
    }

    @Override
    @AdminPermissionOperation
    public boolean checkAccess(User user, Permission perm, boolean isTrusted) throws SecurityException {
        Session session = this.createSession(user, isTrusted);
        return this.checkAccess(session, perm);
    }

    @Override
    public boolean isUserInRole(User user, Role role, boolean isTrusted) throws SecurityException {
        String methodName = "isUserInRole";
        this.assertContext(CLS_NM, methodName, role, 5007);
        VUtil.assertNotNullOrEmpty(role.getName(), 5005, this.getFullMethodName(CLS_NM, methodName));
        boolean result = false;
        Session session = this.createSession(user, isTrusted);
        List<UserRole> sRoles = session.getRoles();
        UserRole uRole = new UserRole(user.getUserId(), role.getName());
        if (sRoles != null && sRoles.contains(uRole)) {
            result = true;
        }
        return result;
    }

    @Override
    @AdminPermissionOperation
    public List<Permission> sessionPermissions(Session session) throws SecurityException {
        String methodName = "sessionPermissions";
        this.assertContext(CLS_NM, methodName, session, 1030);
        VUtil.getInstance().validateConstraints(session, VUtil.ConstraintType.USER, false);
        VUtil.getInstance().validateConstraints(session, VUtil.ConstraintType.ROLE, false);
        this.setEntitySession(CLS_NM, methodName, session);
        return permP.search(session);
    }

    @Override
    @AdminPermissionOperation
    public List<UserRole> sessionRoles(Session session) throws SecurityException {
        String methodName = "sessionRoles";
        this.assertContext(CLS_NM, methodName, session, 1030);
        VUtil.getInstance().validateConstraints(session, VUtil.ConstraintType.USER, false);
        VUtil.getInstance().validateConstraints(session, VUtil.ConstraintType.ROLE, false);
        this.setEntitySession(CLS_NM, methodName, session);
        return session.getRoles();
    }

    @Override
    @AdminPermissionOperation
    public Set<String> authorizedRoles(Session session) throws SecurityException {
        String methodName = "authorizedRoles";
        this.assertContext(CLS_NM, methodName, session, 1030);
        if (session.isGroupSession()) {
            VUtil.assertNotNull(session.getGroup(), 10308, CLS_NM + ".authorizedRoles");
        } else {
            VUtil.assertNotNull(session.getUser(), 1008, CLS_NM + ".authorizedRoles");
        }
        VUtil.getInstance().validateConstraints(session, VUtil.ConstraintType.USER, false);
        VUtil.getInstance().validateConstraints(session, VUtil.ConstraintType.ROLE, false);
        this.setEntitySession(CLS_NM, methodName, session);
        return RoleUtil.getInstance().getInheritedRoles(session.getRoles(), this.contextId);
    }

    @Override
    public void addActiveRole(Session session, UserRole role) throws SecurityException {
        int indx;
        List<UserRole> assignedRoles;
        String methodName = "addActiveRole";
        this.assertContext(CLS_NM, methodName, session, 1030);
        this.assertContext(CLS_NM, methodName, role, 5007);
        String entityId = session.isGroupSession() ? session.getGroupName() : session.getUserId();
        role.setUserId(entityId);
        List<UserRole> sRoles = session.getRoles();
        if (sRoles != null && sRoles.contains(role)) {
            String info = this.getFullMethodName(CLS_NM, methodName) + " Entity [" + entityId + "] Role [" + role.getName() + "] role already activated.";
            throw new SecurityException(2011, info);
        }
        if (session.isGroupSession()) {
            Group inGroup = new Group(session.getGroupName());
            inGroup.setContextId(this.contextId);
            Group ge = groupP.read(inGroup);
            assignedRoles = ge.getRoles();
        } else {
            User inUser = new User(session.getUserId());
            inUser.setContextId(this.contextId);
            User ue = userP.read(inUser, true);
            assignedRoles = ue.getRoles();
        }
        if (CollectionUtils.isEmpty(assignedRoles) || (indx = assignedRoles.indexOf(role)) == -1) {
            String info = this.getFullMethodName(CLS_NM, methodName) + " Role [" + role.getName() + "] Entity [" + entityId + "] role not authorized for entity.";
            throw new SecurityException(2006, info);
        }
        SDUtil.getInstance().validateDSD(session, role);
        session.setRole(assignedRoles.get(indx));
        VUtil.getInstance().validateConstraints(session, VUtil.ConstraintType.ROLE, false);
    }

    @Override
    public void dropActiveRole(Session session, UserRole role) throws SecurityException {
        String methodName = "dropActiveRole";
        this.assertContext(CLS_NM, methodName, session, 1030);
        this.assertContext(CLS_NM, methodName, role, 5007);
        String entityId = session.isGroupSession() ? session.getGroupName() : session.getUserId();
        role.setUserId(entityId);
        List<UserRole> activatedRoles = session.getRoles();
        VUtil.assertNotNull(activatedRoles, 2007, CLS_NM + this.getFullMethodName(CLS_NM, methodName));
        int indx = activatedRoles.indexOf(role);
        if (indx == -1) {
            String info = this.getFullMethodName(CLS_NM, methodName) + " Role [" + role.getName() + "] Entity [" + session.getUserId() + "], not previously activated";
            throw new SecurityException(2022, info);
        }
        activatedRoles.remove(role);
    }

    @Override
    public String getUserId(Session session) throws SecurityException {
        this.assertContext(CLS_NM, "getUserId", session, 1030);
        return session.getUserId();
    }

    @Override
    public User getUser(Session session) throws SecurityException {
        this.assertContext(CLS_NM, "getUser", session, 1030);
        return session.getUser();
    }
}

