/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.util;

import java.io.InputStream;
import org.apache.directory.api.util.Strings;
import org.apache.directory.fortress.core.CfgException;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static Object createInstance(String className) throws CfgException {
        Object target;
        try {
            if (Strings.isEmpty((String)className)) {
                String error = "createInstance() null or empty classname";
                throw new CfgException(106, error);
            }
            target = Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException e) {
            String error = "createInstance() className [" + className + "] caught java.lang.ClassNotFoundException=" + e;
            throw new CfgException(103, error, e);
        }
        catch (InstantiationException e) {
            String error = "createInstance()  [" + className + "] caught java.lang.InstantiationException=" + e;
            throw new CfgException(104, error, e);
        }
        catch (IllegalAccessException e) {
            String error = "createInstance()  [" + className + "] caught java.lang.IllegalAccessException=" + e;
            throw new CfgException(105, error, e);
        }
        return target;
    }

    public static InputStream resourceAsStream(String name) throws CfgException {
        InputStream is = ClassUtil.class.getClassLoader().getResourceAsStream(name);
        if (is == null) {
            throw new CfgException(128, name);
        }
        return is;
    }
}

