/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.fortress.core.CreateException;
import org.apache.directory.fortress.core.RemoveException;
import org.apache.directory.fortress.core.ldap.LdapDataProvider;
import org.apache.directory.fortress.core.model.OrganizationalUnit;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OrganizationalUnitDAO
extends LdapDataProvider {
    private static final String CLS_NM = OrganizationalUnitDAO.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);

    OrganizationalUnitDAO() {
    }

    void create(OrganizationalUnit oe) throws CreateException {
        LdapConnection ld = null;
        String nodeDn = "ou=" + oe.getName() + ",";
        if (StringUtils.isNotEmpty((String)oe.getParent())) {
            nodeDn = nodeDn + "ou=" + oe.getParent() + ",";
        }
        nodeDn = nodeDn + this.getRootDn(oe.getContextId());
        try {
            LOG.info("create container dn [{}]", (Object)nodeDn);
            DefaultEntry myEntry = new DefaultEntry(nodeDn, new Object[]{"ObjectCLass", "organizationalUnit", "ou", oe.getName(), "description", oe.getDescription()});
            ld = this.getAdminConnection();
            this.add(ld, (Entry)myEntry);
        }
        catch (LdapException e) {
            try {
                String error = "create container node dn [" + nodeDn + "] caught LdapException=" + e;
                throw new CreateException(6001, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
    }

    void remove(OrganizationalUnit oe) throws RemoveException {
        LdapConnection ld = null;
        String nodeDn = "ou=" + oe.getName() + ",";
        if (StringUtils.isNotEmpty((String)oe.getParent())) {
            nodeDn = nodeDn + "ou=" + oe.getParent() + ",";
        }
        nodeDn = nodeDn + OrganizationalUnitDAO.getRootDn(oe.getContextId(), "suffix");
        LOG.info("remove container dn [{}]", (Object)nodeDn);
        try {
            ld = this.getAdminConnection();
            this.deleteRecursive(ld, nodeDn);
        }
        catch (CursorException e) {
            String error = "remove container node dn [" + nodeDn + "] caught CursorException=" + e.getMessage();
            throw new RemoveException(6002, error, (Exception)((Object)e));
        }
        catch (LdapException e) {
            String error = "remove container node dn [" + nodeDn + "] caught LDAPException=" + e;
            throw new RemoveException(6002, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }
}

