/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.resourceloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import org.apache.deltaspike.core.api.resourceloader.AbstractResourceProvider;
import org.apache.deltaspike.core.api.resourceloader.InjectableResource;
import org.apache.deltaspike.core.util.ClassUtils;

@ApplicationScoped
public class ClasspathResourceProvider
extends AbstractResourceProvider {
    private static final Logger logger = Logger.getLogger(ClasspathResourceProvider.class.getName());

    @Override
    public InputStream readStream(InjectableResource injectableResource) {
        try {
            List<InputStream> matchedStreams = this.readClassPath(injectableResource.location(), true);
            return matchedStreams.get(0);
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Problem reading resource.", e);
            }
            return null;
        }
    }

    @Override
    public List<InputStream> readStreams(InjectableResource injectableResource) {
        try {
            return this.readClassPath(injectableResource.location(), false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while trying to load resources from classpath ", e);
        }
    }

    private List<InputStream> readClassPath(String name, boolean requireUnique) throws IllegalStateException, IOException {
        Enumeration<URL> urls = ClassUtils.getClassLoader(null).getResources(name);
        ArrayList<URL> urlList = new ArrayList<URL>();
        ArrayList<InputStream> results = new ArrayList<InputStream>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream is = url.openStream();
            if (is == null) continue;
            results.add(is);
            urlList.add(url);
        }
        if (requireUnique && results.size() != 1) {
            String msg = this.urlsToString(urlList, name);
            for (InputStream is : results) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "Unable to close stream", e);
                }
            }
            throw new IllegalStateException(msg);
        }
        return results;
    }

    private String urlsToString(List<URL> urls, String name) {
        if (urls.isEmpty()) {
            return String.format("No resources found for '%s'", name);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("multiple resources found for '%s'", name));
        for (URL u : urls) {
            sb.append(" Match : ").append(u.toExternalForm());
        }
        return sb.toString();
    }
}

