/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.testcontrol.impl.mock;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.testcontrol.api.junit.TestBaseConfig;
import org.apache.deltaspike.testcontrol.api.mock.DynamicMockManager;
import org.apache.deltaspike.testcontrol.api.mock.TypedMock;
import org.apache.deltaspike.testcontrol.impl.mock.BeanCacheKey;

public abstract class AbstractMockManager
implements DynamicMockManager {
    private Map<BeanCacheKey, Object> registeredMocks = new HashMap<BeanCacheKey, Object>();

    public void addMock(Object mockInstance, Annotation ... qualifiers) {
        if (!TestBaseConfig.MockIntegration.ALLOW_MOCKED_BEANS.booleanValue() && !TestBaseConfig.MockIntegration.ALLOW_MOCKED_PRODUCERS.booleanValue()) {
            throw new IllegalStateException("The support for mocked CDI-Beans is disabled due to a reduced portability across different CDI-implementations. Please set 'deltaspike.testcontrol.mock-support.allow_mocked_beans' and/or 'deltaspike.testcontrol.mock-support.allow_mocked_producers' to 'true' (in 'META-INF/apache-deltaspike.properties') on your test-classpath.");
        }
        Class<?> mockClass = mockInstance.getClass();
        Class<?> beanClass = mockClass.getSuperclass();
        if (beanClass == null) {
            beanClass = mockClass;
        }
        if (Object.class.equals(beanClass)) {
            throw new IllegalArgumentException(mockInstance.getClass().getName() + " isn't a supported approach for mocking -> please extend from the original class.");
        }
        TypedMock typedMock = mockClass.getAnnotation(TypedMock.class);
        if (typedMock == null) {
            typedMock = beanClass.getAnnotation(TypedMock.class);
        }
        Class[] specifiedTypes = null;
        if (typedMock != null) {
            specifiedTypes = typedMock.value();
        } else {
            Typed typed = mockClass.getAnnotation(Typed.class);
            if (typed == null || typed.value().length == 0) {
                typed = beanClass.getAnnotation(Typed.class);
            }
            if (typed != null && typed.value().length > 0) {
                specifiedTypes = typed.value();
            }
        }
        if (specifiedTypes != null) {
            for (Class typedClass : specifiedTypes) {
                this.registeredMocks.put(new BeanCacheKey(typedClass, qualifiers), mockInstance);
            }
        } else {
            this.registeredMocks.put(new BeanCacheKey(beanClass, qualifiers), mockInstance);
        }
    }

    public <T> T getMock(Class<T> beanClass, Annotation ... qualifiers) {
        return (T)this.registeredMocks.get(new BeanCacheKey(beanClass, qualifiers));
    }

    public void reset() {
        this.registeredMocks.clear();
    }
}

