/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.template.velocity;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.option.Option;
import org.apache.torque.generator.option.Options;
import org.apache.torque.generator.outlet.OutletResult;
import org.apache.torque.generator.qname.Namespace;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.qname.QualifiedNameMap;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.template.TemplateOutletImpl;
import org.apache.torque.generator.template.velocity.TorqueGenVelocity;
import org.apache.torque.generator.template.velocity.VelocityTemplateFilter;
import org.apache.torque.generator.variable.Variable;
import org.apache.torque.generator.variable.VariableStore;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.util.StringUtils;

public class VelocityOutlet
extends TemplateOutletImpl {
    public static final String TORQUE_GEN_CONTEXT_NAME = "torqueGen";
    public static final String STRING_UTILS_CONTEXT_NAME = "stringUtils";
    public static final String NULL_KEY_CONTEXT_NAME = "value";
    private static Logger log = LogManager.getLogger(VelocityOutlet.class);
    private boolean optionsInContext = true;
    private boolean variablesInContext = true;
    private boolean sourceAttributesInContext = true;

    public VelocityOutlet(QualifiedName name, ConfigurationProvider configurationProvider, String path, String encoding) throws ConfigurationException {
        super(name, configurationProvider, path, encoding, new VelocityTemplateFilter());
    }

    public void setOptionsInContext(boolean optionsInContext) {
        this.optionsInContext = optionsInContext;
    }

    public boolean isOptionsInContext() {
        return this.optionsInContext;
    }

    public void setVariablesInContext(boolean variablesInContext) {
        this.variablesInContext = variablesInContext;
    }

    public boolean isVariablesInContext() {
        return this.variablesInContext;
    }

    public void setSourceAttributesInContext(boolean sourceAttributesInContext) {
        this.sourceAttributesInContext = sourceAttributesInContext;
    }

    public boolean isSourceAttributesInContext() {
        return this.sourceAttributesInContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutletResult execute(ControllerState controllerState) throws GeneratorException {
        if (log.isDebugEnabled()) {
            log.debug("Start executing VelocityOutlet " + String.valueOf(this.getName()));
        }
        try {
            try {
                Properties properties = new Properties();
                properties.put("runtime.conversion.handler", "none");
                properties.put("parser.space_gobbling", "bc");
                properties.put("directive.if.empty_check", "false");
                Velocity.init((Properties)properties);
            }
            catch (Exception e) {
                throw new GeneratorException("Could not initialize velocity", e);
            }
            Context context = this.createVelocityContext(controllerState);
            StringWriter writer = new StringWriter();
            try {
                Velocity.evaluate((Context)context, (Writer)writer, (String)("VelocityTemplateOutlet:" + String.valueOf(this.getName())), (String)this.getContent(controllerState));
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (Exception e) {
                log.error("error during execution of outlet " + String.valueOf(this.getName()) + " : " + e.getMessage(), (Throwable)e);
                throw new GeneratorException("Error during execution of outlet " + String.valueOf(this.getName()) + " : " + e.getMessage(), e);
            }
            OutletResult outletResult = new OutletResult(((Object)writer).toString());
            return outletResult;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("End executing VelocityOutlet " + String.valueOf(this.getName()));
            }
        }
    }

    private Context createVelocityContext(ControllerState controllerState) {
        VelocityContext context = new VelocityContext();
        context.put(TORQUE_GEN_CONTEXT_NAME, (Object)new TorqueGenVelocity(this, controllerState));
        context.put(STRING_UTILS_CONTEXT_NAME, (Object)new StringUtils());
        if (this.optionsInContext) {
            Options visibleOptions = controllerState.getVisibleOptions();
            for (Option option : visibleOptions.values()) {
                QualifiedName qualifiedName = option.getQualifiedName();
                context.put(qualifiedName.getName(), option.getValue());
            }
            log.debug("Put options in context " + String.valueOf(visibleOptions.keySet()));
        } else {
            log.debug("options in context are disabled");
        }
        Object model = controllerState.getModel();
        SourceElement sourceElement = null;
        if (model instanceof SourceElement) {
            sourceElement = (SourceElement)model;
        }
        if (this.sourceAttributesInContext && sourceElement != null) {
            Set<String> attributes = sourceElement.getAttributeNames();
            for (String key : attributes) {
                Object value = sourceElement.getAttribute(key);
                if (key == null) {
                    if (sourceElement.getAttributeNames().contains(NULL_KEY_CONTEXT_NAME)) continue;
                    key = NULL_KEY_CONTEXT_NAME;
                }
                context.put(key, value);
            }
            log.debug("Put attributes in context " + String.valueOf(attributes));
        } else {
            log.debug("source attributes in context are disabled");
        }
        if (this.variablesInContext) {
            Namespace namespace = this.getName().getNamespace();
            VariableStore variableStore = controllerState.getVariableStore();
            QualifiedNameMap<Variable> visibleVariables = variableStore.getContent().getInHierarchy(namespace);
            for (Variable variable : visibleVariables.values()) {
                QualifiedName qualifiedName = variable.getName();
                context.put(qualifiedName.getName(), variable.getValue());
            }
            log.debug("Put variables in context " + String.valueOf(visibleVariables.keySet()));
        } else {
            log.debug("variables in context are disabled");
        }
        return context;
    }
}

