/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.props;

import java.util.Properties;
import org.apache.commons.jcs.access.exception.ConfigurationException;
import org.apache.commons.jcs.utils.props.PropertiesFactory;
import org.apache.commons.jcs.utils.props.PropertiesFactoryFileImpl;

public abstract class AbstractPropertyContainer {
    private static final PropertiesFactory DEFAULT_PROPERTIES_FACTORY = new PropertiesFactoryFileImpl();
    private String propertiesGroup;
    private String propertiesHeading;
    private PropertiesFactory propertiesFactory;
    private Properties properties;

    public synchronized void ensureProperties() throws ConfigurationException {
        if (this.getProperties() == null) {
            this.initializeProperties();
        }
    }

    public synchronized void initializeProperties() throws ConfigurationException {
        this.loadProperties();
        this.handleProperties();
    }

    private void loadProperties() throws ConfigurationException {
        if (this.getPropertiesGroup() == null) {
            throw new ConfigurationException("Properties group is null and it shouldn't be");
        }
        if (this.getPropertiesHeading() == null) {
            throw new ConfigurationException("Properties heading is null and it shouldn't be");
        }
        if (this.getPropertiesFactory() == null) {
            this.setProperties(DEFAULT_PROPERTIES_FACTORY.getProperties(this.getPropertiesGroup()));
        } else {
            this.setProperties(this.getPropertiesFactory().getProperties(this.getPropertiesGroup()));
        }
    }

    protected abstract void handleProperties() throws ConfigurationException;

    public synchronized Properties getProperties() {
        return this.properties;
    }

    public synchronized void setProperties(Properties properties) {
        this.properties = properties;
    }

    public synchronized String getPropertiesHeading() {
        return this.propertiesHeading;
    }

    public synchronized void setPropertiesHeading(String propertiesHeading) {
        this.propertiesHeading = propertiesHeading;
    }

    public PropertiesFactory getPropertiesFactory() {
        return this.propertiesFactory;
    }

    public void setPropertiesFactory(PropertiesFactory propertiesFactory) {
        this.propertiesFactory = propertiesFactory;
    }

    public String getPropertiesGroup() {
        return this.propertiesGroup;
    }

    public void setPropertiesGroup(String propertiesGroup) {
        this.propertiesGroup = propertiesGroup;
    }
}

