/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import org.apache.torque.generator.configuration.controller.Loglevel;
import org.apache.torque.generator.configuration.option.OptionsConfiguration;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.apache.torque.generator.configuration.paths.TorqueGeneratorPaths;
import org.apache.torque.generator.source.SourceProvider;

public class UnitDescriptor {
    private final Packaging packaging;
    private final ProjectPaths projectPaths;
    private final TorqueGeneratorPaths configurationPaths;
    private UnitDescriptor inheritsFrom;
    private SourceProvider overrideSourceProvider;
    private OptionsConfiguration overrideOptions;
    private Loglevel loglevel;
    private boolean addDebuggingInfoToOutput = false;
    private String defaultOutputEncoding = null;
    private ClassLoader classLoader;
    private boolean runOnlyOnSourceChange = false;

    public UnitDescriptor(Packaging packaging, ProjectPaths projectPaths, TorqueGeneratorPaths configurationPaths) {
        if (packaging == null) {
            throw new NullPointerException("packaging must not be null");
        }
        if (projectPaths == null) {
            throw new NullPointerException("projectPaths must not be null");
        }
        if (configurationPaths == null) {
            throw new NullPointerException("configurationPaths must not be null");
        }
        this.packaging = packaging;
        this.projectPaths = projectPaths;
        this.configurationPaths = configurationPaths;
    }

    public Packaging getPackaging() {
        return this.packaging;
    }

    public ProjectPaths getProjectPaths() {
        return this.projectPaths;
    }

    public TorqueGeneratorPaths getConfigurationPaths() {
        return this.configurationPaths;
    }

    public UnitDescriptor getInheritsFrom() {
        return this.inheritsFrom;
    }

    public void setInheritsFrom(UnitDescriptor inheritsFrom) {
        this.inheritsFrom = inheritsFrom;
    }

    public SourceProvider getOverrideSourceProvider() {
        return this.overrideSourceProvider;
    }

    public void setOverrideSourceProvider(SourceProvider overrideSourceProvider) {
        this.overrideSourceProvider = overrideSourceProvider;
    }

    public OptionsConfiguration getOverrideOptions() {
        return this.overrideOptions;
    }

    public void setOverrideOptions(OptionsConfiguration overrideOptions) {
        this.overrideOptions = overrideOptions;
    }

    public Loglevel getLoglevel() {
        return this.loglevel;
    }

    public void setLoglevel(Loglevel loglevel) {
        this.loglevel = loglevel;
    }

    public boolean isAddDebuggingInfoToOutput() {
        return this.addDebuggingInfoToOutput;
    }

    public void setAddDebuggingInfoToOutput(boolean addDebuggingInfoToOutput) {
        this.addDebuggingInfoToOutput = addDebuggingInfoToOutput;
    }

    public String getDefaultOutputEncoding() {
        return this.defaultOutputEncoding;
    }

    public void setDefaultOutputEncoding(String defaultOutputEncoding) {
        this.defaultOutputEncoding = defaultOutputEncoding;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isRunOnlyOnSourceChange() {
        return this.runOnlyOnSourceChange;
    }

    public void setRunOnlyOnSourceChange(boolean runOnlyOnSourceChange) {
        this.runOnlyOnSourceChange = runOnlyOnSourceChange;
    }

    public static enum Packaging {
        JAR,
        DIRECTORY,
        CLASSPATH;

    }
}

