/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.outlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationEntityResolver;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.OutletTypes;
import org.apache.torque.generator.configuration.SaxHelper;
import org.apache.torque.generator.configuration.mergepoint.MergepointMapping;
import org.apache.torque.generator.configuration.mergepoint.MergepointSaxHandler;
import org.apache.torque.generator.configuration.outlet.OutletSaxHandler;
import org.apache.torque.generator.configuration.outlet.TypedOutletSaxHandlerFactory;
import org.apache.torque.generator.configuration.outlet.UntypedOutletSaxHandlerFactory;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.qname.QualifiedName;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutletConfigurationSaxHandler
extends DefaultHandler {
    private ConfigurationProvider configurationProvider;
    private ProjectPaths projectPaths;
    private List<Outlet> outlets = new ArrayList<Outlet>();
    private List<MergepointMapping> mergepointMappings = new ArrayList<MergepointMapping>();
    private ConfigurationHandlers configurationHandlers;
    private OutletSaxHandler outletHandler;
    private MergepointSaxHandler mergepointHandler;
    private static Log log = LogFactory.getLog(OutletSaxHandler.class);

    public OutletConfigurationSaxHandler(ConfigurationProvider configurationProvider, ProjectPaths projectPaths, ConfigurationHandlers configurationHandlers) {
        if (configurationProvider == null) {
            log.error((Object)"OutletConfigurationSaxHandler:  configurationProvider is null");
            throw new NullPointerException("configurationProvider is null");
        }
        if (projectPaths == null) {
            log.error((Object)"OutletConfigurationSaxHandler:  projectPaths is null");
            throw new NullPointerException("projectPaths is null");
        }
        if (configurationHandlers == null) {
            log.error((Object)"OutletConfigurationSaxHandler:  configurationHandlers is null");
            throw new NullPointerException("configurationHandlers is null");
        }
        this.configurationProvider = configurationProvider;
        this.projectPaths = projectPaths;
        this.configurationHandlers = configurationHandlers;
    }

    public List<Outlet> getOutlets() {
        return this.outlets;
    }

    public List<MergepointMapping> getMergepointMappings() {
        return this.mergepointMappings;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String unqualifiedName = SaxHelper.getUnqualifiedName(localName, qName);
        if (this.outletHandler != null) {
            this.outletHandler.startElement(uri, localName, qName, attributes);
        } else if (this.mergepointHandler != null) {
            this.mergepointHandler.startElement(uri, localName, qName, attributes);
        } else if ("outlet".equals(unqualifiedName)) {
            String outletType = OutletConfigurationSaxHandler.getOutletType(attributes);
            this.outletHandler = this.getOutletHandler(null, outletType);
            this.outletHandler.startElement(uri, localName, qName, attributes);
        } else if ("mergepoint".equals(unqualifiedName)) {
            this.mergepointHandler = new MergepointSaxHandler(this.configurationProvider, this.projectPaths, this.configurationHandlers);
            this.mergepointHandler.startElement(uri, localName, qName, attributes);
        } else if (!"outlets".equals(unqualifiedName)) {
            throw new SAXException("Unknown element : " + unqualifiedName + ". First element must be " + "outlets" + " or " + "outlet");
        }
    }

    @Override
    public void endElement(String uri, String localName, String rawName) throws SAXException {
        if (this.outletHandler != null) {
            this.outletHandler.endElement(uri, localName, rawName);
            if (this.outletHandler.isFinished()) {
                Outlet outlet = this.outletHandler.getOutlet();
                this.outlets.add(outlet);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsed configuration for the outlet " + outlet.getName()));
                }
                this.outletHandler = null;
            }
        } else if (this.mergepointHandler != null) {
            this.mergepointHandler.endElement(uri, localName, rawName);
            if (this.mergepointHandler.isFinished()) {
                MergepointMapping mergepointMapping = this.mergepointHandler.getMergepointMapping();
                this.mergepointMappings.add(mergepointMapping);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsed configuration for the mergepoint " + mergepointMapping.getName()));
                }
                this.mergepointHandler = null;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.outletHandler != null) {
            this.outletHandler.characters(ch, start, length);
        }
    }

    public OutletSaxHandler getOutletHandler(QualifiedName outletName, String outletType) throws SAXException {
        OutletTypes outletTypes = this.configurationHandlers.getOutletTypes();
        TypedOutletSaxHandlerFactory typedHandlerFactory = outletTypes.getTypedOutletHandlerFactories().get(outletType);
        if (typedHandlerFactory != null) {
            OutletSaxHandler outletSaxHandler = typedHandlerFactory.getOutletSaxHandler(outletName, this.configurationProvider, this.projectPaths, this.configurationHandlers);
            return outletSaxHandler;
        }
        UntypedOutletSaxHandlerFactory untypedHandlerFactory = null;
        for (UntypedOutletSaxHandlerFactory candidate : outletTypes.getUntypedOutletHandlerFactories()) {
            if (!candidate.canHandle(outletType)) continue;
            untypedHandlerFactory = candidate;
            break;
        }
        if (untypedHandlerFactory == null) {
            throw new SAXException("Unknown outlet type: " + outletType);
        }
        OutletSaxHandler outletSaxHandler = untypedHandlerFactory.getOutletSaxHandler(outletType, outletName, this.configurationProvider, this.projectPaths, this.configurationHandlers);
        return outletSaxHandler;
    }

    public static String getOutletType(Attributes attributes) throws SAXException {
        String outletType = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (outletType == null) {
            throw new SAXException("The tag outlet requires the attribute http://www.w3.org/2001/XMLSchema-instance:type");
        }
        return outletType;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return new ConfigurationEntityResolver().resolveEntity(publicId, systemId);
    }

    @Override
    public void error(SAXParseException exception) throws SAXParseException {
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXParseException {
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXParseException {
        throw exception;
    }
}

