/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.mergepoint;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.option.OptionsSaxHandlerFactory;
import org.apache.torque.generator.configuration.option.PropertiesOptionsSaxHandlerFactory;
import org.apache.torque.generator.configuration.option.XmlOptionsSaxHandlerFactory;

public class OptionsSaxHandlerFactories {
    private static Log log = LogFactory.getLog(OptionsSaxHandlerFactories.class);
    private Map<String, OptionsSaxHandlerFactory> factories = new HashMap<String, OptionsSaxHandlerFactory>();

    public OptionsSaxHandlerFactories() {
        try {
            this.register(new XmlOptionsSaxHandlerFactory());
            this.register(new PropertiesOptionsSaxHandlerFactory());
        }
        catch (ConfigurationException e) {
            log.error((Object)"caught ConfigurationException while registering the default Options Sax Handler Factories", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void register(OptionsSaxHandlerFactory optionsSaxHandlerFactory) throws ConfigurationException {
        String type = optionsSaxHandlerFactory.getType();
        OptionsSaxHandlerFactory oldFactory = this.factories.get(type);
        if (oldFactory != null) {
            throw new ConfigurationException("Attempted to register an OptionsSaxHandlerFactory of type " + optionsSaxHandlerFactory.getType() + " and class " + optionsSaxHandlerFactory.getClass().getName() + " : A factory with this type already exists, " + " it has the class " + oldFactory.getClass().getName());
        }
        this.factories.put(type, optionsSaxHandlerFactory);
    }

    public OptionsSaxHandlerFactory getOptionsSaxHandlerFactory(String type) {
        return this.factories.get(type);
    }
}

