/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.qname;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.torque.generator.qname.Namespace;
import org.apache.torque.generator.qname.QualifiedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedNameMap<T>
implements Map<QualifiedName, T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<QualifiedName, T> map;

    public QualifiedNameMap() {
        this.map = new HashMap();
    }

    public QualifiedNameMap(Map<? extends QualifiedName, ? extends T> map) {
        if (map.containsKey(null)) {
            throw new IllegalArgumentException("map must not contain a mapping for the key null");
        }
        this.map = new HashMap<QualifiedName, T>(map);
    }

    public T getInHierarchy(QualifiedName key) {
        while (!this.map.containsKey(key)) {
            if (Namespace.ROOT_NAMESPACE.equals(key.getNamespace())) {
                return null;
            }
            key = new QualifiedName(key.getName(), key.getNamespace().getParent());
        }
        return this.get(key);
    }

    public QualifiedName getKeyInHierarchy(QualifiedName key) {
        while (!this.map.containsKey(key)) {
            if (Namespace.ROOT_NAMESPACE.equals(key.getNamespace())) {
                return null;
            }
            key = new QualifiedName(key.getName(), key.getNamespace().getParent());
        }
        return key;
    }

    public QualifiedNameMap<T> getAllInHierarchy(Namespace namespace) {
        QualifiedNameMap<T> result = new QualifiedNameMap<T>();
        for (Map.Entry<QualifiedName, T> entry : this.entrySet()) {
            QualifiedName qualifiedName = entry.getKey();
            if (!qualifiedName.isVisibleFrom(namespace)) continue;
            result.put(qualifiedName, entry.getValue());
        }
        return result;
    }

    public QualifiedNameMap<T> getInHierarchy(Namespace namespace) {
        QualifiedNameMap<T> result = new QualifiedNameMap<T>();
        for (Map.Entry<QualifiedName, T> entry : this.entrySet()) {
            QualifiedName qualifiedName = entry.getKey();
            T value = entry.getValue();
            if (!qualifiedName.isVisibleFrom(namespace)) continue;
            Iterator<Map.Entry<QualifiedName, T>> resultEntryIt = result.entrySet().iterator();
            while (resultEntryIt.hasNext()) {
                Map.Entry<QualifiedName, T> resultEntry = resultEntryIt.next();
                QualifiedName resultQName = resultEntry.getKey();
                if (!resultQName.getName().equals(qualifiedName.getName())) continue;
                if (resultQName.isVisibleFrom(qualifiedName.getNamespace())) {
                    resultEntryIt.remove();
                    continue;
                }
                qualifiedName = resultQName;
                value = resultEntry.getValue();
                break;
            }
            result.put(qualifiedName, value);
        }
        return result;
    }

    @Override
    public T get(Object key) {
        return this.map.get(key);
    }

    @Override
    public T put(QualifiedName key, T value) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends QualifiedName, ? extends T> toPut) {
        if (toPut.containsKey(null)) {
            throw new IllegalArgumentException("toPut must not contain a mapping for the key null");
        }
        this.map.putAll(toPut);
    }

    @Override
    public T remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public Set<Map.Entry<QualifiedName, T>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Collection<T> values() {
        return this.map.values();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<QualifiedName> keySet() {
        return this.map.keySet();
    }

    public T getMoreSpecific(T object1, QualifiedName qualifiedName1, T object2, QualifiedName qualifiedName2) {
        if (object1 == null) {
            return object2;
        }
        if (object2 == null) {
            return object1;
        }
        Namespace namespace1 = qualifiedName1.getNamespace();
        Namespace namespace2 = qualifiedName2.getNamespace();
        if (namespace2.isVisibleFrom(namespace1)) {
            return object1;
        }
        return object2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof QualifiedNameMap)) {
            return false;
        }
        QualifiedNameMap other = (QualifiedNameMap)object;
        return this.map.equals(other.map);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

