/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURBaseTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURDataModelSetup;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SURQueryMixTest
extends SURBaseTest {
    private final String query;
    private final String cursorName;
    private final boolean positioned;
    private boolean checkRowUpdated;
    private boolean checkRowDeleted;
    private static final String[] selectConditions = new String[]{"WHERE c like 'T%'", " ", "WHERE b > 5", "WHERE id >= a", "WHERE id > 1 and id < 900", "WHERE id = 1", "WHERE id in (1,3,4,600,900,955,966,977,978)", "WHERE a in (1,3,4,600,9200,955,966,977,978)", "WHERE a>2 and a<9000"};
    private static final String[] projectConditions = new String[]{"id,c,a,b", "id,c", "a,b", "*", "id,a,b,c", "id,a", "a,b,c", "a,c"};

    public SURQueryMixTest(String string, String string2, String string3, boolean bl) {
        super("SURQueryMixTest{Model=" + string + ",Query=" + string2 + ",Cursor=" + string3 + ",Positioned=" + bl + "}");
        this.query = string2;
        this.cursorName = string3;
        this.positioned = bl;
        this.checkRowUpdated = false;
        this.checkRowDeleted = false;
    }

    public void runTest() throws SQLException {
        SURQueryMixTest.println(this.query);
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        if (databaseMetaData.ownDeletesAreVisible(1004)) {
            this.checkRowDeleted = true;
        }
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.cursorName);
        ResultSet resultSet = statement.executeQuery(this.query);
        this.checkRowUpdated = databaseMetaData.ownUpdatesAreVisible(resultSet.getType());
        this.checkRowDeleted = databaseMetaData.ownDeletesAreVisible(resultSet.getType());
        Map<Integer, String> map = this.createRowMap(resultSet);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        this.testNavigation(resultSet, map, hashSet, hashSet2);
        if (resultSet.getConcurrency() == 1008) {
            this.updateRandomSampleOfNRecords(resultSet, map, hashSet, 2);
            this.testNavigation(resultSet, map, hashSet, hashSet2);
            this.updateRandomSampleOfNRecords(resultSet, map, hashSet, 5);
            this.testNavigation(resultSet, map, hashSet, hashSet2);
            this.updateRandomSampleOfNRecords(resultSet, map, hashSet, 10);
            this.testNavigation(resultSet, map, hashSet, hashSet2);
            this.deleteRandomSampleOfNRecords(resultSet, map, hashSet2, 2);
            this.testNavigation(resultSet, map, hashSet, hashSet2);
            this.deleteRandomSampleOfNRecords(resultSet, map, hashSet2, 5);
            this.testNavigation(resultSet, map, hashSet, hashSet2);
            this.deleteRandomSampleOfNRecords(resultSet, map, hashSet2, 10);
            this.testNavigation(resultSet, map, hashSet, hashSet2);
        } else {
            SURQueryMixTest.assertTrue((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY", (boolean)false);
        }
        resultSet.close();
        statement.close();
    }

    private Map<Integer, String> createRowMap(ResultSet resultSet) throws SQLException {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        resultSet.beforeFirst();
        SURQueryMixTest.assertTrue((String)"Unexpected return from isBeforeFirst()", (boolean)resultSet.isBeforeFirst());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        while (resultSet.next()) {
            n3 += n;
            String string = this.getRowString(resultSet);
            SURQueryMixTest.println(string);
            hashMap.put(++n, string);
            n2 += resultSet.getInt(1);
            if (resultSet.getInt(1) >= 0) continue;
            bl = false;
        }
        if (n < 10) {
            bl = false;
        }
        SURQueryMixTest.assertTrue((String)"Unexpected return from isAfterLast()", (boolean)resultSet.isAfterLast());
        if (bl) {
            SURQueryMixTest.assertEquals((String)"Sum for column 1 is not correct", (int)n3, (int)n2);
        }
        return hashMap;
    }

    private List createRandomSample(Map<Integer, String> map, int n) {
        Random random = new Random();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        for (Integer n3 : map.keySet()) {
            double d;
            if (++n2 <= n) {
                arrayList.add(n3);
                continue;
            }
            double d2 = random.nextDouble();
            if (!(d2 < (d = (double)n / (double)n2))) continue;
            int n4 = random.nextInt(n);
            arrayList.set(n4, n3);
        }
        return arrayList;
    }

    private void deleteRandomSampleOfNRecords(ResultSet resultSet, Map<Integer, String> map, Set<Integer> set, int n) throws SQLException {
        List list = this.createRandomSample(map, n);
        SURQueryMixTest.println("Sampled keys:" + list);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (Integer n2 : list) {
            resultSet.absolute(n2);
            if (resultSet.rowDeleted()) continue;
            if (this.positioned) {
                this.createStatement().executeUpdate("DELETE FROM T1 WHERE CURRENT OF \"" + this.cursorName + "\"");
            } else {
                resultSet.deleteRow();
            }
            resultSet.relative(0);
            SURQueryMixTest.println("Deleted row " + n2);
            map.put(n2, this.getRowString(resultSet));
            set.add(n2);
        }
    }

    private void updateRandomSampleOfNRecords(ResultSet resultSet, Map<Integer, String> map, Set<Integer> set, int n) throws SQLException {
        List list = this.createRandomSample(map, n);
        SURQueryMixTest.println("Sampled keys:" + list);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (Integer n2 : list) {
            resultSet.absolute(n2);
            if (this.positioned) {
                this.updatePositioned(resultSet, resultSetMetaData);
                resultSet.relative(0);
            } else {
                this.updateRow(resultSet, resultSetMetaData);
            }
            map.put(n2, this.getRowString(resultSet));
            set.add(n2);
        }
    }

    private void updateRow(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws SQLException {
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            if (resultSetMetaData.getColumnType(i) == 4) {
                resultSet.updateInt(i, -resultSet.getInt(i));
                continue;
            }
            resultSet.updateString(i, "UPDATED_" + resultSet.getString(i));
        }
        resultSet.updateRow();
    }

    private void updatePositioned(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE T1 SET ");
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            stringBuffer.append(resultSetMetaData.getColumnName(i));
            stringBuffer.append("=?");
            if (i >= resultSetMetaData.getColumnCount()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(" WHERE CURRENT OF \"");
        stringBuffer.append(this.cursorName);
        stringBuffer.append("\"");
        SURQueryMixTest.println(stringBuffer.toString());
        PreparedStatement preparedStatement = this.prepareStatement(stringBuffer.toString());
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            if (resultSetMetaData.getColumnType(i) == 4) {
                preparedStatement.setInt(i, -resultSet.getInt(i));
                continue;
            }
            preparedStatement.setString(i, "UPDATED_" + resultSet.getString(i));
        }
        SURQueryMixTest.assertEquals((String)"Expected one row to be updated", (int)1, (int)preparedStatement.executeUpdate());
    }

    private void testNavigation(ResultSet resultSet, Map map, Set set, Set set2) throws SQLException {
        String string;
        resultSet.afterLast();
        int n = map.size();
        while (resultSet.previous()) {
            string = this.getRowString(resultSet);
            SURQueryMixTest.assertEquals((String)"Navigating with rs.previous(). The row is different compared to the value when navigating forward.", map.get(n), (Object)string);
            if (this.checkRowUpdated && set.contains(n)) {
                SURQueryMixTest.assertTrue((String)("Expected rs.rowUpdated() to return true on updated row " + string), (boolean)resultSet.rowUpdated());
            }
            if (this.checkRowDeleted && set2.contains(n)) {
                SURQueryMixTest.assertTrue((String)("Expected rs.rowDeleted() to return true on deleted row " + string), (boolean)resultSet.rowDeleted());
            }
            --n;
        }
        for (n = 1; n <= map.size(); ++n) {
            SURQueryMixTest.assertTrue((String)"Unexpected return from absolute()", (boolean)resultSet.absolute(n));
            string = this.getRowString(resultSet);
            SURQueryMixTest.assertEquals((String)"Navigating with rs.absolute(). The row is different compared to the value when navigating forward.", map.get(n), (Object)string);
            if (this.checkRowUpdated && set.contains(n)) {
                SURQueryMixTest.assertTrue((String)("Expected rs.rowUpdated() to return true on updated row " + string), (boolean)resultSet.rowUpdated());
            }
            if (!this.checkRowDeleted || !set2.contains(n)) continue;
            SURQueryMixTest.assertTrue((String)("Expected rs.rowDeleted() to return true on deleted row " + string), (boolean)resultSet.rowDeleted());
        }
        SURQueryMixTest.assertFalse((String)"Unexpected return from absolute()", (boolean)resultSet.absolute(0));
        SURQueryMixTest.assertTrue((String)"Unexpected return from isBeforeFirst()", (boolean)resultSet.isBeforeFirst());
        SURQueryMixTest.assertFalse((String)"Unexpected return from absolute()", (boolean)resultSet.absolute(map.size() + 1));
        SURQueryMixTest.assertTrue((String)"Unexpected return from isAfterLast()", (boolean)resultSet.isAfterLast());
        SURQueryMixTest.assertTrue((String)"Unexpected return from absolute()", (boolean)resultSet.absolute(-1));
        SURQueryMixTest.assertTrue((String)"Unexpected return from isLast()", (boolean)resultSet.isLast());
        SURQueryMixTest.assertTrue((String)"Unexpected return from absolute()", (boolean)resultSet.absolute(1));
        SURQueryMixTest.assertTrue((String)"Unexpected return from isFirst()", (boolean)resultSet.isFirst());
        resultSet.beforeFirst();
        SURQueryMixTest.assertTrue((String)"Unexptected return from isBeforeFirst()", (boolean)resultSet.isBeforeFirst());
        n = map.size();
        SURQueryMixTest.assertTrue((String)"Unexpected return from relative()", (boolean)resultSet.relative(n));
        SURQueryMixTest.assertTrue((String)"Unexptected return from isLast()", (boolean)resultSet.isLast());
        SURQueryMixTest.assertEquals((String)"Navigating with rs.relative(+). A tuple was different compared to the value when navigating forward.", map.get(n), (Object)this.getRowString(resultSet));
        SURQueryMixTest.assertTrue((String)"Unexpected return from relative()", (boolean)resultSet.relative(-n + 1));
        SURQueryMixTest.assertTrue((String)"Unexptected return from isFirst()", (boolean)resultSet.isFirst());
        SURQueryMixTest.assertEquals((String)"Navigating with rs.relative(-). A tuple was different compared to the value when navigating forward.", map.get(1), (Object)this.getRowString(resultSet));
        resultSet.afterLast();
        SURQueryMixTest.assertTrue((String)"Unexpected return from isAfterLast()", (boolean)resultSet.isAfterLast());
        SURQueryMixTest.assertTrue((String)"Unexpected return from previous()", (boolean)resultSet.previous());
        SURQueryMixTest.assertTrue((String)"Unexpected return from isLast()", (boolean)resultSet.isLast());
        SURQueryMixTest.assertFalse((String)"Unexpected return from next()", (boolean)resultSet.next());
        SURQueryMixTest.assertTrue((String)"Unexpected return from isAfterLast()", (boolean)resultSet.isAfterLast());
        resultSet.last();
        SURQueryMixTest.assertTrue((String)"Unexpected return from isLast()", (boolean)resultSet.isLast());
        SURQueryMixTest.assertFalse((String)"Unexpected return from next()", (boolean)resultSet.next());
        SURQueryMixTest.assertTrue((String)"Unexpected return from isAfterLast()", (boolean)resultSet.isAfterLast());
        resultSet.beforeFirst();
        SURQueryMixTest.assertTrue((String)"Unexpected return from isBeforeFirst()", (boolean)resultSet.isBeforeFirst());
        SURQueryMixTest.assertTrue((String)"Unexpected return from next()", (boolean)resultSet.next());
        SURQueryMixTest.assertTrue((String)"Unexpected return from isFirst", (boolean)resultSet.isFirst());
        SURQueryMixTest.assertFalse((String)"Unexpected return from previous()", (boolean)resultSet.previous());
        SURQueryMixTest.assertTrue((String)"Unexpected return from isBeforeFirst()", (boolean)resultSet.isBeforeFirst());
        resultSet.first();
        SURQueryMixTest.assertTrue((String)"Unexpected return from isFirst", (boolean)resultSet.isFirst());
        SURQueryMixTest.assertFalse((String)"Unexpected return from previous()", (boolean)resultSet.previous());
        SURQueryMixTest.assertTrue((String)"Unexpected return from isBeforeFirst()", (boolean)resultSet.isBeforeFirst());
    }

    private String getRowString(ResultSet resultSet) throws SQLException {
        int n = resultSet.getMetaData().getColumnCount();
        StringBuffer stringBuffer = new StringBuffer();
        if (resultSet.rowDeleted()) {
            return "";
        }
        for (int i = 1; i <= n; ++i) {
            stringBuffer.append(resultSet.getString(i));
            if (i >= n) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    private static BaseTestSuite createTestCases(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        for (int i = 0; i < 2; ++i) {
            boolean bl = i > 0;
            for (int j = 0; j < selectConditions.length; ++j) {
                for (int k = 0; k < projectConditions.length; ++k) {
                    String string2 = "cursor_" + j + "_" + k;
                    String string3 = "SELECT " + projectConditions[k] + " FROM T1 " + selectConditions[j];
                    baseTestSuite.addTest((Test)new SURQueryMixTest(string, string3, string2, bl));
                }
            }
        }
        return baseTestSuite;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("SURQueryMixTest suite");
        baseTestSuite.addTest(SURQueryMixTest.baseSuite("SURQueryMixTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(SURQueryMixTest.baseSuite("SURQueryMixTest:client")));
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        for (SURDataModelSetup.SURDataModel sURDataModel : SURDataModelSetup.SURDataModel.values()) {
            BaseTestSuite baseTestSuite2 = SURQueryMixTest.createTestCases(sURDataModel.toString());
            SURDataModelSetup sURDataModelSetup = new SURDataModelSetup((Test)baseTestSuite2, sURDataModel);
            baseTestSuite.addTest((Test)sURDataModelSetup);
        }
        return baseTestSuite;
    }
}

