/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.daemon;

import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.services.daemon.ServiceRecord;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class BasicDaemon
implements DaemonService,
Runnable {
    private int numClients;
    private static final int OPTIMAL_QUEUE_SIZE = 100;
    private final Vector<ServiceRecord> subscription;
    protected final ContextService contextService;
    protected final ContextManager contextMgr;
    private final List<ServiceRecord> highPQ;
    private final List<ServiceRecord> normPQ;
    private int nextService;
    private boolean awakened;
    private boolean waiting;
    private boolean inPause;
    private boolean running;
    private boolean stopRequested;
    private boolean stopped;
    private long lastServiceTime;
    private int earlyWakeupCount;

    public BasicDaemon(ContextService contextService) {
        this.contextService = contextService;
        this.contextMgr = contextService.newContextManager();
        this.subscription = new Vector(1, 1);
        this.highPQ = new LinkedList<ServiceRecord>();
        this.normPQ = new LinkedList<ServiceRecord>();
        this.lastServiceTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int subscribe(Serviceable newClient, boolean onDemandOnly) {
        ServiceRecord clientRecord;
        int clientNumber;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            clientNumber = this.numClients++;
            clientRecord = new ServiceRecord(newClient, onDemandOnly, true);
            this.subscription.add(clientNumber, clientRecord);
        }
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "subscribed client # " + clientNumber + " : " + clientRecord);
        }
        return clientNumber;
    }

    @Override
    public void unsubscribe(int clientNumber) {
        if (clientNumber < 0 || clientNumber > this.subscription.size()) {
            return;
        }
        this.subscription.set(clientNumber, null);
    }

    @Override
    public void serviceNow(int clientNumber) {
        if (clientNumber < 0 || clientNumber > this.subscription.size()) {
            return;
        }
        ServiceRecord clientRecord = this.subscription.get(clientNumber);
        if (clientRecord == null) {
            return;
        }
        clientRecord.called();
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enqueue(Serviceable newClient, boolean serviceNow) {
        int highPQsize;
        ServiceRecord clientRecord = new ServiceRecord(newClient, false, false);
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "enqueing work, urgent = " + serviceNow + ":" + newClient);
        }
        List<ServiceRecord> queue = serviceNow ? this.highPQ : this.normPQ;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            queue.add(clientRecord);
            highPQsize = this.highPQ.size();
            if (SanityManager.DEBUG_ON("memoryLeakTrace") && highPQsize > 200) {
                System.out.println("memoryLeakTrace:BasicDaemon " + highPQsize);
            }
        }
        if (serviceNow && !this.awakened) {
            this.wakeUp();
        }
        if (serviceNow) {
            return highPQsize > 100;
        }
        return false;
    }

    @Override
    public synchronized void clear() {
        this.normPQ.clear();
        this.highPQ.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceRecord nextAssignment(boolean urgent) {
        ServiceRecord clientRecord;
        while (this.nextService < this.subscription.size()) {
            if ((clientRecord = this.subscription.get(this.nextService++)) == null || !clientRecord.needImmediateService() && (urgent || !clientRecord.needService())) continue;
            return clientRecord;
        }
        clientRecord = null;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            if (!this.highPQ.isEmpty()) {
                clientRecord = this.highPQ.remove(0);
            }
        }
        if (urgent || clientRecord != null) {
            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                SanityManager.DEBUG(DaemonService.DaemonTrace, (String)(clientRecord == null ? "No more urgent assignment " : "Next urgent assignment : " + clientRecord));
            }
            return clientRecord;
        }
        clientRecord = null;
        basicDaemon = this;
        synchronized (basicDaemon) {
            if (!this.normPQ.isEmpty()) {
                clientRecord = this.normPQ.remove(0);
                if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                    SanityManager.DEBUG(DaemonService.DaemonTrace, "Next normal enqueued : " + clientRecord);
                }
            }
        }
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace) && clientRecord == null) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "No more assignment");
        }
        return clientRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceClient(ServiceRecord clientRecord) {
        clientRecord.serviced();
        Serviceable client = clientRecord.client;
        if (client == null) {
            return;
        }
        ContextManager cm = this.contextMgr;
        SanityManager.ASSERT(cm != null, "Context manager is null");
        SanityManager.ASSERT(client != null, "client is null");
        try {
            int status = client.performWork(cm);
            if (clientRecord.subscriber) {
                return;
            }
            if (status == 2) {
                List<ServiceRecord> queue = client.serviceASAP() ? this.highPQ : this.normPQ;
                BasicDaemon basicDaemon = this;
                synchronized (basicDaemon) {
                    queue.add(clientRecord);
                    if (SanityManager.DEBUG_ON("memoryLeakTrace") && queue.size() > 200) {
                        System.out.println("memoryLeakTrace:BasicDaemon " + queue.size());
                    }
                }
            }
            return;
        }
        catch (Throwable e) {
            SanityManager.showTrace(e);
            cm.cleanupOnError(e, false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.contextService.setCurrentContextManager(this.contextMgr);
        if (SanityManager.DEBUG_ON(DaemonService.DaemonOff)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "DaemonOff is set in properties, background Daemon not run");
            return;
        }
        SanityManager.DEBUG(DaemonService.DaemonTrace, "running");
        while (!this.stopRequested()) {
            boolean urgentOnly = this.rest();
            if (this.stopRequested()) break;
            if (this.inPause()) continue;
            this.work(urgentOnly);
        }
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.running = false;
            this.stopped = true;
        }
        this.contextMgr.cleanupOnError(StandardException.normalClose(), false);
        this.contextService.resetCurrentContextManager(this.contextMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "pausing daemon");
        }
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.inPause = true;
            while (this.running) {
                if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                    SanityManager.DEBUG(DaemonService.DaemonTrace, "waiting for daemon run to finish");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    InterruptStatus.setInterrupted();
                }
            }
        }
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "daemon paused");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.inPause = false;
        }
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "daemon resumed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.stopped) {
            return;
        }
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.stopRequested = true;
            this.notifyAll();
        }
        this.pause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitUntilQueueIsEmpty() {
        while (true) {
            BasicDaemon basicDaemon = this;
            synchronized (basicDaemon) {
                boolean noSubscriptionRequests = true;
                for (int urgentServiced = 0; urgentServiced < this.subscription.size(); ++urgentServiced) {
                    ServiceRecord clientRecord = this.subscription.get(urgentServiced);
                    if (clientRecord == null || !clientRecord.needService()) continue;
                    noSubscriptionRequests = false;
                    break;
                }
                if (this.highPQ.isEmpty() && noSubscriptionRequests && !this.running) {
                    return;
                }
                this.notifyAll();
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    InterruptStatus.setInterrupted();
                }
            }
        }
    }

    private synchronized boolean stopRequested() {
        return this.stopRequested;
    }

    private synchronized boolean inPause() {
        return this.inPause;
    }

    protected synchronized void wakeUp() {
        if (!this.awakened) {
            this.awakened = true;
            if (this.waiting) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rest() {
        long currenttime;
        boolean urgentOnly;
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "going back to rest");
        }
        boolean checkWallClock = false;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            try {
                if (!this.awakened) {
                    this.waiting = true;
                    this.wait(10000L);
                    this.waiting = false;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.nextService = 0;
            urgentOnly = this.awakened;
            if (urgentOnly && this.earlyWakeupCount++ > 20) {
                this.earlyWakeupCount = 0;
                checkWallClock = true;
            }
            this.awakened = false;
        }
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, urgentOnly ? "someone wakes me up" : "wakes up by myself");
        }
        if (checkWallClock && (currenttime = System.currentTimeMillis()) - this.lastServiceTime > 10000L) {
            this.lastServiceTime = currenttime;
            urgentOnly = false;
            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                SanityManager.DEBUG(DaemonService.DaemonTrace, "wall clock check says service all");
            }
        }
        return urgentOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work(boolean urgentOnly) {
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "going back to work");
        }
        int serviceCount = 0;
        int yieldFactor = 10;
        if (urgentOnly && this.highPQ.size() > 100) {
            yieldFactor = 2;
        }
        int yieldCount = 100 / yieldFactor;
        ServiceRecord work = this.nextAssignment(urgentOnly);
        while (work != null) {
            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                SanityManager.DEBUG(DaemonService.DaemonTrace, "servicing " + work);
            }
            BasicDaemon basicDaemon = this;
            synchronized (basicDaemon) {
                if (this.inPause || this.stopRequested) {
                    break;
                }
                this.running = true;
            }
            try {
                this.serviceClient(work);
                ++serviceCount;
            }
            finally {
                basicDaemon = this;
                synchronized (basicDaemon) {
                    this.running = false;
                    this.notifyAll();
                    if (this.inPause || this.stopRequested) {
                        break;
                    }
                }
            }
            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                SanityManager.DEBUG(DaemonService.DaemonTrace, "done " + work);
            }
            if (serviceCount % 50 == 0) {
                this.nextService = 0;
            }
            if (serviceCount % yieldCount == 0) {
                this.yieldNow();
            }
            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                SanityManager.DEBUG(DaemonService.DaemonTrace, "come back from yield");
            }
            work = this.nextAssignment(urgentOnly);
        }
    }

    private void yieldNow() {
        Thread currentThread = Thread.currentThread();
        int oldPriority = currentThread.getPriority();
        if (oldPriority <= 1) {
            Thread.yield();
        } else {
            ModuleFactory mf = BasicDaemon.getMonitor();
            BasicDaemon.setThreadPriority(mf, 1);
            Thread.yield();
            BasicDaemon.setThreadPriority(mf, oldPriority);
        }
    }

    private static void setThreadPriority(ModuleFactory mf, int priority) {
        Thread t = Thread.currentThread();
        if (mf != null && mf.isDaemonThread(t)) {
            t.setPriority(priority);
        }
    }

    static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }
}

