/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.functionTests.util.PropertyUtil;

public class TestPropertyInfo {
    public static String getAllTableProperties(String string, String string2) throws SQLException {
        Properties properties = TestPropertyInfo.getConglomerateProperties(string, string2, false);
        if (properties == null) {
            return null;
        }
        return PropertyUtil.sortProperties((Properties)properties);
    }

    public static String getTableProperty(String string, String string2, String string3) throws SQLException {
        return TestPropertyInfo.getConglomerateProperties(string, string2, false).getProperty(string3);
    }

    public static String getAllIndexProperties(String string, String string2) throws SQLException {
        Properties properties = TestPropertyInfo.getConglomerateProperties(string, string2, true);
        if (properties == null) {
            return null;
        }
        return PropertyUtil.sortProperties((Properties)properties);
    }

    public static Properties filter(Properties properties, String string) {
        properties.remove(string);
        return properties;
    }

    private static Properties getConglomerateProperties(String string, String string2, boolean bl) throws SQLException {
        Properties properties;
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        try {
            long l;
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(string, transactionController, true);
            if (!bl) {
                TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(string2, schemaDescriptor, transactionController);
                if (tableDescriptor == null || tableDescriptor.getTableType() == 2) {
                    return new Properties();
                }
                l = tableDescriptor.getHeapConglomerateId();
            } else {
                ConglomerateDescriptor conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(string2, schemaDescriptor, false);
                if (conglomerateDescriptor == null) {
                    return new Properties();
                }
                l = conglomerateDescriptor.getConglomerateNumber();
            }
            ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 0, 6, 5);
            properties = conglomerateController.getInternalTablePropertySet(new Properties());
            conglomerateController.close();
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException((StandardException)standardException);
        }
        return properties;
    }
}

