/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

public class HaltingThread
extends Thread {
    protected boolean beenHalted = false;

    public HaltingThread() {
    }

    public HaltingThread(Runnable runnable) {
        super(runnable);
    }

    public HaltingThread(String string) {
        super(string);
    }

    public HaltingThread(Runnable runnable, String string) {
        super(runnable, string);
    }

    public boolean isHalted() {
        HaltingThread haltingThread = this;
        synchronized (haltingThread) {
            boolean bl = this.beenHalted;
            return bl;
        }
    }

    public void halt() {
        HaltingThread haltingThread = this;
        synchronized (haltingThread) {
            this.beenHalted = true;
        }
    }

    public void clearHalted() {
        HaltingThread haltingThread = this;
        synchronized (haltingThread) {
            this.beenHalted = false;
        }
    }

    public static void haltThread() {
        HaltingThread.haltThread(Thread.currentThread());
    }

    public static void haltThread(Thread thread) {
        if (thread instanceof HaltingThread) {
            ((HaltingThread)thread).halt();
        }
    }

    public static boolean hasBeenHalted() {
        return HaltingThread.hasBeenHalted(Thread.currentThread());
    }

    public static boolean hasBeenHalted(Thread thread) {
        if (thread instanceof HaltingThread) {
            return ((HaltingThread)thread).isHalted();
        }
        return false;
    }
}

