/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SequenceTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String ALPHA = "ALPHA";
    private static final String BETA = "BETA";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALPHA", "BETA"};
    private static final String TOO_MANY_UNUSED_SEQUENCES = "X0Y93";

    public SequenceTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(SequenceTest.class, "Sequence Test");
        if (!JDBC.vmSupportsJSR169() && !JDBC.vmSupportsJDBC3()) {
            return baseTestSuite;
        }
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)baseTestSuite);
        Test test = DatabasePropertyTestSetup.builtinAuthentication((Test)cleanDatabaseTestSetup, LEGAL_USERS, "sequence");
        Test test2 = TestConfiguration.sqlAuthorizationDecorator(test);
        return test2;
    }

    public void test_01_CreateSequence() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE SEQUENCE mySeq");
    }

    public void test_02_DropSequence() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE SEQUENCE mySeq1");
        statement.executeUpdate("DROP SEQUENCE mySeq1 restrict");
    }

    public void test_03_DuplicateCreationFailure() throws SQLException {
        Statement statement = null;
        try {
            statement = this.createStatement();
            statement.executeUpdate("CREATE SEQUENCE mySeq1");
            statement.executeUpdate("CREATE SEQUENCE mySeq1");
        }
        catch (SQLException sQLException) {
            SequenceTest.assertSQLState("X0Y68", sQLException);
        }
        finally {
            statement.executeUpdate("DROP SEQUENCE mySeq1 restrict");
        }
    }

    public void test_04_ImplicitSchemaCreation() throws SQLException {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(ALPHA);
        Statement statement = connection2.createStatement();
        statement.executeUpdate("CREATE SEQUENCE alpha_seq");
        statement.executeUpdate("DROP SEQUENCE alpha_seq restrict");
        statement.close();
        connection2.close();
        connection.close();
    }

    public void test_05CreateWithSchemaSpecified() throws SQLException {
        Connection connection = this.openUserConnection(ALPHA);
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE SEQUENCE alpha.alpha_seq");
        statement.executeUpdate("DROP SEQUENCE alpha.alpha_seq restrict");
        statement.close();
        connection.close();
    }

    public void test_06_CreateWithSchemaSpecifiedCreateTrue() throws SQLException {
        Connection connection = this.openUserConnection(ALPHA);
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE SEQUENCE alpha.alpha_seq");
        statement.executeUpdate("DROP SEQUENCE alpha.alpha_seq restrict");
        statement.close();
        connection.close();
    }

    public void test_07_CreateWithSchemaDropWithNoSchema() throws SQLException {
        Connection connection = this.openUserConnection(ALPHA);
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE SEQUENCE alpha.alpha_seq");
        statement.executeUpdate("DROP SEQUENCE alpha_seq restrict");
        statement.close();
        connection.close();
    }

    public void test_08_DropOtherSchemaSequence() throws SQLException {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(ALPHA);
        Statement statement = connection2.createStatement();
        statement.executeUpdate("CREATE SEQUENCE alpha_seq");
        Connection connection3 = this.openUserConnection(BETA);
        Statement statement2 = connection3.createStatement();
        SequenceTest.assertStatementError("42507", statement2, "DROP SEQUENCE alpha.alpha_seq restrict");
        statement.executeUpdate("DROP SEQUENCE alpha_seq restrict");
        statement.close();
        statement2.close();
        connection2.close();
        connection3.close();
        connection.close();
    }

    public void test_09_CreateOtherSchemaSequence() throws SQLException {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(ALPHA);
        Statement statement = connection2.createStatement();
        statement.executeUpdate("CREATE SEQUENCE alpha_seq");
        Connection connection3 = this.openUserConnection(BETA);
        Statement statement2 = connection3.createStatement();
        SequenceTest.assertStatementError("42507", statement2, "CREATE SEQUENCE alpha.alpha_seq3");
        statement.executeUpdate("DROP SEQUENCE alpha_seq restrict");
        statement.close();
        statement2.close();
        connection2.close();
        connection3.close();
        connection.close();
    }

    public void test_09a_createSequenceWithArguments() throws Exception {
        Connection connection = this.openUserConnection(ALPHA);
        this.goodStatement(connection, "CREATE SEQUENCE small1 AS SMALLINT START WITH 0 INCREMENT BY 1");
        this.goodStatement(connection, "CREATE SEQUENCE small2 AS SMALLINT START WITH -32768 MAXVALUE 32767");
        this.goodStatement(connection, "CREATE SEQUENCE small3 AS SMALLINT START WITH 1200 INCREMENT BY -5 MAXVALUE 32000 NO MINVALUE CYCLE");
        this.expectCompilationError(connection, "42XAE", "CREATE SEQUENCE small3 AS SMALLINT START WITH -32768 MAXVALUE 2147483647");
        this.expectCompilationError(connection, "42XAG", "CREATE SEQUENCE small4 AS SMALLINT START WITH -2147483648");
        this.expectCompilationError(connection, "42XAF", "CREATE SEQUENCE small5 AS SMALLINT MAXVALUE -20000 MINVALUE -1");
        this.goodStatement(connection, "CREATE SEQUENCE int1 AS INTEGER START WITH -2147483648 INCREMENT BY -10 CYCLE");
        this.goodStatement(connection, "CREATE SEQUENCE int2 AS INTEGER INCREMENT BY 5 MAXVALUE 2147483647");
        this.goodStatement(connection, "CREATE SEQUENCE int3 AS INTEGER START WITH 1200 INCREMENT BY 5 NO MAXVALUE MINVALUE -320000 CYCLE");
        this.expectCompilationError(connection, "42XAE", "CREATE SEQUENCE int4 AS INTEGER START WITH -2147483648 MAXVALUE 32767 MINVALUE -9223372036854775808");
        this.expectCompilationError(connection, "42XAC", "CREATE SEQUENCE int5 AS INTEGER INCREMENT BY 0");
        this.goodStatement(connection, "CREATE SEQUENCE long1 AS BIGINT START WITH -9223372036854775808 INCREMENT BY -100 NO CYCLE");
        this.goodStatement(connection, "CREATE SEQUENCE long2 AS BIGINT INCREMENT BY 25 MAXVALUE 2147483647");
        this.goodStatement(connection, "CREATE SEQUENCE long3 AS BIGINT START WITH 0 INCREMENT BY 5 NO MAXVALUE MINVALUE -9223372036854775808 CYCLE");
        this.expectCompilationError(connection, "42XAE", "CREATE SEQUENCE long4 AS BIGINT START WITH 2147483647 MINVALUE 9223372036854775807");
        this.expectCompilationError(connection, "42XAF", "CREATE SEQUENCE long5 AS BIGINT START WITH 0 MAXVALUE 100000 MINVALUE 100001");
        this.expectCompilationError(connection, "42X01", "CREATE SEQUENCE char1 AS CHAR INCREMENT BY 1");
    }

    public void test_10_NextValue() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE SEQUENCE mySeq1");
        statement.execute("SELECT NEXT VALUE FOR mySeq1 from sys.systables");
        statement.execute("DROP SEQUENCE mySeq1 restrict");
    }

    public void test_11_forbiddenContexts() throws Exception {
        Connection connection = this.openUserConnection(ALPHA);
        this.goodStatement(connection, "create sequence seq_11_a\n");
        this.goodStatement(connection, "create sequence seq_11_b\n");
        String string = "42XAH";
        this.expectCompilationError(connection, string, "select * from sys.systables where ( next value for seq_11_a ) > 100\n");
        this.expectCompilationError(connection, string, "select max( conglomeratenumber ), tableid\nfrom sys.sysconglomerates\ngroup by tableid\nhaving max( conglomeratenumber ) > ( next value for seq_11_a )\n");
        this.expectCompilationError(connection, string, "select * from sys.sysconglomerates left join sys.sysschemas on conglomeratenumber = ( next value for seq_11_a )\n");
        this.expectCompilationError(connection, string, "create table t_11_1( a int check ( a > ( next value for seq_11_a ) ) )\n");
        this.expectCompilationError(connection, string, "create table t_11_1( a int, b generated always as ( a + ( next value for seq_11_a ) ) )\n");
        this.expectCompilationError(connection, string, "select max( next value for seq_11_a ) from sys.systables\n");
        this.expectCompilationError(connection, string, "values case when ( next value for seq_11_a ) < 0 then 100 else 200 end\n");
        this.expectCompilationError(connection, string, "select distinct( next value for seq_11_a ) from sys.systables\n");
        this.expectCompilationError(connection, string, "select tableid, ( next value for seq_11_a ) a from sys.systables order by a\n");
        this.expectCompilationError(connection, string, "select max( tableid ), ( next value for seq_11_a ) from sys.systables group by ( next value for seq_11_a )\n");
        this.expectCompilationError(connection, "42XAI", "select next value for seq_11_a, next value for seq_11_a from sys.systables where 1=2\n");
        this.goodStatement(connection, "select next value for seq_11_a, next value for seq_11_b from sys.systables where 1=2\n");
    }

    public void test_12_clauseOrder() throws Exception {
        Connection connection = this.openUserConnection(ALPHA);
        this.goodSequence(connection, "seq_12_a", "", "INTEGER", Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, 1L, false);
        this.goodSequence(connection, "seq_12_b", "minvalue 5 increment by 3 cycle start with 100 maxvalue 1000000 as bigint", "BIGINT", 100L, 5L, 1000000L, 3L, true);
        this.goodSequence(connection, "seq_12_c", "increment by 3 as smallint no cycle no maxvalue", "SMALLINT", -32768L, -32768L, 32767L, 3L, false);
        this.goodSequence(connection, "seq_12_d", "maxvalue 1000000000 start with -50 increment by -3 cycle no minvalue", "INTEGER", -50L, Integer.MIN_VALUE, 1000000000L, -3L, true);
        this.expectCompilationError(connection, "42XAJ", "create sequence bad_12 as smallint as bigint\n");
        this.expectCompilationError(connection, "42XAJ", "create sequence bad_12 start with 3 start with 7\n");
        this.expectCompilationError(connection, "42XAJ", "create sequence bad_12 minvalue 5 no minvalue\n");
        this.expectCompilationError(connection, "42XAJ", "create sequence bad_12 maxvalue 5 no maxvalue\n");
        this.expectCompilationError(connection, "42XAJ", "create sequence bad_12 increment by 7 increment by -7\n");
        this.expectCompilationError(connection, "42XAJ", "create sequence bad_12 no cycle cycle\n");
    }

    private void goodSequence(Connection connection, String string, String string2, String string3, long l, long l2, long l3, long l4, boolean bl) throws Exception {
        String string4 = "create sequence " + string + " " + string2;
        this.goodStatement(connection, string4);
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "select sequencedatatype, startvalue, minimumvalue, maximumvalue, increment, cycleoption\nfrom sys.syssequences\nwhere sequencename = ?");
        preparedStatement.setString(1, string.toUpperCase());
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        int n = 1;
        SequenceTest.assertEquals((String)string3, (String)resultSet.getString(n++));
        SequenceTest.assertEquals((long)l, (long)resultSet.getLong(n++));
        SequenceTest.assertEquals((long)l2, (long)resultSet.getLong(n++));
        SequenceTest.assertEquals((long)l3, (long)resultSet.getLong(n++));
        SequenceTest.assertEquals((long)l4, (long)resultSet.getLong(n++));
        SequenceTest.assertEquals((boolean)bl, (boolean)resultSet.getString(n++).equals("Y"));
        resultSet.close();
        preparedStatement.close();
    }

    public void test_13_restrictedDrop() throws Exception {
        Connection connection = this.openUserConnection(ALPHA);
        this.goodStatement(connection, "create table t_13_a( a int )");
        this.goodStatement(connection, "create table t_13_b( a int )");
        String string = "create sequence seq_13_a";
        String string2 = "drop sequence seq_13_a restrict";
        String string3 = "create trigger trig_13 after insert on t_13_a for each row insert into t_13_b( a ) values ( next value for seq_13_a )\n";
        String string4 = "drop trigger trig_13";
        String string5 = "X0Y24";
        this.verifyRestrictedDrop(connection, string3, string4, string, string2, string5);
        string = "create sequence seq_13_b";
        string2 = "drop sequence seq_13_b restrict";
        string3 = "create view v_13( a, b ) as select a, next value for seq_13_b from t_13_a\n";
        string4 = "drop view v_13";
        string5 = "X0Y23";
        this.verifyRestrictedDrop(connection, string3, string4, string, string2, string5);
    }

    public void test_14_insertSelect() throws Exception {
        Connection connection = this.openUserConnection(ALPHA);
        this.goodStatement(connection, "create sequence sequence_is");
        this.goodStatement(connection, "create table tis_1( a int )");
        this.goodStatement(connection, "create table tis_2( a int, b int )");
        this.goodStatement(connection, "insert into tis_1( a ) values ( 1 ), ( 2 )");
        this.goodStatement(connection, "insert into tis_2 select next value for sequence_is, a from tis_1");
        this.assertResults(connection, "select * from tis_2 order by b", new String[][]{{"-2147483648", "1"}, {"-2147483647", "2"}}, true);
    }

    public void test_15_5254() throws Exception {
        Connection connection = this.openUserConnection(ALPHA);
        this.goodStatement(connection, "create table t_5254( cycle int, minvalue int, maxvalue int )");
        this.goodStatement(connection, "drop table t_5254");
    }

    public void test_16_6137() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        Connection connection = this.openUserConnection(TEST_DBO);
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '2' )");
        this.goodStatement(connection, "create table t_6137( rateID int generated always as identity primary key, amount decimal( 5,2 ) )");
        this.goodStatement(connection, "create table t_history_6137( changeID int primary key, amount decimal( 5,2 ) )");
        this.goodStatement(connection, "create sequence seq_6137 start with 1");
        this.goodStatement(connection, "create trigger trg_t_6137_hist_del\nafter delete on t_6137\nreferencing old row as old\nfor each row\n insert into t_history_6137 ( changeID, amount ) values (( next value for seq_6137 ), old.amount )\n");
        this.goodStatement(connection, "insert into t_6137( amount ) values ( 30.04 ), ( 60.04 ), ( 90.04 )");
        this.goodStatement(connection, "call syscs_util.syscs_invalidate_stored_statements()");
        this.assertResults(connection, "values next value for seq_6137", new String[][]{{"1"}}, true);
        this.goodStatement(connection, "delete from t_6137 where rateID = 1");
        this.goodStatement(connection, "delete from t_6137 where rateID = 2");
        this.assertResults(connection, "select * from t_history_6137 order by changeID", new String[][]{{"2", "30.04"}, {"3", "60.04"}}, true);
        String string = "values syscs_util.syscs_peek_at_sequence('TEST_DBO', 'SEQ_6137')";
        this.assertResults(connection, string, new String[][]{{"4"}}, true);
        this.goodStatement(connection, "drop trigger trg_t_6137_hist_del");
        this.goodStatement(connection, "drop table t_history_6137");
        this.goodStatement(connection, "drop table t_6137");
        this.goodStatement(connection, "drop sequence seq_6137 restrict");
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', null )");
        this.expectExecutionError(connection, "X0X81", string);
        this.expectCompilationError(connection, "42X94", "values next value for seq_6137");
    }

    public void test_17_6554() throws Exception {
        Connection connection = this.openUserConnection(ALPHA);
        Connection connection2 = this.openUserConnection(BETA);
        connection.setAutoCommit(false);
        connection2.setAutoCommit(false);
        String string = "create sequence seq6554";
        String string2 = "values next value for seq6554";
        String[][] stringArray = new String[][]{{"-2147483648"}};
        this.goodStatement(connection, string);
        this.assertResults(connection, string2, stringArray, true);
        connection.rollback();
        this.goodStatement(connection2, string);
        this.assertResults(connection2, string2, stringArray, true);
        connection2.rollback();
        this.goodStatement(connection, "create procedure createSequence( sequenceName varchar( 128 ) )\nlanguage java parameter style java modifies sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.SequenceTest.createSequence'\n");
        this.goodStatement(connection, "grant execute on procedure createSequence to public");
        connection.commit();
        String string3 = "call alpha.createSequence( 'seq6554_2' )";
        String string4 = "values next value for seq6554_2";
        String[][] stringArray2 = new String[][]{{"-2147483647"}};
        this.goodStatement(connection, string3);
        this.assertResults(connection, string4, stringArray2, true);
        connection.rollback();
        this.goodStatement(connection2, string3);
        this.assertResults(connection2, string4, stringArray2, true);
        connection2.rollback();
        connection.setAutoCommit(true);
        connection2.setAutoCommit(true);
    }

    public void test_17_6554_cacheEviction() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.language.sequenceGeneratorCacheSize', '5' )");
        this.getTestConfiguration().shutdownDatabase();
        Connection connection2 = this.openUserConnection(ALPHA);
        Connection connection3 = this.openUserConnection(ALPHA);
        this.goodStatement(connection2, "create sequence s000");
        this.assertResults(connection2, "values next value for s000", new String[][]{{"-2147483648"}}, true);
        this.goodStatement(connection2, "create sequence s001");
        this.assertResults(connection2, "values next value for s001", new String[][]{{"-2147483648"}}, true);
        this.assertResults(connection2, "values next value for s001", new String[][]{{"-2147483647"}}, true);
        this.goodStatement(connection3, "create sequence s002");
        this.goodStatement(connection3, "create sequence s003");
        this.goodStatement(connection3, "create sequence s004");
        this.goodStatement(connection3, "create sequence s005");
        this.goodStatement(connection3, "create sequence s006");
        this.goodStatement(connection3, "create sequence s007");
        this.goodStatement(connection3, "create sequence s008");
        this.goodStatement(connection3, "create sequence s009");
        this.goodStatement(connection3, "create sequence s010");
        this.assertResults(connection2, "values next value for s000", new String[][]{{"-2147483647"}}, true);
        this.assertResults(connection2, "values next value for s001", new String[][]{{"-2147483646"}}, true);
        connection = this.openUserConnection(TEST_DBO);
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.language.sequenceGeneratorCacheSize', '1000' )");
        this.getTestConfiguration().shutdownDatabase();
    }

    public static void createSequence(String string) throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.prepareStatement("create sequence " + string).execute();
        ResultSet resultSet = connection.prepareStatement("values next value for " + string).executeQuery();
        resultSet.next();
        SequenceTest.assertEquals((long)Integer.MIN_VALUE, (long)resultSet.getLong(1));
        resultSet.close();
    }
}

