/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LOBLocatorReleaseTest
extends BaseJDBCTestCase {
    public LOBLocatorReleaseTest(String string) {
        super(string);
    }

    public void testNoLOBs() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from sys.systables");
        while (resultSet.next()) {
        }
        resultSet.close();
        statement = this.createStatement(1004, 1007);
        this.getConnection().setAutoCommit(false);
        resultSet = statement.executeQuery("select * from sys.systables");
        resultSet.absolute(3);
        while (resultSet.next()) {
        }
        resultSet.previous();
        resultSet.absolute(2);
        resultSet.relative(2);
        resultSet.afterLast();
        resultSet.first();
        resultSet.next();
        resultSet.last();
        resultSet.beforeFirst();
        statement.close();
        resultSet.close();
        this.rollback();
    }

    public void testForwardOnlyWithNoNulls() throws SQLException {
        this.forwardOnlyTest("LOBLOC_NO_NULLS");
    }

    public void testForwardOnlyWithNulls() throws SQLException {
        this.forwardOnlyTest("LOBLOC_WITH_NULLS");
    }

    private void forwardOnlyTest(String string) throws SQLException {
        String string2 = "select dBlob, dClob from " + string;
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        while (resultSet.next()) {
        }
        resultSet.close();
        resultSet = statement.executeQuery(string2);
        int n = 0;
        while (resultSet.next()) {
            Object object;
            if (n % 2 == 0) {
                object = resultSet.getBlob(1);
                if (!resultSet.wasNull()) {
                    object.length();
                }
            }
            if (n % 3 == 0) {
                object = resultSet.getClob(2);
                if (!resultSet.wasNull()) {
                    object.length();
                }
            }
            if (n == 9) {
                this.commit();
            }
            ++n;
        }
        resultSet.close();
        statement.close();
        statement = this.createStatement();
        resultSet = statement.executeQuery(string2);
        resultSet.next();
        resultSet.next();
        statement.close();
        this.commit();
        statement = this.createStatement();
        resultSet = statement.executeQuery(string2);
        resultSet.next();
        resultSet.next();
        this.rollback();
        resultSet.close();
    }

    public void testBlobClobStateForwardOnlyWithNoNulls() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select dBlob, dClob from LOBLOC_NO_NULLS");
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        long l = blob.length();
        resultSet.next();
        Clob clob = resultSet.getClob(2);
        long l2 = clob.length();
        resultSet.next();
        resultSet.close();
        LOBLocatorReleaseTest.assertEquals((long)l, (long)blob.length());
        LOBLocatorReleaseTest.assertEquals((long)l2, (long)clob.length());
        this.commit();
        try {
            clob.getSubString(1L, 9);
            LOBLocatorReleaseTest.fail((String)"Locator should have been released, causing the call to fail");
        }
        catch (SQLException sQLException) {
            LOBLocatorReleaseTest.assertSQLState("XJ215", sQLException);
        }
    }

    public void testBlobClobStateAfterCloseOnScrollable() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery("select dBlob, dClob from LOBLOC_NO_NULLS");
        resultSet.next();
        resultSet.relative(5);
        Blob blob = resultSet.getBlob(1);
        long l = blob.length();
        resultSet.next();
        Clob clob = resultSet.getClob(2);
        long l2 = clob.length();
        resultSet.first();
        resultSet.close();
        LOBLocatorReleaseTest.assertEquals((long)l, (long)blob.length());
        LOBLocatorReleaseTest.assertEquals((long)l2, (long)clob.length());
        this.commit();
        try {
            clob.getSubString(1L, 9);
            LOBLocatorReleaseTest.fail((String)"Locator should have been released, causing the call to fail");
        }
        catch (SQLException sQLException) {
            LOBLocatorReleaseTest.assertSQLState("XJ215", sQLException);
        }
    }

    public void testScrollableWithNoNulls() throws SQLException {
        this.scrollableTest("LOBLOC_NO_NULLS", 1007);
        this.scrollableTest("LOBLOC_NO_NULLS", 1008);
    }

    public void testScrollableWithNulls() throws SQLException {
        this.scrollableTest("LOBLOC_WITH_NULLS", 1007);
        this.scrollableTest("LOBLOC_WITH_NULLS", 1008);
    }

    private void scrollableTest(String string, int n) throws SQLException {
        String string2 = "select dBlob, dClob from " + string;
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement(1004, n);
        ResultSet resultSet = statement.executeQuery(string2);
        while (resultSet.next()) {
        }
        resultSet.close();
        resultSet = statement.executeQuery(string2);
        resultSet.next();
        resultSet.beforeFirst();
        resultSet.first();
        resultSet.relative(3);
        resultSet.previous();
        resultSet.last();
        resultSet.absolute(5);
        resultSet.afterLast();
        resultSet.next();
    }

    public void testScrollableMoveToCurrentRow() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("select dBlob, dClob from LOBLOC_NO_NULLS");
        resultSet.next();
        resultSet.moveToCurrentRow();
        resultSet.moveToCurrentRow();
    }

    public void testScrollableAbsoluteRow() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("select dBlob, dClob from LOBLOC_NO_NULLS");
        resultSet.next();
        resultSet.absolute(4);
        resultSet.absolute(4);
        resultSet.absolute(4);
    }

    public void testScrollableUpdateWithLocators() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("select dBlob, dClob from LOBLOC_NO_NULLS");
        resultSet.absolute(3);
        Clob clob = resultSet.getClob(2);
        int n = (int)clob.length();
        String string = clob.getSubString(1L, n);
        clob.setString(n, "FIRSTPASS");
        resultSet.absolute(7);
        resultSet.next();
        resultSet.absolute(3);
        Clob clob2 = resultSet.getClob(2);
        LOBLocatorReleaseTest.assertEquals((String)string, (String)clob2.getSubString(1L, (int)clob2.length()));
        resultSet.updateRow();
        resultSet.absolute(3);
        Clob clob3 = resultSet.getClob(2);
        LOBLocatorReleaseTest.assertEquals((String)string, (String)clob3.getSubString(1L, (int)clob3.length()));
        resultSet.previous();
        resultSet.next();
        Clob clob4 = resultSet.getClob(2);
        clob4.setString(1L, "THIS IS THE NEW VALUE!");
        resultSet.updateClob(2, clob4);
        resultSet.updateRow();
        clob4.setString(1L, "THIS IS NOT NOT NOT THE NEW VALUE!");
        resultSet.updateRow();
        resultSet.next();
        resultSet.absolute(3);
        Clob clob5 = resultSet.getClob(2);
        LOBLocatorReleaseTest.assertEquals((String)"THIS IS THE NEW VALUE!", (String)clob5.getSubString(1L, (int)clob5.length()));
        this.rollback();
        this.assertInvalid(clob);
        this.assertInvalid(clob2);
        this.assertInvalid(clob3);
        this.assertInvalid(clob4);
        this.assertInvalid(clob5);
    }

    private void assertInvalid(Clob clob) {
        try {
            clob.getSubString(1L, (int)clob.length());
            LOBLocatorReleaseTest.fail((String)"Clob should have been invalidated");
        }
        catch (SQLException sQLException) {
            LOBLocatorReleaseTest.assertSQLState("XJ215", sQLException);
        }
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.clientServerSuite(LOBLocatorReleaseTest.class)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                int n;
                byte[] byArray;
                statement.executeUpdate("create table LOBLOC_NO_NULLS (dBlob BLOB not null, dClob CLOB not null)");
                Connection connection = statement.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement("insert into LOBLOC_NO_NULLS values (?,?)");
                String string = "A little test Clob";
                try {
                    byArray = string.getBytes("US-ASCII");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    SQLException sQLException = new SQLException();
                    sQLException.initCause(unsupportedEncodingException);
                    throw sQLException;
                }
                for (n = 0; n < 25; ++n) {
                    preparedStatement.setBytes(1, byArray);
                    preparedStatement.setString(2, string);
                    preparedStatement.executeUpdate();
                }
                preparedStatement.close();
                statement.executeUpdate("create table LOBLOC_WITH_NULLS (dBlob BLOB, dClob CLOB)");
                preparedStatement = connection.prepareStatement("insert into LOBLOC_WITH_NULLS values (?,?)");
                for (n = 0; n < 25; ++n) {
                    if (n % 3 == 0) {
                        preparedStatement.setNull(1, 2004);
                    } else {
                        preparedStatement.setBytes(1, byArray);
                    }
                    if (n % 4 == 0) {
                        preparedStatement.setNull(2, 2005);
                    } else {
                        preparedStatement.setString(2, string);
                    }
                    preparedStatement.executeUpdate();
                }
                preparedStatement.close();
                connection.commit();
            }
        };
    }
}

