/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import junit.framework.Test;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.IntArray;
import org.apache.derbyTesting.functionTests.tests.lang.Price;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UDTTest
extends GeneratedColumnsHelper {
    public static final String OBJECT_EXISTS = "X0Y68";
    public static final String VIEW_DEPENDS_ON_TYPE = "X0Y23";
    public static final String TRIGGER_DEPENDS_ON_TYPE = "X0Y24";

    public UDTTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(UDTTest.class);
    }

    public void test_01_basicSyntax() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create schema adt_schema\n");
        this.makeGoodTypes(conn);
        this.expectExecutionError(conn, OBJECT_EXISTS, "create type fooType external name 'mypackage.foo' language java\n");
        this.expectExecutionError(conn, OBJECT_EXISTS, "create type adt_schema.fooType external name 'mypackage.foo' language java\n");
        this.expectExecutionError(conn, OBJECT_EXISTS, "create type \"smallint\" external name 'mypackage.foo' language java\n");
        this.expectExecutionError(conn, OBJECT_EXISTS, "create type \"SMALLINT\" external name 'mypackage.foo' language java\n");
        this.expectCompilationError("42X01", "drop type fooType\n");
        this.goodStatement(conn, "drop type fooType restrict\n");
        this.goodStatement(conn, "drop type adt_schema.fooType restrict\n");
        this.goodStatement(conn, "drop type \"smallint\" restrict\n");
        this.goodStatement(conn, "drop type \"SMALLINT\" restrict\n");
        this.expectCompilationError("42Y55", "drop type fooType restrict\n");
        this.expectCompilationError("42Y55", "drop type adt_schema.fooType restrict\n");
        this.expectCompilationError("42Y55", "drop type \"smallint\" restrict\n");
        this.expectCompilationError("42Y55", "drop type \"SMALLINT\" restrict\n");
        this.makeGoodTypes(conn);
    }

    private void makeGoodTypes(Connection conn) throws Exception {
        this.goodStatement(conn, "create type fooType external name 'mypackage.foo' language java\n");
        this.goodStatement(conn, "create type adt_schema.fooType external name 'mypackage.foo' language java\n");
        this.goodStatement(conn, "create type \"smallint\" external name 'mypackage.foo' language java\n");
        this.goodStatement(conn, "create type \"SMALLINT\" external name 'mypackage.foo' language java\n");
    }

    public void test_02_basicColumnRetvalParam() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create type Price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(conn, "create table orders( orderID int generated always as identity, customerID int, totalPrice price )\n");
        this.goodStatement(conn, "create function makePrice( currencyCode char( 3 ), amount decimal( 31, 5 ), timeInstant Timestamp )\nreturns Price language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n");
        this.goodStatement(conn, "create function getCurrencyCode( price Price ) returns char( 3 ) language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.getCurrencyCode'\n");
        this.goodStatement(conn, "create function getAmount( price Price ) returns decimal( 31, 5 ) language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.getAmount'\n");
        this.goodStatement(conn, "create function getTimeInstant( price Price ) returns timestamp language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.getTimeInstant'\n");
        this.goodStatement(conn, "create procedure savePrice( in a Price ) language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.savePrice'\n");
        this.goodStatement(conn, "create function getSavedPrice() returns Price language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.getSavedPrice'\n");
        this.goodStatement(conn, "insert into orders( customerID, totalPrice ) values\n( 12345, makePrice( 'USD', cast( 9.99 as decimal( 31, 5 ) ), timestamp('2009-10-16 14:24:43') ) )\n");
        this.assertResults(conn, "select getCurrencyCode( totalPrice ), getTimeInstant( totalPrice ) from orders", new String[][]{{"USD", "2009-10-16 14:24:43.0"}}, false);
        this.assertResults(conn, "select totalPrice from orders", new String[][]{{"Price( USD, 9.99000, 2009-10-16 14:24:43.0 )"}}, false);
        this.goodStatement(conn, "call savePrice\n( makePrice( 'EUR', cast( 1.23 as decimal( 31, 5 ) ), timestamp('2008-10-16 14:24:43') ) )\n");
        this.assertResults(conn, "values( getSavedPrice() )", new String[][]{{"Price( EUR, 1.23000, 2008-10-16 14:24:43.0 )"}}, false);
    }

    public void test_03_addDropColumn() throws Exception {
        Connection conn = this.getConnection();
        String tableName1 = "UDTCOLUMNS";
        String tableName2 = "UDTCOLUMNS2";
        this.goodStatement(conn, "create type price_03 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(conn, "create table " + tableName1 + "\n(\n    a int, b int,\n    price1 price_03,\n    price2 price_03\n)\n");
        UDTTest.assertEquals((int)1, (int)this.countTableDependencies(conn, tableName1));
        this.expectExecutionError(conn, "X0Y29", "drop type Price_03 restrict\n");
        this.goodStatement(conn, "alter table udtColumns add column price3 price_03\n");
        UDTTest.assertEquals((int)1, (int)this.countTableDependencies(conn, tableName1));
        this.expectExecutionError(conn, "X0Y29", "drop type Price_03 restrict\n");
        this.goodStatement(conn, "alter table udtColumns drop column price3\n");
        UDTTest.assertEquals((int)1, (int)this.countTableDependencies(conn, tableName1));
        this.expectExecutionError(conn, "X0Y29", "drop type Price_03 restrict\n");
        this.goodStatement(conn, "alter table udtColumns drop column price2\n");
        UDTTest.assertEquals((int)1, (int)this.countTableDependencies(conn, tableName1));
        this.expectExecutionError(conn, "X0Y29", "drop type Price_03 restrict\n");
        this.goodStatement(conn, "alter table udtColumns drop column price1\n");
        UDTTest.assertEquals((int)0, (int)this.countTableDependencies(conn, tableName1));
        this.goodStatement(conn, "drop type Price_03 restrict\n");
        this.goodStatement(conn, "create type price_03_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(conn, "create type price_03_b external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(conn, "create type price_03_c external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(conn, "create table udtColumns2\n(\n    a int, b int,\n    price1 price_03_a,\n    price2 price_03_b\n)\n");
        UDTTest.assertEquals((int)2, (int)this.countTableDependencies(conn, tableName2));
        this.expectExecutionError(conn, "X0Y29", "drop type Price_03_a restrict\n");
        this.expectExecutionError(conn, "X0Y29", "drop type Price_03_b restrict\n");
        this.goodStatement(conn, "alter table udtColumns2 add column price3 price_03_c\n");
        UDTTest.assertEquals((int)3, (int)this.countTableDependencies(conn, tableName2));
        this.expectExecutionError(conn, "X0Y29", "drop type Price_03_a restrict\n");
        this.expectExecutionError(conn, "X0Y29", "drop type Price_03_b restrict\n");
        this.expectExecutionError(conn, "X0Y29", "drop type Price_03_c restrict\n");
        this.goodStatement(conn, "alter table udtColumns2 drop column b\n");
        UDTTest.assertEquals((int)3, (int)this.countTableDependencies(conn, tableName2));
        this.expectExecutionError(conn, "X0Y29", "drop type Price_03_a restrict\n");
        this.expectExecutionError(conn, "X0Y29", "drop type Price_03_b restrict\n");
        this.expectExecutionError(conn, "X0Y29", "drop type Price_03_c restrict\n");
        this.goodStatement(conn, "alter table udtColumns2 drop column price3\n");
        UDTTest.assertEquals((int)2, (int)this.countTableDependencies(conn, tableName2));
        this.goodStatement(conn, "drop type Price_03_c restrict\n");
        this.goodStatement(conn, "alter table udtColumns2 drop column price2\n");
        UDTTest.assertEquals((int)1, (int)this.countTableDependencies(conn, tableName2));
        this.goodStatement(conn, "drop type Price_03_b restrict\n");
        this.goodStatement(conn, "alter table udtColumns2 drop column price1\n");
        UDTTest.assertEquals((int)0, (int)this.countTableDependencies(conn, tableName2));
        this.goodStatement(conn, "drop type Price_03_a restrict\n");
    }

    public void test_04_dropTable() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create type price_orphan external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(conn, "create type price_orphan2 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(conn, "create type price_orphan3 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(conn, "create type price_orphan4 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(conn, "create table t_orphan( a price_orphan )\n");
        this.goodStatement(conn, "create table t_orphan2( a price_orphan2, b int, c price_orphan2 )\n");
        this.goodStatement(conn, "create table t_orphan3( a price_orphan3, b int, c price_orphan4 )\n");
        this.expectExecutionError(conn, "X0Y29", "drop type price_orphan restrict\n");
        this.goodStatement(conn, "drop table t_orphan\n");
        this.goodStatement(conn, "drop type price_orphan restrict\n");
        this.expectExecutionError(conn, "X0Y29", "drop type price_orphan2 restrict\n");
        this.goodStatement(conn, "drop table t_orphan2\n");
        this.goodStatement(conn, "drop type price_orphan2 restrict\n");
        this.expectExecutionError(conn, "X0Y29", "drop type price_orphan3 restrict\n");
        this.expectExecutionError(conn, "X0Y29", "drop type price_orphan4 restrict\n");
        this.goodStatement(conn, "drop table t_orphan3\n");
        this.goodStatement(conn, "drop type price_orphan3 restrict\n");
        this.goodStatement(conn, "drop type price_orphan4 restrict\n");
    }

    public void test_05_viewDependencies() throws Exception {
        Connection conn = this.getConnection();
        String createTypeStatement = "create type price_05_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n";
        String dropTypeStatement = "drop type price_05_a restrict\n";
        String createObjectStatement = "create view udtView( a, b, c ) as\nselect tabletype, cast (null as price_05_a), cast( null as price_05_a)\nfrom sys.systables\n";
        String dropObjectStatement = "drop view udtView\n";
        String badDropSQLState = VIEW_DEPENDS_ON_TYPE;
        this.verifyDropRestrictions(conn, createTypeStatement, dropTypeStatement, createObjectStatement, dropObjectStatement, badDropSQLState);
        createTypeStatement = "create type price_05_b external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n";
        dropTypeStatement = "drop type price_05_b restrict\n";
        createObjectStatement = "create view udtView_b( a ) as\nselect tabletype from sys.systables where ( cast (null as price_05_b) ) is not null\n";
        dropObjectStatement = "drop view udtView_b\n";
        badDropSQLState = VIEW_DEPENDS_ON_TYPE;
        this.verifyDropRestrictions(conn, createTypeStatement, dropTypeStatement, createObjectStatement, dropObjectStatement, badDropSQLState);
    }

    public void test_06_casts() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create type price_06_b external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.assertResults(conn, "values ( cast ( null as price_06_b ) )\n", new String[][]{{null}}, false);
        PreparedStatement ps = this.chattyPrepare(conn, "values ( cast ( ? as price_06_b ) )");
        ps.setObject(1, Price.makePrice());
        ResultSet rs = ps.executeQuery();
        rs.next();
        Price result = (Price)rs.getObject(1);
        rs.close();
        ps.close();
        UDTTest.assertTrue((boolean)Price.makePrice().equals(result));
    }

    public void test_07_routineDependencies() throws Exception {
        Connection conn = this.getConnection();
        String createTypeStatement = "create type price_07_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n";
        String dropTypeStatement = "drop type price_07_a restrict\n";
        String createObjectStatement = "create function makePrice_07_a( )\nreturns price_07_a\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n";
        String dropObjectStatement = "drop function makePrice_07_a\n";
        String badDropSQLState = "X0Y30";
        this.verifyDropRestrictions(conn, createTypeStatement, dropTypeStatement, createObjectStatement, dropObjectStatement, badDropSQLState);
        createTypeStatement = "create type price_07_b external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n";
        dropTypeStatement = "drop type price_07_b restrict\n";
        createObjectStatement = "create function getCurrencyCode_07_b(  priceArg1 price_07_b  )\nreturns char( 3 )\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.getCurrencyCode'\n";
        dropObjectStatement = "drop function getCurrencyCode_07_b\n";
        badDropSQLState = "X0Y30";
        this.verifyDropRestrictions(conn, createTypeStatement, dropTypeStatement, createObjectStatement, dropObjectStatement, badDropSQLState);
        createTypeStatement = "create type price_07_c external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n";
        dropTypeStatement = "drop type price_07_c restrict\n";
        createObjectStatement = "create procedure oneArgPriceProc_07( price1 price_07_c )\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.oneArgPriceProc_07'\n";
        dropObjectStatement = "drop procedure oneArgPriceProc_07\n";
        badDropSQLState = "X0Y30";
        this.verifyDropRestrictions(conn, createTypeStatement, dropTypeStatement, createObjectStatement, dropObjectStatement, badDropSQLState);
        createTypeStatement = "create type price_07_d external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n";
        dropTypeStatement = "drop type price_07_d restrict\n";
        createObjectStatement = "create procedure twoArgPriceProc_07( price1 price_07_d, price2 price_07_d )\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.twoArgPriceProc_07'\n";
        dropObjectStatement = "drop procedure twoArgPriceProc_07\n";
        badDropSQLState = "X0Y30";
        this.verifyDropRestrictions(conn, createTypeStatement, dropTypeStatement, createObjectStatement, dropObjectStatement, badDropSQLState);
        createTypeStatement = "create type hashmap_07 external name 'java.util.HashMap' language java\n";
        dropTypeStatement = "drop type hashmap_07 restrict\n";
        createObjectStatement = "create function hashmapReader_07() returns table\n(\n    a int,\n    b hashmap_07\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.hashmapReader'\n";
        dropObjectStatement = "drop function hashmapReader_07\n";
        badDropSQLState = "X0Y30";
        this.verifyDropRestrictions(conn, createTypeStatement, dropTypeStatement, createObjectStatement, dropObjectStatement, badDropSQLState);
        createTypeStatement = "create type hashmap_07_a external name 'java.util.HashMap' language java\n";
        dropTypeStatement = "drop type hashmap_07_a restrict\n";
        createObjectStatement = "create function hashmapReader_07_a( a hashmap_07_a ) returns table\n(\n    a int,\n    b hashmap_07_a\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.hashmapReader'\n";
        dropObjectStatement = "drop function hashmapReader_07_a\n";
        badDropSQLState = "X0Y30";
        this.verifyDropRestrictions(conn, createTypeStatement, dropTypeStatement, createObjectStatement, dropObjectStatement, badDropSQLState);
    }

    public void test_08_triggerDependencies() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_08_a( a int )");
        this.goodStatement(conn, "create table t_08_b( a int )");
        String createTypeStatement = "create type price_08_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n";
        String dropTypeStatement = "drop type price_08_a restrict\n";
        String createObjectStatement = "create trigger trig_08_a after insert on t_08_a\n  insert into t_08_b( a ) select ( a ) from t_08_a where ( cast( null as price_08_a ) ) is not null\n";
        String dropObjectStatement = "drop trigger trig_08_a";
        String badDropSQLState = TRIGGER_DEPENDS_ON_TYPE;
        this.verifyDropRestrictions(conn, createTypeStatement, dropTypeStatement, createObjectStatement, dropObjectStatement, badDropSQLState);
    }

    public void test_09_resultSetMetaData() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create type price_09_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(conn, "create table t_09_a( a price_09_a )\n");
        this.checkRSMD(conn, "select a from t_09_a\n", "org.apache.derbyTesting.functionTests.tests.lang.Price", 15, 2000, "\"APP\".\"PRICE_09_A\"", 0, 0);
        this.checkRSMD(conn, "select aliasinfo from sys.sysaliases\n", "org.apache.derby.catalog.AliasInfo", 15, 2000, "org.apache.derby.catalog.AliasInfo", 0, 0);
    }

    public void test_10_parameterMetaData() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create type price_10_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(conn, "create table t_10_a( a price_10_a )\n");
        this.checkPMD(conn, "insert into t_10_a( a ) values ( ? )\n", "org.apache.derbyTesting.functionTests.tests.lang.Price", 2000, "\"APP\".\"PRICE_10_A\"", 0, 0);
    }

    public void test_11_tableFunctionColumns() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create type hashmap_11 external name 'java.util.HashMap' language java\n");
        this.goodStatement(conn, "create function makeHashMap_11() returns hashmap_11\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.makeHashMap'\n");
        this.goodStatement(conn, "create function putValue_11( map hashmap_11, k varchar( 100 ), v varchar( 100 ) ) returns hashmap_11\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.putValue'\n");
        this.goodStatement(conn, "create table t_11( intCol int, varcharCol varchar( 10 ), hashmapCol hashmap_11 )\n");
        this.goodStatement(conn, "create function hashmapReader() returns table\n(\n    a int,\n    b hashmap_11\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.hashmapReader'\n");
        this.goodStatement(conn, "insert into t_11( intCol, varcharCol, hashmapCol ) values ( 2, 'def', putValue_11( makeHashMap_11(), 'kangaroo', 'foo' ) )\n");
        this.assertResults(conn, "select * from table( hashmapReader() ) s", new String[][]{{"2", "{kangaroo=foo}"}}, true);
    }

    public void test_12_largeUDTs() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create type IntArray external name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray' language java\n");
        this.goodStatement(conn, "create function makeIntArray( arrayLength int ) returns IntArray\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray.makeIntArray'\n");
        this.goodStatement(conn, "create function setCell( array IntArray, cellNumber int, cellValue int ) returns IntArray\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray.setCell'\n");
        this.goodStatement(conn, "create function getCell( array IntArray, cellNumber int ) returns int\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray.getCell'\n");
        this.goodStatement(conn, "create table t_12( id int generated always as identity, data IntArray )\n");
        this.goodStatement(conn, "insert into t_12( data ) values ( setCell( makeIntArray( 3 ), 1, 5 ) )\n");
        this.goodStatement(conn, "insert into t_12( data ) values ( setCell( makeIntArray( 100000 ), 90000, 3 ) )\n");
        this.assertResults(conn, "select getCell( data, 1 ), getCell( data, 2 ) from t_12 where id = 1", new String[][]{{"5", "0"}}, true);
        this.assertResults(conn, "select getCell( data, 1 ), getCell( data, 90000 ) from t_12 where id = 2", new String[][]{{"0", "3"}}, true);
        this.goodStatement(conn, "create type FakeByteArray external name 'org.apache.derbyTesting.functionTests.tests.lang.FakeByteArray' language java\n");
        this.goodStatement(conn, "create function makeFakeByteArray( l int, f int ) returns FakeByteArray\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.FakeByteArray.makeFakeByteArray'\n");
        this.goodStatement(conn, "create function toString( arg FakeByteArray ) returns varchar( 30 )\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.FakeByteArray.toString'\n");
        this.goodStatement(conn, "create table t_12_a( id int generated always as identity, data FakeByteArray )\n");
        this.goodStatement(conn, "insert into t_12_a( data ) values ( makeFakeByteArray( 3, 33 ) )\n");
        this.goodStatement(conn, "insert into t_12_a( data ) values ( makeFakeByteArray( 1000000, 44 ) )\n");
        this.assertResults(conn, "select id, toString( data ) from t_12_a order by id", new String[][]{{"1", "[ 3, 33 ]"}, {"2", "[ 1000000, 44 ]"}}, true);
    }

    public void test_13_sqlData() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create type SampleSQLData external name 'org.apache.derbyTesting.functionTests.tests.lang.SampleSQLData' language java\n");
        this.goodStatement(conn, "create function makeSampleSQLData( l int ) returns SampleSQLData\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.SampleSQLData.makeSampleSQLData'\n");
        this.goodStatement(conn, "create table t_13_a( id int generated always as identity, data SampleSQLData )\n");
        this.expectExecutionError(conn, "XJ001", "insert into t_13_a( data ) values ( makeSampleSQLData( 3 ) )\n");
    }

    public void test_14_systemClasses() throws Exception {
        Connection conn = this.getConnection();
        UDTTest.assertEquals((int)21, (int)this.vetDatatypeCount(conn));
        this.expectCompilationError("42Z10", "create type java_string external name 'byte[]' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.lang.Boolean' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.lang.Integer' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.lang.Long' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.lang.Float' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.lang.Double' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.lang.String' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.math.BigDecimal' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.sql.Blob' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.sql.Clob' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.sql.Date' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.sql.Ref' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.sql.Time' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.sql.Timestamp' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'org.apache.derby.iapi.types.XML' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'org.apache.derby.Foo' language java\n");
    }

    private int vetDatatypeCount(Connection conn) throws Exception {
        ResultSet rs = conn.getMetaData().getTypeInfo();
        int expectedTypeCount = 0;
        while (rs.next()) {
            ++expectedTypeCount;
        }
        rs.close();
        int actualTypeCount = TypeId.getAllBuiltinTypeIds().length;
        --actualTypeCount;
        --actualTypeCount;
        UDTTest.assertEquals((int)(--expectedTypeCount), (int)(++actualTypeCount));
        return actualTypeCount;
    }

    public void test_15_ordering() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create type IntArray_15 external name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray' language java\n");
        this.goodStatement(conn, "create function makeIntArray_15( arrayLength int ) returns IntArray_15\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray.makeIntArray'\n");
        this.goodStatement(conn, "create table t_15( a IntArray_15 )\n");
        this.goodStatement(conn, "insert into t_15( a ) values ( makeIntArray_15( 3 ) )\n");
        this.goodStatement(conn, "insert into t_15( a ) values ( makeIntArray_15( 4 ) )\n");
        this.expectCompilationError("X0X67", "create index t_15_idx on t_15( a )\n");
        this.expectCompilationError("X0X67", "select * from t_15 order by a\n");
        this.expectCompilationError("X0X67", "select * from t_15 group by a\n");
        this.expectCompilationError("X0X67", "select distinct a from t_15\n");
        this.expectCompilationError("42Y22", "select max( a ) from t_15\n");
        this.expectCompilationError("42Y22", "select min( a ) from t_15\n");
        this.expectCompilationError("42Y22", "select avg( a ) from t_15\n");
        this.expectCompilationError("X0X67", "select * from t_15 union select * from t_15\n");
        this.expectCompilationError("42818", "select * from t_15 where a = makeIntArray_15( 3 )\n");
        this.expectCompilationError("42818", "select * from t_15 where a between makeIntArray_15( 2 ) and makeIntArray_15( 4 )\n");
        this.expectCompilationError("42818", "select * from t_15 l, t_15 r where l.a = r.a\n");
        this.expectCompilationError("42818", "select * from t_15 l, t_15 r where l.a < r.a\n");
        this.expectCompilationError("42818", "select * from t_15 l, t_15 r where l.a > r.a\n");
        this.expectCompilationError("42818", "select * from t_15 l, t_15 r where l.a <= r.a\n");
        this.expectCompilationError("42818", "select * from t_15 l, t_15 r where l.a >= r.a\n");
        this.expectCompilationError("X0X67", "select count( distinct a ) from t_15\n");
        this.goodStatement(conn, "select count(*) from t_15\n");
        this.goodStatement(conn, "select all * from t_15\n");
    }

    public void test_16_casts() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create type javaSerializable external name 'java.io.Serializable' language java\n");
        this.goodStatement(conn, "create type javaNumber external name 'java.lang.Number' language java\n");
        this.goodStatement(conn, "create type javaDate external name 'java.util.Date' language java\n");
        this.goodStatement(conn, "create function makeNumber( arg int ) returns javaNumber\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.makeNumber'\n");
        this.goodStatement(conn, "create table t_16( a int generated always as identity, b javaNumber )\n");
        this.goodStatement(conn, "create table t_16_1( a int generated always as identity, b javaDate )\n");
        this.goodStatement(conn, "create table t_16_2( a int generated always as identity, b javaSerializable )\n");
        this.goodStatement(conn, "insert into t_16( b ) values ( makeNumber( 1 ) )\n");
        this.goodStatement(conn, "insert into t_16( b ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16( b ) values ( 1 )\n");
        this.expectCompilationError("42821", "insert into t_16( b ) values ( 1.0 )\n");
        this.expectCompilationError("42821", "insert into t_16( b ) values ( '1' )\n");
        this.expectCompilationError("42821", "insert into t_16_1( b ) values ( date('1994-02-23') )\n");
        this.expectCompilationError("42821", "insert into t_16_1( b ) values ( time('15:09:02') )\n");
        this.expectCompilationError("42821", "insert into t_16_1( b ) values ( timestamp('1960-01-01 23:03:20') )\n");
        this.expectCompilationError("42821", "insert into t_16_2( b ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_2( b ) values( cast (null as javaNumber) )\n");
        this.expectCompilationError("42846", "select cast (b as javaDate) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as javaSerializable) from t_16\n");
        UDTTest.assertEquals((int)21, (int)this.vetDatatypeCount(conn));
        this.expectCompilationError("42846", "select cast (b as boolean) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as bigint) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as blob) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as char( 1 ) ) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as char( 1 ) for bit data) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as clob) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as date) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as decimal) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as double) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as float) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as int) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as long varchar) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as long varchar for bit data) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as numeric) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as real) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as smallint) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as time) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as timestamp) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as varchar(10)) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as varchar(10) for bit data) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as xml) from t_16\n");
        UDTTest.assertEquals((int)21, (int)this.vetDatatypeCount(conn));
        this.goodStatement(conn, "create table t_16_all_types\n(\n    a01 bigint,\n    a02 blob,\n    a03 char( 1 ),\n    a04 char( 1 ) for bit data ,\n    a05 clob,\n    a06 date,\n    a07 decimal,\n    a08 double,\n    a09 float,\n    a10 int,\n    a11 long varchar,\n    a12 long varchar for bit data,\n    a13 numeric,\n    a14 real,\n    a15 smallint,\n    a16 time,\n    a17 timestamp,\n    a18 varchar(10),\n    a19 varchar(10) for bit data,\n    a20 xml,\n    a21 boolean\n)");
        this.expectCompilationError("42846", "select cast( a01 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a02 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a03 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a04 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a05 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a06 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a07 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a08 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a09 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a10 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a11 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a12 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a13 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a14 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a15 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a16 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a17 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a18 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a19 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a20 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a21 as javaSerializable ) from t_16_all_types\n");
        UDTTest.assertEquals((int)21, (int)this.vetDatatypeCount(conn));
        this.expectCompilationError("42821", "insert into t_16_all_types( a01 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a02 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a03 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a04 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a05 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a06 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a07 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a08 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a09 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a10 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a11 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a12 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a13 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a14 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a15 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a16 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a17 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a18 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a19 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a20 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a21 ) select b from t_16\n");
        this.expectCompilationError("42846", "select cast (isindex as javaNumber) from sys.sysconglomerates\n");
        this.assertResults(conn, "select cast (b as javaNumber) from t_16", new String[][]{{"1"}, {"1"}}, false);
    }

    public void test_17_outputParameters() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create type intArray_17 external name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray' language java\n");
        this.goodStatement(conn, "create procedure changeIntArray_17\n( in newSize int, inout oldIntArray intArray_17 )\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.changeIntArray'\n");
        CallableStatement cs = this.chattyPrepareCall(conn, "call changeIntArray_17( ?, ? )");
        cs.registerOutParameter(2, 2000);
        cs.setInt(1, 2);
        cs.setObject(2, (Object)new IntArray(new int[5]));
        cs.execute();
        Object obj = cs.getObject(2);
        cs.close();
        UDTTest.assertEquals((String)"[ 0, 0 ]", (String)obj.toString());
    }

    public void test_18_derby6421() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create type d6421_type external name 'java.util.ArrayList' language java");
        s.execute("create table d6421_table (x generated always as (cast(null as d6421_type)), check (cast(null as d6421_type) is null))");
        s.execute("insert into d6421_table values default");
    }

    public static void oneArgPriceProc(Price price1) {
    }

    public static void twoArgPriceProc(Price price1, Price price2) {
    }

    public static void changeIntArray(int newSize, IntArray[] array) {
        IntArray newArray;
        array[0] = newArray = new IntArray(new int[newSize]);
    }

    public static HashMap makeHashMap() {
        return new HashMap();
    }

    public static HashMap makeHashMap(String key, Integer value) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put(key, value);
        return map;
    }

    public static HashMap putValue(HashMap<String, String> map, String key, String value) {
        map.put(key, value);
        return map;
    }

    public static ResultSet hashmapReader() throws Exception {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("select intCol, hashmapCol from t_11");
        return ps.executeQuery();
    }

    public static Number makeNumber(int arg) {
        return arg;
    }

    public static Integer getIntValue(HashMap<String, Integer> map, String key) {
        return map.get(key);
    }

    private void verifyDropRestrictions(Connection conn, String createTypeStatement, String dropTypeStatement, String createObjectStatement, String dropObjectStatement, String badDropSQLState) throws Exception {
        this.goodStatement(conn, createTypeStatement);
        this.goodStatement(conn, createObjectStatement);
        this.expectExecutionError(conn, badDropSQLState, dropTypeStatement);
        this.goodStatement(conn, dropObjectStatement);
        this.goodStatement(conn, dropTypeStatement);
    }

    private int countTableDependencies(Connection conn, String tableName) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "select count(*) from sys.sysdepends d, sys.systables t where d.dependentid = t.tableid and t.tablename = ?");
        ps.setString(1, tableName);
        return this.getScalarInteger(ps);
    }

    private int getScalarInteger(PreparedStatement ps) throws Exception {
        ResultSet rs = ps.executeQuery();
        rs.next();
        int retval = rs.getInt(1);
        rs.close();
        ps.close();
        return retval;
    }

    private void checkRSMD(Connection conn, String query, String expectedClassName, int expectedDisplaySize, int expectedJDBCType, String expectedSQLTypeName, int expectedPrecision, int expectedScale) throws Exception {
        PreparedStatement ps = conn.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        UDTTest.assertEquals((String)rsmd.getColumnClassName(1), (String)expectedClassName);
        UDTTest.assertEquals((int)rsmd.getColumnDisplaySize(1), (int)expectedDisplaySize);
        UDTTest.assertEquals((int)rsmd.getColumnType(1), (int)expectedJDBCType);
        UDTTest.assertEquals((String)rsmd.getColumnTypeName(1), (String)expectedSQLTypeName);
        UDTTest.assertEquals((int)rsmd.getPrecision(1), (int)expectedPrecision);
        UDTTest.assertEquals((int)rsmd.getScale(1), (int)expectedScale);
        rs.close();
        ps.close();
    }

    private void checkPMD(Connection conn, String query, String expectedClassName, int expectedJDBCType, String expectedSQLTypeName, int expectedPrecision, int expectedScale) throws Exception {
        PreparedStatement ps = conn.prepareStatement(query);
        ParameterMetaData pmd = ps.getParameterMetaData();
        UDTTest.assertEquals((String)pmd.getParameterClassName(1), (String)expectedClassName);
        UDTTest.assertEquals((int)pmd.getParameterType(1), (int)expectedJDBCType);
        UDTTest.assertEquals((String)pmd.getParameterTypeName(1), (String)expectedSQLTypeName);
        UDTTest.assertEquals((int)pmd.getPrecision(1), (int)expectedPrecision);
        UDTTest.assertEquals((int)pmd.getScale(1), (int)expectedScale);
        ps.close();
    }
}

