/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ResultSetJDBC30Test
extends BaseJDBCTestCase {
    private static final String NOT_IMPLEMENTED = "0A000";
    private static final String UPDATABLE_RESULTSET_API_DISALLOWED = "XJ083";

    public ResultSetJDBC30Test(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table t (i int, s smallint, r real, d double precision, dt date, t time, ts timestamp, c char(10), v varchar(40) not null, dc dec(10,2))");
        statement.execute("insert into t values(1,2,3.3,4.4,date('1990-05-05'),time('12:06:06'),timestamp('1990-07-07 07:07:07.07'),'eight','nine', 11.1)");
        statement.close();
        this.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("DROP TABLE t");
        this.commit();
        super.tearDown();
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(ResultSetJDBC30Test.class);
    }

    public void testNotImplementedMethods() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from t");
        ResultSetJDBC30Test.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        try {
            resultSet.getURL(8);
            ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
        }
        catch (SQLException sQLException) {
            ResultSetJDBC30Test.assertSQLState(NOT_IMPLEMENTED, sQLException);
        }
        try {
            resultSet.getURL("c");
            ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
        }
        catch (SQLException sQLException) {
            ResultSetJDBC30Test.assertSQLState(NOT_IMPLEMENTED, sQLException);
        }
        try {
            resultSet.updateRef(8, null);
            ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
        }
        catch (SQLException sQLException) {
            ResultSetJDBC30Test.assertSQLState(NOT_IMPLEMENTED, sQLException);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            ResultSetJDBC30Test.assertTrue((String)"FAIL - ResultSet.updateRef not present - correct for JSR169", (boolean)JDBC.vmSupportsJSR169());
        }
        try {
            resultSet.updateRef("c", null);
            ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
        }
        catch (SQLException sQLException) {
            ResultSetJDBC30Test.assertSQLState(NOT_IMPLEMENTED, sQLException);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            ResultSetJDBC30Test.assertTrue((String)"FAIL - ResultSet.updateRef not present - correct for JSR169", (boolean)JDBC.vmSupportsJSR169());
        }
        try {
            resultSet.updateBlob(8, (Blob)null);
            if (ResultSetJDBC30Test.usingEmbedded()) {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method is being invoked on a read only resultset.");
            } else {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
            }
        }
        catch (SQLException sQLException) {
            ResultSetJDBC30Test.assertSQLState(UPDATABLE_RESULTSET_API_DISALLOWED, sQLException);
        }
        try {
            resultSet.updateBlob("c", (Blob)null);
            if (ResultSetJDBC30Test.usingEmbedded()) {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method is being invoked on a read only resultset.");
            } else {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
            }
        }
        catch (SQLException sQLException) {
            ResultSetJDBC30Test.assertSQLState(UPDATABLE_RESULTSET_API_DISALLOWED, sQLException);
        }
        try {
            resultSet.updateClob(8, (Clob)null);
            if (ResultSetJDBC30Test.usingEmbedded()) {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method is being invoked on a read only resultset.");
            } else {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
            }
        }
        catch (SQLException sQLException) {
            ResultSetJDBC30Test.assertSQLState(UPDATABLE_RESULTSET_API_DISALLOWED, sQLException);
        }
        try {
            resultSet.updateClob("c", (Clob)null);
            if (ResultSetJDBC30Test.usingEmbedded()) {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method is being invoked on a read only resultset.");
            } else {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
            }
        }
        catch (SQLException sQLException) {
            ResultSetJDBC30Test.assertSQLState(UPDATABLE_RESULTSET_API_DISALLOWED, sQLException);
        }
        try {
            resultSet.updateArray(8, null);
            ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
        }
        catch (SQLException sQLException) {
            ResultSetJDBC30Test.assertSQLState(NOT_IMPLEMENTED, sQLException);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            ResultSetJDBC30Test.assertTrue((String)"FAIL - ResultSet.updateArray not present - correct for JSR169", (boolean)JDBC.vmSupportsJSR169());
        }
        try {
            resultSet.updateArray("c", null);
            ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
        }
        catch (SQLException sQLException) {
            ResultSetJDBC30Test.assertSQLState(NOT_IMPLEMENTED, sQLException);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            ResultSetJDBC30Test.assertTrue((String)"FAIL - ResultSet.updateArray not present - correct for JSR169", (boolean)JDBC.vmSupportsJSR169());
        }
        resultSet.close();
        statement.close();
        this.commit();
    }

    public void testCloseResultSetAutoCommit() throws Exception {
        this.getConnection().setAutoCommit(true);
        this.getConnection().setHoldability(1);
        Statement statement = this.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery("select * from t");
        resultSet.next();
        this.checkForCloseOnException(resultSet, true);
        resultSet.close();
        statement.close();
        this.getConnection().setHoldability(2);
        statement = this.createStatement(1004, 1007);
        resultSet = statement.executeQuery("select * from t");
        resultSet.next();
        this.checkForCloseOnException(resultSet, false);
        resultSet.close();
        statement.close();
        this.commit();
    }

    private void checkForCloseOnException(ResultSet resultSet, boolean bl) throws Exception {
        try {
            resultSet.updateBlob("c", (Blob)null);
            ResultSetJDBC30Test.fail((String)"FAIL - rs.updateBlob() on a read-only result setshould not have succeeded");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        resultSet.beforeFirst();
    }
}

