/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RawDBReaderTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO"};
    private static final String MEMORY_DB = "jdbc:derby:memory:rrt";
    private static final String RECOVERY_SCRIPT = "extinout/recovery.sql";
    private static final String BOOT_PASSWORD = "fooBarWibble";
    private static final String LIST_USER_SCHEMAS = "select schemaname from sys.sysschemas\nwhere schemaname not like 'SYS%'\nand schemaname != 'APP'\nand schemaname != 'NULLID'\nand schemaname != 'SQLJ'\norder by schemaname\n";
    private static final String LIST_USER_TABLES = "select tablename from sys.systables\nwhere tablename not like 'SYS%'\norder by tablename\n";
    private static final String[][] NO_ROWS = new String[0][];
    private static final String[][] EXPECTED_SCHEMAS = new String[][]{{"CONTROL11"}, {"RAW11_APP"}, {"RAW11_SCHEMA1"}, {"RAW11_SCHEMA2"}};
    private static final String[][] EXPECTED_TABLES = new String[][]{{"T1"}, {"T1"}, {"T2"}, {"T2"}};
    private File _dbDir;

    public RawDBReaderTest(String name) {
        super(name);
    }

    public static Test suite() {
        Test baseTest = TestConfiguration.embeddedSuite(RawDBReaderTest.class);
        Test wideOpenTest = SecurityManagerSetup.noSecurityManager(baseTest);
        Test authenticatedTest = DatabasePropertyTestSetup.builtinAuthenticationNoTeardown(wideOpenTest, LEGAL_USERS, "RRT");
        Test authorizedTest = TestConfiguration.sqlAuthorizationDecorator(authenticatedTest);
        Test encryptedTest = Decorator.encryptedDatabaseBpw(authorizedTest, "DES/CBC/NoPadding", BOOT_PASSWORD);
        SupportFilesSetup supportFilesTest = new SupportFilesSetup(encryptedTest);
        return supportFilesTest;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this._dbDir != null) {
            RawDBReaderTest.assertDirectoryDeleted(this._dbDir);
            this._dbDir = null;
        }
    }

    public void test_001_rawDBReader() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.populateCorruptDB(dboConnection);
        TestConfiguration tc = this.getTestConfiguration();
        tc.shutdownDatabase();
        String dbName = tc.getDefaultDatabaseName();
        File systemDir = new File("system");
        this._dbDir = new File(systemDir, dbName);
        String databaseName = this._dbDir.getPath();
        Connection newDBConn = DriverManager.getConnection("jdbc:derby:memory:rrt;create=true");
        this.vetUnloaded(newDBConn);
        String dboPassword = tc.getPassword(TEST_DBO);
        this.goodStatement(newDBConn, "call syscs_util.syscs_register_tool\n(\n  'rawDBReader',\n  true,\n  'extinout/recovery.sql',\n  'CONTROL11',\n  'RAW11_',\n  '" + databaseName + "',\n  'bootPassword=" + BOOT_PASSWORD + "',\n  '" + TEST_DBO + "',\n  '" + dboPassword + "'\n)\n");
        this.vetLoaded(newDBConn);
        this.runRecoveryScript(newDBConn);
        this.vetSiphoning(newDBConn);
        this.dropSiphonedData(newDBConn);
        this.goodStatement(newDBConn, "call syscs_util.syscs_register_tool\n(\n  'rawDBReader',\n  false,\n  'CONTROL11',\n  'RAW11_'\n)\n");
        this.vetUnloaded(newDBConn);
        this.shutdownInMemoryDB();
    }

    private void populateCorruptDB(Connection dboConnection) throws Exception {
        this.goodStatement(dboConnection, "create schema schema1");
        this.goodStatement(dboConnection, "create schema schema2");
        this.goodStatement(dboConnection, "create table schema1.t1( id int, tag varchar( 20 ) )");
        this.goodStatement(dboConnection, "insert into schema1.t1 values ( 1, 'schema1.t1:1' ), ( 2, 'schema1.t1:2' )");
        this.goodStatement(dboConnection, "create table schema1.t2( id int, tag varchar( 20 ) )");
        this.goodStatement(dboConnection, "insert into schema1.t2 values ( 1, 'schema1.t2:1' ), ( 2, 'schema1.t2:2' )");
        this.goodStatement(dboConnection, "create table schema2.t1( id int, tag varchar( 20 ) )");
        this.goodStatement(dboConnection, "insert into schema2.t1 values ( 1, 'schema2.t1:1' ), ( 2, 'schema2.t1:2' )");
        this.goodStatement(dboConnection, "create table schema2.t2( id int, tag varchar( 20 ) )");
        this.goodStatement(dboConnection, "insert into schema2.t2 values ( 1, 'schema2.t2:1' ), ( 2, 'schema2.t2:2' )");
    }

    private void shutdownInMemoryDB() throws Exception {
        try {
            DriverManager.getConnection("jdbc:derby:memory:rrt;shutdown=true");
        }
        catch (SQLException se) {
            RawDBReaderTest.assertSQLState("08006", se);
        }
        try {
            DriverManager.getConnection("jdbc:derby:memory:rrt;drop=true");
        }
        catch (SQLException se) {
            RawDBReaderTest.assertSQLState("08006", se);
        }
    }

    private void runRecoveryScript(Connection conn) throws Exception {
        try (BufferedReader reader = new BufferedReader(new FileReader(RECOVERY_SCRIPT));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("connect") || line.startsWith("--")) continue;
                line = line.substring(0, line.indexOf(59));
                this.goodStatement(conn, line);
            }
        }
    }

    private void vetSiphoning(Connection conn) throws Exception {
        this.assertResults(conn, "select * from schema1.t1 order by id", new String[][]{{"1", "schema1.t1:1"}, {"2", "schema1.t1:2"}}, false);
        this.assertResults(conn, "select * from schema1.t2 order by id", new String[][]{{"1", "schema1.t2:1"}, {"2", "schema1.t2:2"}}, false);
        this.assertResults(conn, "select * from schema2.t1 order by id", new String[][]{{"1", "schema2.t1:1"}, {"2", "schema2.t1:2"}}, false);
        this.assertResults(conn, "select * from schema2.t2 order by id", new String[][]{{"1", "schema2.t2:1"}, {"2", "schema2.t2:2"}}, false);
    }

    private void vetUnloaded(Connection conn) throws Exception {
        this.assertResults(conn, LIST_USER_SCHEMAS, NO_ROWS, false);
        this.assertResults(conn, LIST_USER_TABLES, NO_ROWS, false);
    }

    private void vetLoaded(Connection conn) throws Exception {
        this.assertResults(conn, LIST_USER_SCHEMAS, EXPECTED_SCHEMAS, false);
        this.assertResults(conn, LIST_USER_TABLES, EXPECTED_TABLES, false);
    }

    private void dropSiphonedData(Connection conn) throws Exception {
        this.goodStatement(conn, "drop table schema1.t1");
        this.goodStatement(conn, "drop table schema1.t2");
        this.goodStatement(conn, "drop table schema2.t1");
        this.goodStatement(conn, "drop table schema2.t2");
        this.goodStatement(conn, "drop schema schema1 restrict");
        this.goodStatement(conn, "drop schema schema2 restrict");
    }
}

