/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.AggregateAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.AggregateDefinition;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.CountAggregateDefinition;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SumAvgAggregateDefinition;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UserAggregateDefinition;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.sanity.SanityManager;

class AggregateNode
extends UnaryOperatorNode {
    private static BuiltinAggDescriptor[] BUILTIN_MODERN_AGGS = new BuiltinAggDescriptor[]{new BuiltinAggDescriptor("VAR_POP", "org.apache.derby.impl.sql.execute.VarPAggregator", TypeDescriptor.DOUBLE, TypeDescriptor.DOUBLE), new BuiltinAggDescriptor("VAR_SAMP", "org.apache.derby.impl.sql.execute.VarSAggregator", TypeDescriptor.DOUBLE, TypeDescriptor.DOUBLE), new BuiltinAggDescriptor("STDDEV_POP", "org.apache.derby.impl.sql.execute.StdDevPAggregator", TypeDescriptor.DOUBLE, TypeDescriptor.DOUBLE), new BuiltinAggDescriptor("STDDEV_SAMP", "org.apache.derby.impl.sql.execute.StdDevSAggregator", TypeDescriptor.DOUBLE, TypeDescriptor.DOUBLE)};
    private boolean distinct;
    private AggregateDefinition uad;
    private TableName userAggregateName;
    private StringBuffer aggregatorClassName;
    private String aggregateDefinitionClassName;
    private Class<?> aggregateDefinitionClass;
    private ClassInspector classInspector;
    private String aggregateName;
    private ResultColumn generatedRC;
    private ColumnReference generatedRef;

    AggregateNode(ValueNode operand, UserAggregateDefinition uadClass, TableName alias, boolean distinct, String aggregateName, ContextManager cm) throws StandardException {
        this(operand, alias, distinct, aggregateName, cm);
        this.setUserDefinedAggregate(uadClass);
    }

    AggregateNode(ValueNode operand, TableName uadClass, boolean distinct, String aggregateName, ContextManager cm) throws StandardException {
        super(operand, cm);
        this.aggregateName = aggregateName;
        this.userAggregateName = uadClass;
        this.distinct = distinct;
    }

    AggregateNode(ValueNode operand, Class<?> uadClass, boolean distinct, String aggregateName, ContextManager cm) throws StandardException {
        super(operand, cm);
        this.aggregateName = aggregateName;
        this.aggregateDefinitionClass = uadClass;
        if (!this.aggregateDefinitionClass.equals(MaxMinAggregateDefinition.class)) {
            this.distinct = distinct;
        }
        this.aggregateDefinitionClassName = this.aggregateDefinitionClass.getName();
    }

    private void setUserDefinedAggregate(UserAggregateDefinition userAgg) {
        this.uad = userAgg;
        this.aggregateDefinitionClass = this.uad.getClass();
        this.aggregateDefinitionClassName = this.aggregateDefinitionClass.getName();
    }

    ValueNode replaceAggregatesWithColumnReferences(ResultColumnList rcl, int tableNumber) throws StandardException {
        if (this.generatedRef == null) {
            CompilerContext cc = this.getCompilerContext();
            String generatedColName = "SQLCol" + cc.getNextColumnNumber();
            this.generatedRC = new ResultColumn(generatedColName, (ValueNode)this, this.getContextManager());
            this.generatedRC.markGenerated();
            this.generatedRef = new ColumnReference(this.generatedRC.getName(), null, this.getContextManager());
            this.generatedRef.setSource(this.generatedRC);
            this.generatedRef.setNestingLevel(0);
            this.generatedRef.setSourceLevel(0);
            if (tableNumber != -1) {
                this.generatedRef.setTableNumber(tableNumber);
            }
            rcl.addResultColumn(this.generatedRC);
            this.generatedRef.markGeneratedToReplaceAggregate();
        } else {
            rcl.addResultColumn(this.generatedRC);
        }
        return this.generatedRef;
    }

    AggregateDefinition getAggregateDefinition() {
        return this.uad;
    }

    ResultColumn getGeneratedRC() {
        SanityManager.ASSERT(this.generatedRC != null, "generatedRC is null.  replaceAggregateWithColumnReference() has not been called on this AggergateNode.  Make sure the node is under a ResultColumn as expected.");
        return this.generatedRC;
    }

    ColumnReference getGeneratedRef() {
        SanityManager.ASSERT(this.generatedRef != null, "generatedRef is null.  replaceAggregateWithColumnReference() has not been called on this AggergateNode.  Make sure the node is under a ResultColumn as expected.");
        return this.generatedRef;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        ValueNode castNode;
        DataDictionary dd = this.getDataDictionary();
        DataTypeDescriptor dts = null;
        ClassFactory cf = this.getClassFactory();
        this.classInspector = cf.getClassInspector();
        boolean noSchema = true;
        if (this.userAggregateName != null) {
            noSchema = this.userAggregateName.getSchemaName() == null;
            this.userAggregateName.bind();
        }
        if (this.userAggregateName != null && this.uad == null) {
            String schemaName = this.userAggregateName.getSchemaName();
            AliasDescriptor ad = AggregateNode.resolveAggregate(dd, this.getSchemaDescriptor(schemaName, true), this.userAggregateName.getTableName(), noSchema);
            if (ad == null) {
                throw StandardException.newException("42X94", AliasDescriptor.getAliasType('G'), this.userAggregateName.getTableName());
            }
            this.setUserDefinedAggregate(new UserAggregateDefinition(ad));
            this.aggregateName = ad.getJavaClassName();
        }
        this.instantiateAggDef();
        if (this.isUserDefinedAggregate()) {
            AliasDescriptor ad = ((UserAggregateDefinition)this.uad).getAliasDescriptor();
            boolean isModernBuiltinAggregate = "SYS".equals(ad.getSchemaName());
            if (this.distinct && isModernBuiltinAggregate) {
                throw StandardException.newException("42XAS", new Object[0]);
            }
            this.getCompilerContext().createDependency(ad);
            if (this.isPrivilegeCollectionRequired() && !isModernBuiltinAggregate) {
                this.getCompilerContext().addRequiredUsagePriv(ad);
            }
        }
        aggregates.add(this);
        CompilerContext cc = this.getCompilerContext();
        if (this.operand != null) {
            int previousReliability = this.orReliability(16384);
            this.bindOperand(fromList, subqueryList, aggregates);
            cc.setReliability(previousReliability);
            HasNodeVisitor visitor = new HasNodeVisitor(this.getClass(), ResultSetNode.class);
            this.operand.accept(visitor);
            if (visitor.hasNode()) {
                throw StandardException.newException("42Y33", this.getSQLName());
            }
            SelectNode.checkNoWindowFunctions(this.operand, this.aggregateName);
            dts = this.operand.getTypeServices();
            if (this.uad instanceof CountAggregateDefinition && !dts.isNullable()) {
                this.setOperator(this.aggregateName);
                this.setMethodName(this.aggregateName);
            }
            if (this.distinct && !this.operand.getTypeId().orderable(cf)) {
                throw StandardException.newException("X0X67.S", dts.getTypeId().getSQLTypeName());
            }
            if (this.operand instanceof UntypedNullConstantNode) {
                throw StandardException.newException("42Y83", this.getSQLName());
            }
        }
        this.aggregatorClassName = new StringBuffer();
        DataTypeDescriptor resultType = this.uad.getAggregator(dts, this.aggregatorClassName);
        if (resultType == null) {
            throw StandardException.newException("42Y22", this.getSQLName(), this.operand.getTypeId().getSQLTypeName());
        }
        if (this.isUserDefinedAggregate() && (castNode = ((UserAggregateDefinition)this.uad).castInputValue(this.operand, this.getContextManager())) != null) {
            this.operand = castNode.bindExpression(fromList, subqueryList, aggregates);
        }
        this.checkAggregatorClassName(this.aggregatorClassName.toString());
        this.setType(resultType);
        return this;
    }

    static AliasDescriptor resolveAggregate(DataDictionary dd, SchemaDescriptor sd, String rawName, boolean noSchema) throws StandardException {
        AliasDescriptor ad = AggregateNode.resolveBuiltinAggregate(dd, rawName, noSchema);
        if (ad != null) {
            return ad;
        }
        if (sd.getUUID() == null) {
            return null;
        }
        List<AliasDescriptor> list = dd.getRoutineList(sd.getUUID().toString(), rawName, 'G');
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    private static AliasDescriptor resolveBuiltinAggregate(DataDictionary dd, String rawName, boolean noSchema) throws StandardException {
        if (!noSchema) {
            return null;
        }
        BuiltinAggDescriptor bad = null;
        for (BuiltinAggDescriptor aggDescriptor : BUILTIN_MODERN_AGGS) {
            if (!aggDescriptor.aggName.equals(rawName)) continue;
            bad = aggDescriptor;
            break;
        }
        if (bad == null) {
            return null;
        }
        AggregateAliasInfo aliasInfo = new AggregateAliasInfo(bad.argType, bad.returnType);
        return new AliasDescriptor(dd, null, rawName, dd.getSystemSchemaDescriptor().getUUID(), bad.aggClassName, 'G', 'G', false, aliasInfo, null);
    }

    private void checkAggregatorClassName(String className) throws StandardException {
        this.verifyClassExist(className);
        if (!this.classInspector.assignableTo(className, "org.apache.derby.iapi.sql.execute.ExecAggregator")) {
            throw StandardException.newException("42Y32", className, this.getSQLName(), this.operand.getTypeId().getSQLTypeName());
        }
    }

    private void instantiateAggDef() throws StandardException {
        if (this.uad == null) {
            Class<?> theClass = this.aggregateDefinitionClass;
            if (theClass == null) {
                String aggClassName = this.aggregateDefinitionClassName;
                this.verifyClassExist(aggClassName);
                try {
                    theClass = this.classInspector.getClass(aggClassName);
                }
                catch (Throwable t) {
                    throw StandardException.unexpectedUserException(t);
                }
            }
            Object instance = null;
            try {
                instance = theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
            if (!(instance instanceof AggregateDefinition)) {
                throw StandardException.newException("42Y00", this.aggregateDefinitionClassName);
            }
            if (instance instanceof MaxMinAggregateDefinition) {
                MaxMinAggregateDefinition temp = instance;
                if (this.aggregateName.equals("MAX")) {
                    temp.setMaxOrMin(true);
                } else {
                    temp.setMaxOrMin(false);
                }
            }
            if (instance instanceof SumAvgAggregateDefinition) {
                SumAvgAggregateDefinition temp1 = instance;
                if (this.aggregateName.equals("SUM")) {
                    temp1.setSumOrAvg(true);
                } else {
                    temp1.setSumOrAvg(false);
                }
            }
            this.uad = instance;
        }
        this.setOperator(this.aggregateName);
        this.setMethodName(this.aggregateDefinitionClassName);
    }

    boolean isDistinct() {
        return this.distinct;
    }

    String getAggregatorClassName() {
        return this.aggregatorClassName.toString();
    }

    String getAggregateName() {
        return this.aggregateName;
    }

    ResultColumn getNewAggregatorResultColumn(DataDictionary dd) throws StandardException {
        String className = this.aggregatorClassName.toString();
        DataTypeDescriptor compType = DataTypeDescriptor.getSQLDataTypeDescriptor(className);
        ConstantNode nullNode = this.getNullNode(compType);
        nullNode.bindExpression(null, null, null);
        return new ResultColumn(this.aggregateName, (ValueNode)nullNode, this.getContextManager());
    }

    ResultColumn getNewExpressionResultColumn(DataDictionary dd) throws StandardException {
        ValueNode node = this.operand == null ? this.getNewNullResultExpression() : this.operand;
        return new ResultColumn("##aggregate expression", node, this.getContextManager());
    }

    ValueNode getNewNullResultExpression() throws StandardException {
        return this.getNullNode(this.getTypeServices());
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.THROWASSERT("generateExpression() should never be called on an AggregateNode.  replaceAggregatesWithColumnReferences should have been called prior to generateExpression");
    }

    @Override
    public String toString() {
        return "aggregateName: " + this.getSQLName() + "\ndistinct: " + this.distinct + "\n" + super.toString();
    }

    boolean isConstant() {
        return false;
    }

    @Override
    boolean constantExpression(PredicateList where) {
        return false;
    }

    public String getSQLName() {
        if (this.isUserDefinedAggregate()) {
            return ((UserAggregateDefinition)this.uad).getAliasDescriptor().getQualifiedName();
        }
        return this.aggregateName;
    }

    private boolean isUserDefinedAggregate() {
        return this.uad instanceof UserAggregateDefinition;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.userAggregateName != null) {
            this.userAggregateName = (TableName)this.userAggregateName.accept(v);
        }
    }

    static final class BuiltinAggDescriptor {
        public final String aggName;
        public final String aggClassName;
        public final TypeDescriptor argType;
        public final TypeDescriptor returnType;

        public BuiltinAggDescriptor(String aggName, String aggClassName, TypeDescriptor argType, TypeDescriptor returnType) {
            this.aggName = aggName;
            this.aggClassName = aggClassName;
            this.argType = argType;
            this.returnType = returnType;
        }
    }
}

