/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.frequencies;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.frequencies.DistTest;
import org.apache.datasketches.frequencies.ErrorType;
import org.apache.datasketches.frequencies.LongsSketch;
import org.apache.datasketches.frequencies.PreambleUtil;
import org.apache.datasketches.frequencies.ReversePurgeLongHashMap;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LongsSketchTest {
    @Test
    public void hashMapSerialTest() {
        ReversePurgeLongHashMap map = new ReversePurgeLongHashMap(8);
        map.adjustOrPutValue(10L, 15L);
        map.adjustOrPutValue(10L, 5L);
        map.adjustOrPutValue(1L, 1L);
        map.adjustOrPutValue(2L, 3L);
        String string = map.serializeToString();
        ReversePurgeLongHashMap new_map = ReversePurgeLongHashMap.getInstance((String)string);
        String new_string = new_map.serializeToString();
        Assert.assertTrue((boolean)string.equals(new_string));
    }

    @Test
    public void frequentItemsStringSerialTest() {
        LongsSketch sketch = new LongsSketch(8);
        LongsSketch sketch2 = new LongsSketch(128);
        sketch.update(10L, 100L);
        sketch.update(10L, 100L);
        sketch.update(15L, 3443L);
        sketch.update(1000001L, 1010230L);
        sketch.update(1000002L, 1010230L);
        String string0 = sketch.serializeToString();
        LongsSketch new_sketch0 = LongsSketch.getInstance((String)string0);
        String new_string0 = new_sketch0.serializeToString();
        Assert.assertTrue((boolean)string0.equals(new_string0));
        Assert.assertTrue((new_sketch0.getMaximumMapCapacity() == sketch.getMaximumMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch0.getCurrentMapCapacity() == sketch.getCurrentMapCapacity() ? 1 : 0) != 0);
        sketch2.update(190L, 12902390L);
        sketch2.update(191L, 12902390L);
        sketch2.update(192L, 12902390L);
        sketch2.update(193L, 12902390L);
        sketch2.update(194L, 12902390L);
        sketch2.update(195L, 12902390L);
        sketch2.update(196L, 12902390L);
        sketch2.update(197L, 12902390L);
        sketch2.update(198L, 12902390L);
        sketch2.update(199L, 12902390L);
        sketch2.update(200L, 12902390L);
        sketch2.update(201L, 12902390L);
        sketch2.update(202L, 12902390L);
        sketch2.update(203L, 12902390L);
        sketch2.update(204L, 12902390L);
        sketch2.update(205L, 12902390L);
        sketch2.update(206L, 12902390L);
        sketch2.update(207L, 12902390L);
        sketch2.update(208L, 12902390L);
        String string2 = sketch2.serializeToString();
        LongsSketch new_sketch2 = LongsSketch.getInstance((String)string2);
        String new_string2 = new_sketch2.serializeToString();
        Assert.assertTrue((boolean)string2.equals(new_string2));
        Assert.assertTrue((new_sketch2.getMaximumMapCapacity() == sketch2.getMaximumMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch2.getCurrentMapCapacity() == sketch2.getCurrentMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch2.getStreamLength() == sketch2.getStreamLength() ? 1 : 0) != 0);
        LongsSketch merged_sketch = sketch.merge(sketch2);
        String string = merged_sketch.serializeToString();
        LongsSketch new_sketch = LongsSketch.getInstance((String)string);
        String new_string = new_sketch.serializeToString();
        Assert.assertTrue((boolean)string.equals(new_string));
        Assert.assertTrue((new_sketch.getMaximumMapCapacity() == merged_sketch.getMaximumMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch.getCurrentMapCapacity() == merged_sketch.getCurrentMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch.getStreamLength() == merged_sketch.getStreamLength() ? 1 : 0) != 0);
    }

    @Test
    public void frequentItemsByteSerialTest() {
        LongsSketch sketch = new LongsSketch(16);
        byte[] bytearray0 = sketch.toByteArray();
        WritableMemory mem0 = WritableMemory.writableWrap((byte[])bytearray0);
        LongsSketch new_sketch0 = LongsSketch.getInstance((Memory)mem0);
        String str0 = LongsSketch.toString((Memory)mem0);
        LongsSketchTest.println(str0);
        String string0 = sketch.serializeToString();
        String new_string0 = new_sketch0.serializeToString();
        Assert.assertTrue((boolean)string0.equals(new_string0));
        LongsSketch sketch2 = new LongsSketch(128);
        sketch.update(10L, 100L);
        sketch.update(10L, 100L);
        sketch.update(15L, 3443L);
        sketch.update(1000001L, 1010230L);
        sketch.update(1000002L, 1010230L);
        byte[] bytearray1 = sketch.toByteArray();
        Memory mem1 = Memory.wrap((byte[])bytearray1);
        LongsSketch new_sketch1 = LongsSketch.getInstance((Memory)mem1);
        String str1 = LongsSketch.toString((byte[])bytearray1);
        LongsSketchTest.println(str1);
        String string1 = sketch.serializeToString();
        String new_string1 = new_sketch1.serializeToString();
        Assert.assertTrue((boolean)string1.equals(new_string1));
        Assert.assertTrue((new_sketch1.getMaximumMapCapacity() == sketch.getMaximumMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch1.getCurrentMapCapacity() == sketch.getCurrentMapCapacity() ? 1 : 0) != 0);
        sketch2.update(190L, 12902390L);
        sketch2.update(191L, 12902390L);
        sketch2.update(192L, 12902390L);
        sketch2.update(193L, 12902390L);
        sketch2.update(194L, 12902390L);
        sketch2.update(195L, 12902390L);
        sketch2.update(196L, 12902390L);
        sketch2.update(197L, 12902390L);
        sketch2.update(198L, 12902390L);
        sketch2.update(199L, 12902390L);
        sketch2.update(200L, 12902390L);
        sketch2.update(201L, 12902390L);
        sketch2.update(202L, 12902390L);
        sketch2.update(203L, 12902390L);
        sketch2.update(204L, 12902390L);
        sketch2.update(205L, 12902390L);
        sketch2.update(206L, 12902390L);
        sketch2.update(207L, 12902390L);
        sketch2.update(208L, 12902390L);
        byte[] bytearray2 = sketch2.toByteArray();
        Memory mem2 = Memory.wrap((byte[])bytearray2);
        LongsSketch new_sketch2 = LongsSketch.getInstance((Memory)mem2);
        String string2 = sketch2.serializeToString();
        String new_string2 = new_sketch2.serializeToString();
        Assert.assertTrue((boolean)string2.equals(new_string2));
        Assert.assertTrue((new_sketch2.getMaximumMapCapacity() == sketch2.getMaximumMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch2.getCurrentMapCapacity() == sketch2.getCurrentMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch2.getStreamLength() == sketch2.getStreamLength() ? 1 : 0) != 0);
        LongsSketch merged_sketch = sketch.merge(sketch2);
        byte[] bytearray = sketch.toByteArray();
        Memory mem = Memory.wrap((byte[])bytearray);
        LongsSketch new_sketch = LongsSketch.getInstance((Memory)mem);
        String string = sketch.serializeToString();
        String new_string = new_sketch.serializeToString();
        Assert.assertTrue((boolean)string.equals(new_string));
        Assert.assertTrue((new_sketch.getMaximumMapCapacity() == merged_sketch.getMaximumMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch.getCurrentMapCapacity() == merged_sketch.getCurrentMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch.getStreamLength() == merged_sketch.getStreamLength() ? 1 : 0) != 0);
    }

    @Test
    public void frequentItemsByteResetAndEmptySerialTest() {
        LongsSketch sketch = new LongsSketch(16);
        sketch.update(10L, 100L);
        sketch.update(10L, 100L);
        sketch.update(15L, 3443L);
        sketch.update(1000001L, 1010230L);
        sketch.update(1000002L, 1010230L);
        sketch.reset();
        byte[] bytearray0 = sketch.toByteArray();
        Memory mem0 = Memory.wrap((byte[])bytearray0);
        LongsSketch new_sketch0 = LongsSketch.getInstance((Memory)mem0);
        String string0 = sketch.serializeToString();
        String new_string0 = new_sketch0.serializeToString();
        Assert.assertTrue((boolean)string0.equals(new_string0));
        Assert.assertTrue((new_sketch0.getMaximumMapCapacity() == sketch.getMaximumMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch0.getCurrentMapCapacity() == sketch.getCurrentMapCapacity() ? 1 : 0) != 0);
    }

    @Test
    public void checkFreqLongsMemSerDe() {
        int minSize = 8;
        LongsSketch sk1 = new LongsSketch(minSize);
        sk1.update(10L, 100L);
        sk1.update(10L, 100L);
        sk1.update(15L, 3443L);
        LongsSketchTest.println(sk1.toString());
        sk1.update(1000001L, 1010230L);
        LongsSketchTest.println(sk1.toString());
        sk1.update(1000002L, 1010230L);
        LongsSketchTest.println(sk1.toString());
        byte[] bytearray0 = sk1.toByteArray();
        Memory mem0 = Memory.wrap((byte[])bytearray0);
        LongsSketch sk2 = LongsSketch.getInstance((Memory)mem0);
        LongsSketchTest.checkEquality(sk1, sk2);
    }

    @Test
    public void checkFreqLongsStringSerDe() {
        int minSize = 8;
        LongsSketch sk1 = new LongsSketch(minSize);
        sk1.update(10L, 100L);
        sk1.update(10L, 100L);
        sk1.update(15L, 3443L);
        sk1.update(1000001L, 1010230L);
        sk1.update(1000002L, 1010230L);
        String string1 = sk1.serializeToString();
        LongsSketch sk2 = LongsSketch.getInstance((String)string1);
        LongsSketchTest.checkEquality(sk1, sk2);
    }

    private static void checkEquality(LongsSketch sk1, LongsSketch sk2) {
        String s2;
        String s1;
        int i;
        Assert.assertEquals((int)sk1.getNumActiveItems(), (int)sk2.getNumActiveItems());
        Assert.assertEquals((int)sk1.getCurrentMapCapacity(), (int)sk2.getCurrentMapCapacity());
        Assert.assertEquals((long)sk1.getMaximumError(), (long)sk2.getMaximumError());
        Assert.assertEquals((int)sk1.getMaximumMapCapacity(), (int)sk2.getMaximumMapCapacity());
        Assert.assertEquals((int)sk1.getStorageBytes(), (int)sk2.getStorageBytes());
        Assert.assertEquals((long)sk1.getStreamLength(), (long)sk2.getStreamLength());
        Assert.assertEquals((boolean)sk1.isEmpty(), (boolean)sk2.isEmpty());
        ErrorType NFN = ErrorType.NO_FALSE_NEGATIVES;
        ErrorType NFP = ErrorType.NO_FALSE_POSITIVES;
        LongsSketch.Row[] rowArr1 = sk1.getFrequentItems(NFN);
        LongsSketch.Row[] rowArr2 = sk2.getFrequentItems(NFN);
        Assert.assertEquals((int)sk1.getFrequentItems(NFN).length, (int)sk2.getFrequentItems(NFN).length);
        for (i = 0; i < rowArr1.length; ++i) {
            s1 = rowArr1[i].toString();
            s2 = rowArr2[i].toString();
            Assert.assertEquals((String)s1, (String)s2);
        }
        rowArr1 = sk1.getFrequentItems(NFP);
        rowArr2 = sk2.getFrequentItems(NFP);
        Assert.assertEquals((int)sk1.getFrequentItems(NFP).length, (int)sk2.getFrequentItems(NFP).length);
        for (i = 0; i < rowArr1.length; ++i) {
            s1 = rowArr1[i].toString();
            s2 = rowArr2[i].toString();
            Assert.assertEquals((String)s1, (String)s2);
        }
    }

    @Test
    public void checkFreqLongsMemDeSerExceptions() {
        int minSize = 8;
        LongsSketch sk1 = new LongsSketch(minSize);
        sk1.update(1L);
        byte[] bytearray0 = sk1.toByteArray();
        WritableMemory mem = WritableMemory.writableWrap((byte[])bytearray0);
        long pre0 = mem.getLong(0L);
        LongsSketchTest.tryBadMem(mem, 0, 2);
        mem.putLong(0L, pre0);
        LongsSketchTest.tryBadMem(mem, 1, 2);
        mem.putLong(0L, pre0);
        LongsSketchTest.tryBadMem(mem, 2, 2);
        mem.putLong(0L, pre0);
        LongsSketchTest.tryBadMem(mem, 5, 4);
        mem.putLong(0L, pre0);
    }

    private static void tryBadMem(WritableMemory mem, int byteOffset, int byteValue) {
        try {
            mem.putByte((long)byteOffset, (byte)byteValue);
            LongsSketch.getInstance((Memory)mem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkFreqLongsStringDeSerExceptions() {
        LongsSketchTest.tryBadString("2,10,2,4,0,0,0,4,");
        LongsSketchTest.tryBadString("1,10,2,0,0,0,0,4,");
        LongsSketchTest.tryBadString("1,10,2,4,0,0,0,4,0,");
    }

    private static void tryBadString(String badString) {
        try {
            LongsSketch.getInstance((String)badString);
            Assert.fail((String)"Should have thrown SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkFreqLongs() {
        int numSketches = 1;
        int n = 2222;
        double error_tolerance = 0.01;
        LongsSketch[] sketches = new LongsSketch[numSketches];
        for (int h = 0; h < numSketches; ++h) {
            sketches[h] = LongsSketchTest.newFrequencySketch(error_tolerance);
        }
        double prob = 0.001;
        for (int i = 0; i < n; ++i) {
            long item = DistTest.randomGeometricDist(prob) + 1L;
            for (int h = 0; h < numSketches; ++h) {
                sketches[h].update(item);
            }
        }
        for (int h = 0; h < numSketches; ++h) {
            int i;
            long threshold = sketches[h].getMaximumError();
            LongsSketch.Row[] rows = sketches[h].getFrequentItems(ErrorType.NO_FALSE_NEGATIVES);
            for (i = 0; i < rows.length; ++i) {
                Assert.assertTrue((rows[i].getUpperBound() > threshold ? 1 : 0) != 0);
            }
            rows = sketches[h].getFrequentItems(ErrorType.NO_FALSE_POSITIVES);
            for (i = 0; i < rows.length; ++i) {
                Assert.assertTrue((rows[i].getLowerBound() > threshold ? 1 : 0) != 0);
            }
            rows = sketches[h].getFrequentItems(Long.MAX_VALUE, ErrorType.NO_FALSE_POSITIVES);
            Assert.assertEquals((int)rows.length, (int)0);
        }
    }

    @Test
    public void updateOneTime() {
        int size = 100;
        double error_tolerance = 1.0 / (double)size;
        int numSketches = 1;
        for (int h = 0; h < numSketches; ++h) {
            LongsSketch sketch = LongsSketchTest.newFrequencySketch(error_tolerance);
            Assert.assertEquals((long)sketch.getUpperBound(13L), (long)0L);
            Assert.assertEquals((long)sketch.getLowerBound(13L), (long)0L);
            Assert.assertEquals((long)sketch.getMaximumError(), (long)0L);
            Assert.assertEquals((long)sketch.getEstimate(13L), (long)0L);
            sketch.update(13L);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetInstanceMemory() {
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[4]);
        LongsSketch.getInstance((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetInstanceString() {
        String s = "";
        LongsSketch.getInstance((String)s);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkUpdateNegative() {
        int minSize = 8;
        LongsSketch fls = new LongsSketch(minSize);
        fls.update(1L, 0L);
        fls.update(1L, -1L);
    }

    @Test
    public void checkGetFrequentItems1() {
        int minSize = 8;
        LongsSketch fis = new LongsSketch(minSize);
        fis.update(1L);
        LongsSketch.Row[] rowArr = fis.getFrequentItems(ErrorType.NO_FALSE_POSITIVES);
        LongsSketch.Row row = rowArr[0];
        Assert.assertTrue((row.hashCode() != 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)row.equals((Object)row));
        Assert.assertFalse((boolean)row.equals((Object)fis));
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((long)row.est, (long)1L);
        Assert.assertEquals((long)row.item, (long)1L);
        Assert.assertEquals((long)row.lb, (long)1L);
        Assert.assertEquals((long)row.ub, (long)1L);
        LongsSketch.Row newRow = new LongsSketch.Row(row.item, row.est + 1L, row.ub, row.lb);
        Assert.assertFalse((boolean)row.equals((Object)newRow));
        newRow = new LongsSketch.Row(row.item, row.est, row.ub, row.lb);
        Assert.assertTrue((boolean)row.equals((Object)newRow));
    }

    @Test
    public void checkGetStorageBytes() {
        int minSize = 8;
        LongsSketch fls = new LongsSketch(minSize);
        Assert.assertEquals((int)fls.toByteArray().length, (int)fls.getStorageBytes());
        fls.update(1L);
        Assert.assertEquals((int)fls.toByteArray().length, (int)fls.getStorageBytes());
    }

    @Test
    public void checkDeSerFromStringArray() {
        int minSize = 8;
        LongsSketch fls = new LongsSketch(minSize);
        String ser = fls.serializeToString();
        LongsSketchTest.println(ser);
        fls.update(1L);
        ser = fls.serializeToString();
        LongsSketchTest.println(ser);
    }

    @Test
    public void checkMerge() {
        int minSize = 8;
        LongsSketch fls1 = new LongsSketch(minSize);
        LongsSketch fls2 = null;
        LongsSketch fle = fls1.merge(fls2);
        Assert.assertTrue((boolean)fle.isEmpty());
        fls2 = new LongsSketch(minSize);
        fle = fls1.merge(fls2);
        Assert.assertTrue((boolean)fle.isEmpty());
    }

    @Test
    public void checkSortItems() {
        int numSketches = 1;
        int n = 2222;
        double error_tolerance = 0.01;
        int sketchSize = Util.ceilingPowerOf2((int)((int)(1.0 / (error_tolerance * ReversePurgeLongHashMap.getLoadFactor()))));
        LongsSketch[] sketches = new LongsSketch[numSketches];
        for (int h = 0; h < numSketches; ++h) {
            sketches[h] = new LongsSketch(sketchSize);
        }
        double prob = 0.001;
        for (int i = 0; i < n; ++i) {
            long item = DistTest.randomGeometricDist(prob) + 1L;
            for (int h = 0; h < numSketches; ++h) {
                sketches[h].update(item);
            }
        }
        for (int h = 0; h < numSketches; ++h) {
            long threshold = sketches[h].getMaximumError();
            LongsSketch.Row[] rows = sketches[h].getFrequentItems(ErrorType.NO_FALSE_NEGATIVES);
            for (int i = 0; i < rows.length; ++i) {
                Assert.assertTrue((rows[i].ub > threshold ? 1 : 0) != 0);
            }
            LongsSketch.Row first = rows[0];
            long anItem = first.getItem();
            long anEst = first.getEstimate();
            long aLB = first.getLowerBound();
            String s = first.toString();
            LongsSketchTest.println(s);
            Assert.assertTrue((anEst >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((aLB >= 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)anItem, (long)anItem);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetAndCheckPreLongs() {
        byte[] byteArr = new byte[8];
        byteArr[0] = 2;
        PreambleUtil.checkPreambleSize((Memory)Memory.wrap((byte[])byteArr));
    }

    @Test
    public void checkToString1() {
        int size = 8;
        this.printSketch(size, new long[]{1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 3L, 4L, 5L});
        this.printSketch(size, new long[]{5L, 4L, 3L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L});
    }

    @Test
    public void checkStringDeserEmptyNotCorrupt() {
        int size = 8;
        int thresh = size * 3 / 4;
        String fmt = "%6d%10s%s";
        LongsSketch fls = new LongsSketch(size);
        LongsSketchTest.println("Sketch Size: " + size);
        String s = null;
        for (int i = 0; i <= thresh; ++i) {
            fls.update((long)(i + 1), 1L);
            s = fls.serializeToString();
            LongsSketchTest.println(String.format("SER   " + fmt, i + 1, fls.isEmpty() + " : ", s));
            LongsSketch fls2 = LongsSketch.getInstance((String)s);
            LongsSketchTest.println(String.format("DESER " + fmt, i + 1, fls2.isEmpty() + " : ", s));
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkStringDeserEmptyCorrupt() {
        String s = "1,10,3,0,7,1,0,8,";
        LongsSketch.getInstance((String)s);
    }

    @Test
    public void checkGetEpsilon() {
        Assert.assertEquals((double)LongsSketch.getEpsilon((int)1024), (double)0.00341796875, (double)0.0);
        try {
            LongsSketch.getEpsilon((int)1000);
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkGetAprioriError() {
        double eps = 0.00341796875;
        Assert.assertEquals((double)LongsSketch.getAprioriError((int)1024, (long)10000L), (double)(eps * 10000.0));
    }

    @Test
    public void printlnTest() {
        LongsSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    public void printSketch(int size, long[] freqArr) {
        LongsSketch fls = new LongsSketch(size);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < freqArr.length; ++i) {
            fls.update((long)(i + 1), freqArr[i]);
        }
        sb.append("Sketch Size: " + size).append(Util.LS);
        String s = fls.toString();
        sb.append(s);
        LongsSketchTest.println(sb.toString());
        LongsSketchTest.printRows(fls, ErrorType.NO_FALSE_NEGATIVES);
        LongsSketchTest.println("");
        LongsSketchTest.printRows(fls, ErrorType.NO_FALSE_POSITIVES);
        LongsSketchTest.println("");
    }

    private static void printRows(LongsSketch fls, ErrorType eType) {
        LongsSketch.Row[] rows = fls.getFrequentItems(eType);
        String s1 = eType.toString();
        LongsSketchTest.println(s1);
        String hdr = LongsSketch.Row.getRowHeader();
        LongsSketchTest.println(hdr);
        for (int i = 0; i < rows.length; ++i) {
            LongsSketch.Row row = rows[i];
            String s2 = row.toString();
            LongsSketchTest.println(s2);
        }
        if (rows.length > 0) {
            Object nullRow = null;
            Assert.assertFalse((boolean)rows[0].equals(nullRow));
        }
    }

    static void println(String s) {
    }

    private static LongsSketch newFrequencySketch(double eps) {
        double loadFactor = ReversePurgeLongHashMap.getLoadFactor();
        int maxMapSize = Util.ceilingPowerOf2((int)((int)(1.0 / (eps * loadFactor))));
        return new LongsSketch(maxMapSize);
    }
}

