/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.infoset;

import org.apache.daffodil.api.DFDLPrimType;
import org.apache.daffodil.api.DaffodilParseXMLReader;
import org.apache.daffodil.api.infoset.InfosetArray;
import org.apache.daffodil.api.infoset.InfosetComplexElement;
import org.apache.daffodil.api.infoset.InfosetElement;
import org.apache.daffodil.api.infoset.InfosetOutputter;
import org.apache.daffodil.api.infoset.InfosetSimpleElement;
import org.apache.daffodil.lib.xml.NS$;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.infoset.DIElement;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.xml.NamespaceBinding;
import scala.xml.TopScope$;

public class SAXInfosetOutputter
extends InfosetOutputter {
    private final DaffodilParseXMLReader xmlReader;
    private final boolean namespacesFeature;
    private final boolean namespacePrefixesFeature;

    public SAXInfosetOutputter(DaffodilParseXMLReader xmlReader, boolean namespacesFeature, boolean namespacePrefixesFeature) {
        this.xmlReader = xmlReader;
        this.namespacesFeature = namespacesFeature;
        this.namespacePrefixesFeature = namespacePrefixesFeature;
    }

    public boolean namespacesFeature() {
        return this.namespacesFeature;
    }

    public boolean namespacePrefixesFeature() {
        return this.namespacePrefixesFeature;
    }

    @Override
    public void reset() {
    }

    @Override
    public void startDocument() {
        ContentHandler contentHandler = this.xmlReader.getContentHandler();
        if (contentHandler != null) {
            contentHandler.startDocument();
            return;
        }
    }

    @Override
    public void endDocument() {
        ContentHandler contentHandler = this.xmlReader.getContentHandler();
        if (contentHandler != null) {
            contentHandler.endDocument();
            return;
        }
    }

    @Override
    public void startSimple(InfosetSimpleElement simple) {
        ContentHandler contentHandler = this.xmlReader.getContentHandler();
        if (contentHandler != null) {
            this.doStartElement(simple, contentHandler);
            if (!simple.isNilled()) {
                DFDLPrimType dFDLPrimType = simple.metadata().dfdlType();
                DFDLPrimType dFDLPrimType2 = DFDLPrimType.String;
                String text = !(dFDLPrimType != null ? !((Object)((Object)dFDLPrimType)).equals((Object)dFDLPrimType2) : dFDLPrimType2 != null) ? XMLUtils$.MODULE$.remapXMLIllegalCharactersToPUA(simple.getText()) : simple.getText();
                char[] arr = text.toCharArray();
                contentHandler.characters(arr, 0, arr.length);
                return;
            }
            return;
        }
    }

    @Override
    public void endSimple(InfosetSimpleElement simple) {
        ContentHandler contentHandler = this.xmlReader.getContentHandler();
        if (contentHandler != null) {
            this.doEndElement(simple, contentHandler);
            return;
        }
    }

    @Override
    public void startComplex(InfosetComplexElement complex) {
        ContentHandler contentHandler = this.xmlReader.getContentHandler();
        if (contentHandler != null) {
            this.doStartElement(complex, contentHandler);
            return;
        }
    }

    @Override
    public void endComplex(InfosetComplexElement complex) {
        ContentHandler contentHandler = this.xmlReader.getContentHandler();
        if (contentHandler != null) {
            this.doEndElement(complex, contentHandler);
            return;
        }
    }

    @Override
    public void startArray(InfosetArray ar) {
    }

    @Override
    public void endArray(InfosetArray ar) {
    }

    private void doStartPrefixMapping(InfosetElement elem, ContentHandler contentHandler) {
        NamespaceBinding nsbStart;
        NamespaceBinding namespaceBinding;
        block4: {
            Tuple2<NamespaceBinding, NamespaceBinding> tuple2;
            block3: {
                tuple2 = this.getNsbStartAndEnd(elem);
                if (tuple2 == null) break block3;
                NamespaceBinding namespaceBinding2 = (NamespaceBinding)tuple2._1();
                namespaceBinding = (NamespaceBinding)tuple2._2();
                if (namespaceBinding2 == null) break block3;
                nsbStart = namespaceBinding2;
                if (namespaceBinding != null) break block4;
            }
            throw new MatchError(tuple2);
        }
        NamespaceBinding nsbEnd = namespaceBinding;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)nsbStart, (Object)nsbEnd);
        NamespaceBinding nsbStart2 = (NamespaceBinding)tuple2._1();
        NamespaceBinding nsbEnd2 = (NamespaceBinding)tuple2._2();
        for (NamespaceBinding n = nsbStart2; n != nsbEnd2 && n != null && n != TopScope$.MODULE$; n = n.parent()) {
            String prefix = n.prefix() == null ? "" : n.prefix();
            String uri = n.uri() == null ? "" : n.uri();
            contentHandler.startPrefixMapping(prefix, uri);
        }
    }

    private void doEndPrefixMapping(InfosetElement elem, ContentHandler contentHandler) {
        NamespaceBinding nsbStart;
        NamespaceBinding namespaceBinding;
        block4: {
            Tuple2<NamespaceBinding, NamespaceBinding> tuple2;
            block3: {
                tuple2 = this.getNsbStartAndEnd(elem);
                if (tuple2 == null) break block3;
                NamespaceBinding namespaceBinding2 = (NamespaceBinding)tuple2._1();
                namespaceBinding = (NamespaceBinding)tuple2._2();
                if (namespaceBinding2 == null) break block3;
                nsbStart = namespaceBinding2;
                if (namespaceBinding != null) break block4;
            }
            throw new MatchError(tuple2);
        }
        NamespaceBinding nsbEnd = namespaceBinding;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)nsbStart, (Object)nsbEnd);
        NamespaceBinding nsbStart2 = (NamespaceBinding)tuple2._1();
        NamespaceBinding nsbEnd2 = (NamespaceBinding)tuple2._2();
        for (NamespaceBinding n = nsbStart2; n != nsbEnd2 && n != null && n != TopScope$.MODULE$; n = n.parent()) {
            String prefix = n.prefix() == null ? "" : n.prefix();
            contentHandler.endPrefixMapping(prefix);
        }
    }

    private AttributesImpl doAttributesPrefixMapping(InfosetElement elem, AttributesImpl attrs) {
        NamespaceBinding nsbStart;
        NamespaceBinding namespaceBinding;
        block4: {
            Tuple2<NamespaceBinding, NamespaceBinding> tuple2;
            block3: {
                tuple2 = this.getNsbStartAndEnd(elem);
                if (tuple2 == null) break block3;
                NamespaceBinding namespaceBinding2 = (NamespaceBinding)tuple2._1();
                namespaceBinding = (NamespaceBinding)tuple2._2();
                if (namespaceBinding2 == null) break block3;
                nsbStart = namespaceBinding2;
                if (namespaceBinding != null) break block4;
            }
            throw new MatchError(tuple2);
        }
        NamespaceBinding nsbEnd = namespaceBinding;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)nsbStart, (Object)nsbEnd);
        NamespaceBinding nsbStart2 = (NamespaceBinding)tuple2._1();
        NamespaceBinding nsbEnd2 = (NamespaceBinding)tuple2._2();
        for (NamespaceBinding n = nsbStart2; n != nsbEnd2 && n != null && n != TopScope$.MODULE$; n = n.parent()) {
            String prefix = n.prefix() == null ? "xmlns" : "xmlns:" + n.prefix();
            String uri = n.uri() == null ? "" : n.uri();
            attrs.addAttribute("", "", prefix, "CDATA", uri);
        }
        return attrs;
    }

    private NamespaceBinding shadowRedefined(NamespaceBinding start, NamespaceBinding stop) {
        List ps0 = SAXInfosetOutputter.prefixList$1(stop, start).reverse();
        List ps = (List)ps0.distinct();
        if (ps.size() == ps0.size()) {
            return start;
        }
        return SAXInfosetOutputter.fromPrefixList$1(stop, start, ps);
    }

    private Tuple2<NamespaceBinding, NamespaceBinding> getNsbStartAndEnd(InfosetElement elem) {
        DIElement diElem = (DIElement)elem;
        NamespaceBinding nsbStart = diElem.erd().minimizedScope();
        TopScope$ nsbEnd = diElem.isRoot() ? TopScope$.MODULE$ : diElem.diParent().erd().minimizedScope();
        NamespaceBinding namespaceBinding = nsbStart;
        TopScope$ topScope$ = nsbEnd;
        if (!(namespaceBinding != null ? !namespaceBinding.equals(topScope$) : topScope$ != null)) {
            return Tuple2$.MODULE$.apply((Object)nsbStart, (Object)nsbStart);
        }
        return Tuple2$.MODULE$.apply((Object)this.shadowRedefined(nsbStart, (NamespaceBinding)nsbEnd), (Object)nsbEnd);
    }

    private void doStartElement(InfosetElement elem, ContentHandler contentHandler) {
        String elemQname;
        String localName;
        String ns;
        String string;
        block7: {
            Tuple3<String, String, String> tuple3;
            block6: {
                tuple3 = this.getNamespaceLocalNameAndQName(elem);
                if (tuple3 == null) break block6;
                String string2 = (String)tuple3._1();
                String string3 = (String)tuple3._2();
                string = (String)tuple3._3();
                if (string2 == null) break block6;
                ns = string2;
                if (string3 == null) break block6;
                localName = string3;
                if (string != null) break block7;
            }
            throw new MatchError(tuple3);
        }
        String qName = string;
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)ns, (Object)localName, (Object)qName);
        String ns2 = (String)tuple3._1();
        String localName2 = (String)tuple3._2();
        String qName2 = (String)tuple3._3();
        AttributesImpl attrs = new AttributesImpl();
        String elemUri = this.namespacesFeature() ? ns2 : "";
        String elemLocalName = this.namespacesFeature() ? localName2 : "";
        String string4 = elemQname = this.namespacePrefixesFeature() ? qName2 : "";
        if (this.namespacesFeature()) {
            this.doStartPrefixMapping(elem, contentHandler);
        }
        if (this.namespacePrefixesFeature()) {
            this.doAttributesPrefixMapping(elem, attrs);
        }
        if (elem.isNilled()) {
            String isNilled = "true";
            String nType = "CDATA";
            String nValue = isNilled;
            String nQname = this.namespacePrefixesFeature() ? "xsi:nil" : "";
            String nUri = this.namespacesFeature() ? NS$.MODULE$.implicitNStoString(XMLUtils$.MODULE$.XSI_NAMESPACE()) : "";
            String nLocalName = this.namespacesFeature() ? "nil" : "";
            attrs.addAttribute(nUri, nLocalName, nQname, nType, nValue);
        }
        contentHandler.startElement(elemUri, elemLocalName, elemQname, attrs);
    }

    private void doEndElement(InfosetElement elem, ContentHandler contentHandler) {
        String localName;
        String ns;
        String string;
        block5: {
            Tuple3<String, String, String> tuple3;
            block4: {
                tuple3 = this.getNamespaceLocalNameAndQName(elem);
                if (tuple3 == null) break block4;
                String string2 = (String)tuple3._1();
                String string3 = (String)tuple3._2();
                string = (String)tuple3._3();
                if (string2 == null) break block4;
                ns = string2;
                if (string3 == null) break block4;
                localName = string3;
                if (string != null) break block5;
            }
            throw new MatchError(tuple3);
        }
        String qName = string;
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)ns, (Object)localName, (Object)qName);
        String ns2 = (String)tuple3._1();
        String localName2 = (String)tuple3._2();
        String qName2 = (String)tuple3._3();
        String elemUri = this.namespacesFeature() ? ns2 : "";
        String elemLocalName = this.namespacesFeature() ? localName2 : "";
        String elemQname = this.namespacePrefixesFeature() ? qName2 : "";
        contentHandler.endElement(elemUri, elemLocalName, elemQname);
        if (this.namespacesFeature()) {
            this.doEndPrefixMapping(elem, contentHandler);
            return;
        }
    }

    private Tuple3<String, String, String> getNamespaceLocalNameAndQName(InfosetElement elem) {
        String ns = elem.metadata().namespace() == null ? "" : elem.metadata().namespace();
        String elemName = elem.metadata().name();
        String qName = ((DIElement)elem).erd().prefixedName();
        return Tuple3$.MODULE$.apply((Object)ns, (Object)elemName, (Object)qName);
    }

    private static final List prefixList$1(NamespaceBinding stop$1, NamespaceBinding x) {
        if (x == null || x == stop$1) {
            return package$.MODULE$.Nil();
        }
        return SAXInfosetOutputter.prefixList$1(stop$1, x.parent()).$colon$colon((Object)x.prefix());
    }

    private static final NamespaceBinding fromPrefixList$1(NamespaceBinding stop$2, NamespaceBinding start$1, List l) {
        List list = l;
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return stop$2;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            String x = (String)colon2.head();
            List xs = list3;
            return new NamespaceBinding(x, start$1.getURI(x), SAXInfosetOutputter.fromPrefixList$1(stop$2, start$1, xs));
        }
        throw new MatchError((Object)list);
    }
}

