/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.targets;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.routing.targets.Target;
import org.apache.activemq.artemis.core.server.routing.targets.TargetListener;
import org.apache.activemq.artemis.core.server.routing.targets.TargetProbe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetMonitor
extends ActiveMQScheduledComponent
implements TargetListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Target target;
    private final List<TargetProbe> targetProbes;
    private volatile boolean targetReady = false;

    public Target getTarget() {
        return this.target;
    }

    public boolean isTargetReady() {
        return this.targetReady;
    }

    public TargetMonitor(ScheduledExecutorService scheduledExecutorService, int checkPeriod, Target target, List<TargetProbe> targetProbes) {
        super(scheduledExecutorService, 0L, (long)checkPeriod, TimeUnit.MILLISECONDS, false);
        this.target = target;
        this.targetProbes = targetProbes;
    }

    public synchronized void start() {
        this.target.setListener(this);
        super.start();
    }

    public synchronized void stop() {
        super.stop();
        this.targetReady = false;
        this.target.setListener(null);
        try {
            this.target.disconnect();
        }
        catch (Exception e) {
            logger.debug("Error on disconnecting target {}", (Object)this.target, (Object)e);
        }
    }

    public void run() {
        try {
            if (!this.target.isConnected()) {
                logger.debug("Connecting to {}", (Object)this.target);
                this.target.connect();
            }
            boolean bl = this.targetReady = this.target.checkReadiness() && this.checkTargetProbes();
            if (this.targetReady) {
                logger.debug("{} is ready", (Object)this.target);
            } else {
                logger.debug("{} is not ready", (Object)this.target);
            }
        }
        catch (Exception e) {
            logger.warn("Error monitoring {}", (Object)this.target, (Object)e);
            this.targetReady = false;
        }
    }

    private boolean checkTargetProbes() {
        for (TargetProbe targetProbe : this.targetProbes) {
            if (targetProbe.check(this.target)) continue;
            logger.info("{} has failed on {}", (Object)targetProbe.getName(), (Object)this.target);
            return false;
        }
        return true;
    }

    @Override
    public void targetConnected() {
    }

    @Override
    public void targetDisconnected() {
        this.targetReady = false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [target=" + String.valueOf(this.target) + ", targetReady=" + this.targetReady + "]";
    }
}

