/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.selector.filter;

import java.util.Objects;
import org.apache.activemq.artemis.selector.filter.Expression;

public abstract class BinaryExpression
implements Expression {
    protected Expression left;
    protected Expression right;

    public BinaryExpression(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public String toString() {
        return "(" + this.left.toString() + " " + this.getExpressionSymbol() + " " + this.right.toString() + ")";
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right, this.getExpressionSymbol());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BinaryExpression)) {
            return false;
        }
        BinaryExpression other = (BinaryExpression)obj;
        return Objects.equals(this.getExpressionSymbol(), other.getExpressionSymbol()) && Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
    }

    public abstract String getExpressionSymbol();

    public void setRight(Expression expression) {
        this.right = expression;
    }

    public void setLeft(Expression expression) {
        this.left = expression;
    }
}

