/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.function;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.ExceptionFunction;

@FunctionalInterface
public interface ExceptionUnaryOperator<T, E extends Exception>
extends ExceptionFunction<T, T, E> {
    @Override
    default public ExceptionUnaryOperator<T, E> andThen(ExceptionUnaryOperator<T, ? extends E> after) {
        Assert.checkNotNullParam((String)"after", after);
        return t -> after.apply(this.apply(t));
    }

    @Override
    default public ExceptionUnaryOperator<T, E> compose(ExceptionUnaryOperator<T, ? extends E> before) {
        Assert.checkNotNullParam((String)"before", before);
        return t -> this.apply(before.apply(t));
    }

    public static <T, E extends Exception> ExceptionUnaryOperator<T, E> of(ExceptionFunction<T, T, E> func) {
        return func instanceof ExceptionUnaryOperator ? (ExceptionUnaryOperator)func : func::apply;
    }

    public static <T, E extends Exception> ExceptionUnaryOperator<T, E> identity() {
        return t -> t;
    }
}

