/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfigurationException;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSExchangeSender;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSMessageUtils;
import org.apache.cxf.transport.jms.MessageStreamUtil;
import org.apache.cxf.transport.jms.SecurityContextFactory;
import org.apache.cxf.transport.jms.util.AbstractMessageListenerContainer;
import org.apache.cxf.transport.jms.util.JMSListenerContainer;
import org.apache.cxf.transport.jms.util.JMSSender;
import org.apache.cxf.transport.jms.util.JMSUtil;
import org.apache.cxf.transport.jms.util.MessageListenerContainer;
import org.apache.cxf.transport.jms.util.PollingMessageListenerContainer;
import org.apache.cxf.transport.jms.util.ResourceCloser;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class JMSConduit
extends AbstractConduit
implements JMSExchangeSender,
MessageListener {
    static final Logger LOG = LogUtils.getL7dLogger(JMSConduit.class);
    private static final String CORRELATED = JMSConduit.class.getName() + ".correlated";
    private JMSConfiguration jmsConfig;
    private Map<String, Exchange> correlationMap = new ConcurrentHashMap<String, Exchange>();
    private JMSListenerContainer jmsListener;
    private String conduitId;
    private final AtomicLong messageCount = new AtomicLong(0L);
    private JMSBusLifeCycleListener listener;
    private Bus bus;
    private volatile Connection connection;
    private volatile Destination staticReplyDestination;

    public JMSConduit(EndpointReferenceType target, JMSConfiguration jmsConfig, Bus b) {
        super(target);
        this.bus = b;
        this.jmsConfig = jmsConfig;
        this.conduitId = UUID.randomUUID().toString().replaceAll("-", "");
    }

    public void prepare(org.apache.cxf.message.Message message) throws IOException {
        boolean isTextPayload = "text".equals(this.jmsConfig.getMessageType());
        MessageStreamUtil.prepareStream(message, isTextPayload, this);
    }

    public void close(org.apache.cxf.message.Message msg) throws IOException {
        MessageStreamUtil.closeStreams(msg);
        super.close(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() throws JMSException {
        Connection result = this.connection;
        if (result == null) {
            JMSConduit jMSConduit = this;
            synchronized (jMSConduit) {
                result = this.connection;
                if (result == null) {
                    result = JMSFactory.createConnection(this.jmsConfig);
                    this.trySetExListener(result);
                    result.start();
                    this.connection = result;
                }
            }
        }
        return result;
    }

    private void trySetExListener(Connection conn) {
        try {
            conn.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException exception) {
                    JMSConduit.this.jmsConfig.resetCachedReplyDestination();
                    JMSConduit.this.staticReplyDestination = null;
                }
            });
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    @Override
    public void sendExchange(Exchange exchange, Object request) {
        org.apache.cxf.message.Message outMessage;
        LOG.log(Level.FINE, "JMSConduit send message");
        org.apache.cxf.message.Message message = outMessage = exchange.getOutMessage() == null ? exchange.getOutFaultMessage() : exchange.getOutMessage();
        if (outMessage == null) {
            throw new RuntimeException("Exchange to be sent has no outMessage");
        }
        this.jmsConfig.ensureProperlyConfigured();
        this.assertIsNotTextMessageAndMtom(outMessage);
        try (ResourceCloser closer = new ResourceCloser();){
            Connection c;
            if (this.jmsConfig.isOneSessionPerConnection()) {
                c = closer.register(JMSFactory.createConnection(this.jmsConfig));
                c.start();
            } else {
                c = this.getConnection();
            }
            Session session = closer.register(c.createSession(false, 1));
            if (exchange.isOneWay()) {
                this.sendMessage(request, outMessage, null, null, closer, session);
            } else {
                this.sendAndReceiveMessage(exchange, request, outMessage, closer, session);
            }
        }
        catch (JMSException e) {
            if (this.jmsListener != null) {
                this.jmsListener.shutdown();
            }
            this.jmsListener = null;
            if (!this.jmsConfig.isOneSessionPerConnection()) {
                if (exchange.get((Object)"jms_message_consumer") != null) {
                    ResourceCloser.close(exchange.get((Object)"jms_message_consumer"));
                }
                this.jmsConfig.resetCachedReplyDestination();
                ResourceCloser.close(this.connection);
                this.connection = null;
            }
            this.staticReplyDestination = null;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw JMSUtil.convertJmsException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupReplyDestination(Session session) throws JMSException {
        if (this.staticReplyDestination == null) {
            JMSConduit jMSConduit = this;
            synchronized (jMSConduit) {
                if (this.staticReplyDestination == null) {
                    Destination staticReplyDestinationTmp = this.jmsConfig.getReplyDestination(session);
                    Object messageSelector = JMSFactory.getMessageSelector(this.jmsConfig, this.conduitId);
                    if (this.jmsConfig.getMessageSelector() != null) {
                        messageSelector = (String)messageSelector + (messageSelector != null && !((String)messageSelector).isEmpty() ? " AND " : "") + this.jmsConfig.getMessageSelector();
                    }
                    if (messageSelector == null && !this.jmsConfig.isPubSubDomain()) {
                        return;
                    }
                    AbstractMessageListenerContainer container = this.jmsConfig.isOneSessionPerConnection() ? new PollingMessageListenerContainer(this.jmsConfig, true, this) : new MessageListenerContainer(this.getConnection(), staticReplyDestinationTmp, this);
                    container.setTransactionManager(this.jmsConfig.getTransactionManager());
                    container.setTransacted(this.jmsConfig.isSessionTransacted());
                    container.setDurableSubscriptionName(this.jmsConfig.getDurableSubscriptionName());
                    container.setMessageSelector((String)messageSelector);
                    Object executor = this.bus.getProperty("org.apache.cxf.extensions.jms.conduit.executor");
                    if (executor instanceof Executor) {
                        container.setExecutor((Executor)executor);
                    }
                    container.start();
                    this.jmsListener = container;
                    this.addBusListener();
                    this.staticReplyDestination = staticReplyDestinationTmp;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAndReceiveMessage(Exchange exchange, Object request, org.apache.cxf.message.Message outMessage, ResourceCloser closer, Session session) throws JMSException {
        this.setupReplyDestination(session);
        JMSMessageHeadersType headers = this.getOrCreateJmsHeaders(outMessage);
        String userCID = headers.getJMSCorrelationID();
        this.assertIsNotAsyncAndUserCID(exchange, userCID);
        String correlationId = this.createCorrelationId(exchange, userCID);
        if (correlationId != null) {
            this.correlationMap.put(correlationId, exchange);
        }
        Exchange exchange2 = exchange;
        synchronized (exchange2) {
            block14: {
                boolean useSyncReceive;
                String replyTo = headers.getJMSReplyTo();
                String jmsMessageID = this.sendMessage(request, outMessage, this.jmsConfig.getReplyToDestination(session, replyTo), correlationId, closer, session);
                Destination replyDestination = this.jmsConfig.getReplyDestination(session, replyTo);
                boolean bl = useSyncReceive = (correlationId == null || userCID != null) && !this.jmsConfig.isPubSubDomain() || !replyDestination.equals(this.staticReplyDestination);
                if (correlationId == null) {
                    correlationId = jmsMessageID;
                    this.correlationMap.put(correlationId, exchange);
                }
                if (!exchange.isSynchronous()) {
                    return;
                }
                try {
                    if (useSyncReceive) {
                        exchange.put((Object)"jms_ignore_timeout", (Object)this.jmsConfig.isIgnoreTimeoutException());
                        Message replyMessage = JMSUtil.receive(session, replyDestination, correlationId, this.jmsConfig.getReceiveTimeout(), this.jmsConfig.isPubSubNoLocal(), exchange);
                        this.processReplyMessage(exchange, replyMessage);
                        break block14;
                    }
                    try {
                        exchange.wait(this.jmsConfig.getReceiveTimeout());
                    }
                    catch (InterruptedException e) {
                        throw new JMSException("Interrupted while correlating " + e.getMessage());
                    }
                    if (!Boolean.TRUE.equals(exchange.get((Object)CORRELATED))) {
                        if (this.jmsConfig.isIgnoreTimeoutException()) {
                            throw new RuntimeException("Timeout receiving message with correlationId " + correlationId);
                        }
                        throw new JMSException("Timeout receiving message with correlationId " + correlationId);
                    }
                }
                finally {
                    this.correlationMap.remove(correlationId);
                }
            }
        }
    }

    private String sendMessage(Object request, org.apache.cxf.message.Message outMessage, Destination replyToDestination, String correlationId, ResourceCloser closer, Session session) throws JMSException {
        JMSMessageHeadersType headers = this.getOrCreateJmsHeaders(outMessage);
        Message message = JMSMessageUtils.asJMSMessage(this.jmsConfig, outMessage, request, this.jmsConfig.getMessageType(), session, correlationId, "org.apache.cxf.jms.client.request.headers");
        if (replyToDestination == null && headers.isSetJMSReplyTo()) {
            String replyTo = headers.getJMSReplyTo();
            replyToDestination = this.jmsConfig.getReplyDestination(session, replyTo);
        }
        if (replyToDestination != null) {
            message.setJMSReplyTo(replyToDestination);
        }
        JMSSender sender = JMSFactory.createJmsSender(this.jmsConfig, headers);
        Destination targetDest = this.jmsConfig.getTargetDestination(session);
        sender.sendMessage(session, targetDest, message);
        String jmsMessageID = message.getJMSMessageID();
        LOG.log(Level.FINE, "client sending request message " + jmsMessageID + " to " + targetDest);
        headers.setJMSMessageID(jmsMessageID);
        return jmsMessageID;
    }

    private void assertIsNotAsyncAndUserCID(Exchange exchange, String userCID) {
        if (!exchange.isSynchronous() && userCID != null) {
            throw new IllegalArgumentException("User CID can not be used for asynchronous exchanges");
        }
    }

    private void assertIsNotTextMessageAndMtom(org.apache.cxf.message.Message outMessage) {
        boolean isTextPayload = "text".equals(this.jmsConfig.getMessageType());
        if (isTextPayload && MessageUtils.getContextualBoolean((org.apache.cxf.message.Message)outMessage, (String)"mtom-enabled") && outMessage.getAttachments() != null && outMessage.getAttachments().size() > 0) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INVALID_MESSAGE_TYPE", LOG, new Object[0]);
            throw new ConfigurationException(msg);
        }
    }

    private String createCorrelationId(Exchange exchange, String userCID) {
        if (userCID != null) {
            return userCID;
        }
        if (!this.jmsConfig.isSetConduitSelectorPrefix() && !this.jmsConfig.isReplyPubSubDomain() && exchange.isSynchronous() && !this.jmsConfig.isUseConduitIdSelector()) {
            return null;
        }
        String prefix = this.jmsConfig.isUseConduitIdSelector() ? this.jmsConfig.getConduitSelectorPrefix() + this.conduitId : this.jmsConfig.getConduitSelectorPrefix();
        return JMSUtil.createCorrelationId(prefix, this.messageCount.incrementAndGet());
    }

    private JMSMessageHeadersType getOrCreateJmsHeaders(org.apache.cxf.message.Message outMessage) {
        JMSMessageHeadersType headers = (JMSMessageHeadersType)outMessage.get((Object)"org.apache.cxf.jms.client.request.headers");
        if (headers == null) {
            headers = new JMSMessageHeadersType();
            outMessage.put((Object)"org.apache.cxf.jms.client.request.headers", (Object)headers);
        }
        return headers;
    }

    private synchronized void addBusListener() {
        BusLifeCycleManager blcm;
        if (this.listener == null && this.bus != null && (blcm = (BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)) != null) {
            this.listener = new JMSBusLifeCycleListener(this, blcm);
        }
    }

    public void onMessage(Message jmsMessage) {
        try {
            String correlationId = jmsMessage.getJMSCorrelationID();
            LOG.log(Level.FINE, "Received reply message with correlation id " + correlationId);
            Exchange exchange = this.getExchange(correlationId);
            if (exchange == null) {
                LOG.log(Level.WARNING, "Could not correlate message with correlationId " + correlationId);
            } else {
                this.processReplyMessage(exchange, jmsMessage);
            }
        }
        catch (JMSException e) {
            throw JMSUtil.convertJmsException(e);
        }
    }

    private Exchange getExchange(String correlationId) {
        Exchange exchange = null;
        for (int count = 0; exchange == null && count < 100; ++count) {
            exchange = this.correlationMap.remove(correlationId);
            if (exchange != null) continue;
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while correlating", e);
            }
        }
        return exchange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processReplyMessage(Exchange exchange, Message jmsMessage) throws JMSException {
        LOG.log(Level.FINE, "client received reply: ", jmsMessage);
        try {
            org.apache.cxf.message.Message inMessage = JMSMessageUtils.asCXFMessage(jmsMessage, "org.apache.cxf.jms.client.response.headers");
            if (this.jmsConfig.isCreateSecurityContext()) {
                SecurityContext securityContext = SecurityContextFactory.buildSecurityContext(jmsMessage, this.jmsConfig);
                inMessage.put(SecurityContext.class, (Object)securityContext);
            }
            exchange.setInMessage(inMessage);
            Object responseCode = inMessage.get((Object)org.apache.cxf.message.Message.RESPONSE_CODE);
            exchange.put((Object)org.apache.cxf.message.Message.RESPONSE_CODE, responseCode);
            if (exchange.isSynchronous()) {
                Exchange exchange2 = exchange;
                synchronized (exchange2) {
                    exchange.put((Object)CORRELATED, (Object)Boolean.TRUE);
                    exchange.notifyAll();
                }
            }
            if (this.incomingObserver != null) {
                this.incomingObserver.onMessage(exchange.getInMessage());
            }
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().log(Level.WARNING, "can't get the right encoding information " + ex);
        }
    }

    private synchronized void shutdownListeners() {
        if (this.listener != null) {
            this.listener.unreg();
            this.listener = null;
        }
        if (this.jmsListener != null) {
            this.jmsListener.stop();
            this.jmsListener.shutdown();
            this.jmsListener = null;
            this.staticReplyDestination = null;
        }
    }

    public synchronized void close() {
        this.shutdownListeners();
        this.jmsConfig.resetCachedReplyDestination();
        ResourceCloser.close(this.connection);
        this.connection = null;
        LOG.log(Level.FINE, "JMSConduit closed ");
    }

    protected Logger getLogger() {
        return LOG;
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    protected static boolean isSetReplyTo(org.apache.cxf.message.Message message) {
        Boolean ret = (Boolean)message.get((Object)"org.apache.cxf.jms.client.set.replyto");
        return ret == null || ret != false;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    static class JMSBusLifeCycleListener
    implements BusLifeCycleListener {
        final WeakReference<JMSConduit> ref;
        BusLifeCycleManager blcm;

        JMSBusLifeCycleListener(JMSConduit c, BusLifeCycleManager b) {
            this.ref = new WeakReference<JMSConduit>(c);
            this.blcm = b;
            this.blcm.registerLifeCycleListener((BusLifeCycleListener)this);
        }

        public void initComplete() {
        }

        public void postShutdown() {
        }

        public void preShutdown() {
            this.unreg();
            this.blcm = null;
            JMSConduit c = (JMSConduit)this.ref.get();
            if (c != null) {
                c.listener = null;
                c.close();
            }
        }

        public void unreg() {
            if (this.blcm != null) {
                this.blcm.unregisterLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }
}

