/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.uri;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils.IntrospectionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluentPropertyBeanIntrospectorWithIgnores
extends FluentPropertyBeanIntrospector {
    static Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static ConcurrentHashSet<Pair<String, String>> ignores = new ConcurrentHashSet();

    public static void addIgnore(String className, String methodName) {
        logger.trace("Adding ignore on {}/{}", (Object)className, (Object)methodName);
        ignores.add(new Pair<String, String>(className, methodName));
    }

    public static boolean isIgnored(String className, String methodName) {
        return ignores.contains(new Pair<String, String>(className, methodName));
    }

    public void introspect(IntrospectionContext icontext) throws IntrospectionException {
        for (Method m : icontext.getTargetClass().getMethods()) {
            String methodName = m.getName();
            if (!methodName.startsWith(this.getWriteMethodPrefix()) || methodName.equals(this.getWriteMethodPrefix())) continue;
            if (FluentPropertyBeanIntrospectorWithIgnores.isIgnored(icontext.getTargetClass().getName(), methodName)) {
                logger.trace("{} Ignored for {}", (Object)methodName, (Object)icontext.getTargetClass().getName());
                continue;
            }
            String propertyName = this.propertyName(methodName);
            this.introspect(icontext, m, propertyName);
            String defaultPropertyName = this.defaultPropertyName(methodName);
            if (defaultPropertyName.equals(propertyName)) continue;
            this.introspect(icontext, m, defaultPropertyName);
        }
    }

    private void introspect(IntrospectionContext icontext, Method writeMethod, String propertyName) {
        PropertyDescriptor pd = icontext.getPropertyDescriptor(propertyName);
        Method readMethod = null;
        if (pd != null) {
            readMethod = pd.getReadMethod();
        }
        if (readMethod == null) {
            try {
                if (writeMethod != null && writeMethod.getParameterTypes().length == 1 && writeMethod.getParameterTypes()[0].equals(Boolean.class)) {
                    readMethod = icontext.getTargetClass().getMethod("is" + this.capitalise(propertyName), null);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        try {
            PropertyDescriptor withFluentWrite = this.createFluentPropertyDescriptor(readMethod, writeMethod, propertyName);
            icontext.addPropertyDescriptor(withFluentWrite);
        }
        catch (IntrospectionException e) {
            logger.trace("error on add fluent descriptor for property named {}", (Object)propertyName, (Object)e);
        }
    }

    private String capitalise(String name) {
        if (name.length() > 1) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return name;
    }

    private PropertyDescriptor createFluentPropertyDescriptor(Method readMethod, Method writeMethod, String propertyName) throws IntrospectionException {
        return new PropertyDescriptor(propertyName, readMethod, writeMethod);
    }

    private String propertyName(String methodName) {
        String propName = methodName.substring(this.getWriteMethodPrefix().length());
        return propName.length() > 1 ? Character.toLowerCase(propName.charAt(0)) + propName.substring(1) : propName.toLowerCase(Locale.ENGLISH);
    }

    private String defaultPropertyName(String methodName) {
        String propertyName = methodName.substring(this.getWriteMethodPrefix().length());
        return propertyName.length() > 1 ? Introspector.decapitalize(propertyName) : propertyName.toLowerCase(Locale.ENGLISH);
    }
}

