/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.util.Bits;
import org.jgroups.util.NameCache;
import org.jgroups.util.UUID;

public class FlagsUUID
extends UUID {
    protected int flags;

    public FlagsUUID() {
    }

    protected FlagsUUID(byte[] data) {
        super(data);
    }

    public FlagsUUID(long mostSigBits, long leastSigBits) {
        super(mostSigBits, leastSigBits);
    }

    public <T extends FlagsUUID> FlagsUUID(T other) {
        super(other.mostSigBits, other.leastSigBits);
        this.flags = other.flags;
    }

    @Override
    public Supplier<? extends UUID> create() {
        return FlagsUUID::new;
    }

    public static FlagsUUID randomUUID() {
        return new FlagsUUID(FlagsUUID.generateRandomBytes());
    }

    public static FlagsUUID randomUUID(String name) {
        FlagsUUID retval = new FlagsUUID(FlagsUUID.generateRandomBytes());
        if (name != null) {
            NameCache.add(retval, name);
        }
        return retval;
    }

    public <T extends FlagsUUID> T setFlag(short flag) {
        this.flags |= flag;
        return (T)this;
    }

    public <T extends FlagsUUID> T clearFlag(short flag) {
        this.flags &= ~flag;
        return (T)this;
    }

    public boolean isFlagSet(short flag) {
        return (this.flags & flag) == flag;
    }

    public <T extends FlagsUUID> T addContents(T other) {
        this.flags |= other.flags;
        return (T)this;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bits.writeIntCompressed(this.flags, out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.flags = Bits.readIntCompressed(in);
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + Bits.size(this.flags);
    }

    @Override
    public String toString() {
        return this.flags == 0 ? super.toString() : String.format("%s (flags=%d)", super.toString(), this.flags);
    }
}

