/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.persistence.impl.journal.AbstractJournalStorageManager;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ReplicationStartSyncMessage
extends PacketImpl {
    private long[] ids;
    private SyncDataType dataType;
    private boolean synchronizationIsFinished;
    private String nodeID;
    private boolean allowsAutoFailBack;

    public ReplicationStartSyncMessage() {
        super((byte)120);
    }

    public ReplicationStartSyncMessage(List<Long> filenames) {
        this();
        this.ids = new long[filenames.size()];
        for (int i = 0; i < filenames.size(); ++i) {
            this.ids[i] = filenames.get(i);
        }
        this.dataType = SyncDataType.LargeMessages;
        this.nodeID = "";
    }

    public ReplicationStartSyncMessage(String nodeID, long nodeDataVersion) {
        this();
        this.synchronizationIsFinished = true;
        this.nodeID = nodeID;
        this.ids = new long[1];
        this.ids[0] = nodeDataVersion;
        this.dataType = SyncDataType.ActivationSequence;
    }

    public ReplicationStartSyncMessage(JournalFile[] datafiles, AbstractJournalStorageManager.JournalContent contentType, String nodeID, boolean allowsAutoFailBack) {
        this();
        this.nodeID = nodeID;
        this.allowsAutoFailBack = allowsAutoFailBack;
        this.synchronizationIsFinished = false;
        this.ids = new long[datafiles.length];
        for (int i = 0; i < datafiles.length; ++i) {
            this.ids[i] = datafiles[i].getFileID();
        }
        switch (contentType) {
            case MESSAGES: {
                this.dataType = SyncDataType.JournalMessages;
                break;
            }
            case BINDINGS: {
                this.dataType = SyncDataType.JournalBindings;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int expectedEncodeSize() {
        int size = 15 + this.nodeID.length() * 3;
        return size += 5 + 8 * this.ids.length;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeBoolean(this.synchronizationIsFinished);
        buffer.writeBoolean(this.allowsAutoFailBack);
        buffer.writeString(this.nodeID);
        buffer.writeByte(this.dataType.code);
        buffer.writeInt(this.ids.length);
        for (long id : this.ids) {
            buffer.writeLong(id);
        }
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.synchronizationIsFinished = buffer.readBoolean();
        this.allowsAutoFailBack = buffer.readBoolean();
        this.nodeID = buffer.readString();
        if (buffer.readableBytes() == 0) {
            return;
        }
        this.dataType = SyncDataType.getDataType(buffer.readByte());
        int length = buffer.readInt();
        this.ids = new long[length];
        for (int i = 0; i < length; ++i) {
            this.ids[i] = buffer.readLong();
        }
    }

    public boolean isServerToFailBack() {
        return this.allowsAutoFailBack;
    }

    public boolean isSynchronizationFinished() {
        return this.synchronizationIsFinished;
    }

    public SyncDataType getDataType() {
        return this.dataType;
    }

    public long[] getFileIds() {
        return this.ids;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.allowsAutoFailBack, this.dataType, Arrays.hashCode(this.ids), this.nodeID, this.synchronizationIsFinished});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationStartSyncMessage)) {
            return false;
        }
        ReplicationStartSyncMessage other = (ReplicationStartSyncMessage)((Object)obj);
        return this.allowsAutoFailBack == other.allowsAutoFailBack && this.dataType == other.dataType && Arrays.equals(this.ids, other.ids) && Objects.equals(this.nodeID, other.nodeID) && this.synchronizationIsFinished == other.synchronizationIsFinished;
    }

    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", synchronizationIsFinished=" + this.synchronizationIsFinished);
        sb.append(", dataType=" + String.valueOf((Object)this.dataType));
        sb.append(", nodeID=" + this.nodeID);
        sb.append(", ids=" + Arrays.toString(this.ids));
        sb.append(", allowsAutoFailBack=" + this.allowsAutoFailBack);
        return sb.toString();
    }

    public static enum SyncDataType {
        JournalBindings(AbstractJournalStorageManager.JournalContent.BINDINGS.typeByte),
        JournalMessages(AbstractJournalStorageManager.JournalContent.MESSAGES.typeByte),
        LargeMessages(2),
        ActivationSequence(3);

        private byte code;

        private SyncDataType(byte code) {
            this.code = code;
        }

        public static AbstractJournalStorageManager.JournalContent getJournalContentType(SyncDataType dataType) {
            return AbstractJournalStorageManager.JournalContent.getType(dataType.code);
        }

        public static SyncDataType getDataType(byte code) {
            if (code == SyncDataType.JournalBindings.code) {
                return JournalBindings;
            }
            if (code == SyncDataType.JournalMessages.code) {
                return JournalMessages;
            }
            if (code == SyncDataType.LargeMessages.code) {
                return LargeMessages;
            }
            if (code == SyncDataType.ActivationSequence.code) {
                return ActivationSequence;
            }
            throw new InvalidParameterException("invalid byte: " + code);
        }
    }
}

