/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.jetty11;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.websocket.jetty11.Jetty11WebSocketDestination;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.server.JettyWebSocketServerContainer;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;

class JettyWebSocketHandler
extends JettyHTTPHandler {
    final Jetty11WebSocketDestination webSocketDestination;
    JettyWebSocketServerContainer webSocketContainer;

    JettyWebSocketHandler(JettyHTTPDestination jhd, boolean cmExact, Jetty11WebSocketDestination wsd) {
        super(jhd, cmExact);
        this.webSocketDestination = wsd;
    }

    public void doStart() throws Exception {
        this.webSocketContainer = this.webSocketDestination.getWebSocketContainer(this.getServletContext());
        super.doStart();
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.webSocketContainer.upgrade(this.webSocketDestination.getCreator(), request, response)) {
            baseRequest.setHandled(true);
            return;
        }
        super.handle(target, baseRequest, request, response);
    }

    public ContextHandler createContextHandler() {
        ServletContextHandler handler = new ServletContextHandler();
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)handler, null);
        return handler;
    }
}

