/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.HashMap;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.utils.JsonLoader;

public class ServerStatus {
    public static final String SERVER_COMPONENT = "server";
    public static final String CONFIGURATION_COMPONENT = "configuration";
    public static final String JAAS_COMPONENT = "server/jaas";
    private static final ServerStatus instance = new ServerStatus();
    private ActiveMQServerImpl server;
    private final HashMap<String, String> immutableStateValues = new HashMap();
    private JsonObject globalStatus = JsonLoader.createObjectBuilder().build();

    public static void clear() {
        ServerStatus.instance.server = null;
        ServerStatus.instance.immutableStateValues.clear();
    }

    public static synchronized ServerStatus getInstanceFor(ActiveMQServerImpl activeMQServer) {
        if (ServerStatus.instance.server == null) {
            ServerStatus.instance.server = activeMQServer;
            ServerStatus.instance.immutableStateValues.put("version", ServerStatus.instance.server.getVersion().getFullVersion());
        }
        return instance;
    }

    public static synchronized ServerStatus getInstance() {
        return instance;
    }

    public synchronized String asJson() {
        this.updateServerStatus();
        return this.globalStatus.toString();
    }

    private synchronized void updateServerStatus() {
        if (ServerStatus.instance.server != null) {
            HashMap<String, String> snapshotOfServerStatusAttributes = new HashMap<String, String>();
            snapshotOfServerStatusAttributes.putAll(this.immutableStateValues);
            snapshotOfServerStatusAttributes.put("identity", this.server.getIdentity());
            SimpleString nodeId = this.server.getNodeID();
            snapshotOfServerStatusAttributes.put("nodeId", nodeId == null ? null : nodeId.toString());
            snapshotOfServerStatusAttributes.put("uptime", this.server.getUptime());
            snapshotOfServerStatusAttributes.put("state", this.server.getState().toString());
            this.update(SERVER_COMPONENT, JsonUtil.toJsonObject(snapshotOfServerStatusAttributes));
        }
    }

    public synchronized void update(String component, String statusJson) {
        this.update(component, JsonUtil.readJsonObject((String)statusJson));
    }

    public synchronized void update(String component, HashMap<String, String> statusAttributes) {
        this.update(component, JsonUtil.toJsonObject(statusAttributes));
    }

    public synchronized void update(String componentPath, JsonObject componentStatus) {
        JsonObjectBuilder jsonObjectBuilder = JsonUtil.objectBuilderWithValueAtPath((String)componentPath, (JsonValue)componentStatus);
        this.globalStatus = JsonUtil.mergeAndUpdate((JsonObject)this.globalStatus, (JsonObject)jsonObjectBuilder.build());
    }
}

