/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse;

import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.sse.OutboundSseEvent;
import java.lang.reflect.Type;

public final class OutboundSseEventImpl
implements OutboundSseEvent {
    private final String id;
    private final String name;
    private final String comment;
    private final long reconnectDelay;
    private final Class<?> type;
    private final Type genericType;
    private final MediaType mediaType;
    private final Object data;

    private OutboundSseEventImpl(String id, String name, String comment, long reconnectDelay, Class<?> type, Type genericType, MediaType mediaType, Object data) {
        this.id = id;
        this.name = name;
        this.comment = comment;
        this.reconnectDelay = reconnectDelay;
        this.type = type;
        this.genericType = genericType;
        this.mediaType = mediaType;
        this.data = data;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public boolean isReconnectDelaySet() {
        return this.reconnectDelay != -1L;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public Object getData() {
        return this.data;
    }

    public static class BuilderImpl
    implements OutboundSseEvent.Builder {
        private String id;
        private String name;
        private String comment;
        private long reconnectDelay = -1L;
        private Class<?> type;
        private Type genericType;
        private MediaType mediaType = MediaType.TEXT_PLAIN_TYPE;
        private Object data;

        public OutboundSseEvent.Builder id(String newId) {
            this.id = newId;
            return this;
        }

        public OutboundSseEvent.Builder name(String newName) {
            this.name = newName;
            return this;
        }

        public OutboundSseEvent.Builder reconnectDelay(long milliseconds) {
            this.reconnectDelay = milliseconds;
            return this;
        }

        public OutboundSseEvent.Builder mediaType(MediaType newMediaType) {
            this.mediaType = newMediaType;
            return this;
        }

        public OutboundSseEvent.Builder comment(String newComment) {
            this.comment = newComment;
            return this;
        }

        public OutboundSseEvent.Builder data(Class newType, Object newData) {
            if (newType == null || newData == null) {
                throw new IllegalArgumentException("Parameters 'type' and 'data' must not be null.");
            }
            this.type = newType;
            this.data = newData;
            return this;
        }

        public OutboundSseEvent.Builder data(GenericType newType, Object newData) {
            if (newType == null || newData == null) {
                throw new IllegalArgumentException("Parameters 'type' and 'data' must not be null.");
            }
            this.genericType = newType.getType();
            this.data = newData;
            return this;
        }

        public OutboundSseEvent.Builder data(Object newData) {
            if (newData == null) {
                throw new IllegalArgumentException("Parameter 'data' must not be null.");
            }
            this.type = newData.getClass();
            this.data = newData;
            return this;
        }

        public OutboundSseEvent build() {
            return new OutboundSseEventImpl(this.id, this.name, this.comment, this.reconnectDelay, this.type, this.genericType, this.mediaType, this.data);
        }
    }
}

