/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server.servlet;

import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import org.apache.cxf.transport.http.netty.server.util.Utils;

public class NettyHttpSession
implements HttpSession {
    public static final String SESSION_ID_KEY = "JSESSIONID";
    private String id;
    private long creationTime;
    private long lastAccessedTime;
    private int maxInactiveInterval = -1;
    private Map<String, Object> attributes;

    public NettyHttpSession(String id) {
        this.id = id;
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
    }

    public Object getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : null;
    }

    public Enumeration getAttributeNames() {
        return Utils.enumerationFromKeys(this.attributes);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public HttpSessionContext getSessionContext() {
        throw new IllegalStateException("As of Version 2.1, this method is deprecated and has no replacement.");
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.keySet().toArray(new String[this.attributes.keySet().size()]);
    }

    public void invalidate() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            Object value = this.attributes.get(name);
            if (value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, value));
            }
            this.attributes.remove(name);
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap<String, Object>();
        }
        this.attributes.put(name, value);
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name, value));
        }
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public void touch() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public boolean isNew() {
        throw new IllegalStateException("Method 'isNew' not yet implemented!");
    }
}

