/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.WordUtils;
import org.apache.rat.OptionCollection;
import org.apache.rat.commandline.Arg;
import org.apache.rat.tools.MavenOption;
import org.apache.rat.utils.CasedString;

public final class MavenGenerator {
    private static final Map<String, String> RENAME_MAP = new HashMap<String, String>();
    private static final List<Option> MAVEN_FILTER_LIST = new ArrayList<Option>();
    private static final Predicate<Option> MAVEN_FILTER;

    public static Predicate<Option> getFilter() {
        return MAVEN_FILTER;
    }

    private MavenGenerator() {
    }

    public static void main(String[] args) throws IOException {
        if (args == null || args.length < 3) {
            System.err.println("At least three arguments are required: package, simple class name, target directory.");
            return;
        }
        String packageName = args[0];
        String className = args[1];
        String destDir = args[2];
        List<MavenOption> options = OptionCollection.buildOptions().getOptions().stream().filter(MAVEN_FILTER).map(MavenOption::new).collect(Collectors.toList());
        String pkgName = String.join((CharSequence)File.separator, new CasedString(CasedString.StringCase.DOT, packageName).getSegments());
        File file = new File(new File(new File(destDir), pkgName), className + ".java");
        System.out.println("Creating " + file);
        file.getParentFile().mkdirs();
        try (InputStream template = MavenGenerator.class.getResourceAsStream("/Maven.tpl");
             FileWriter writer = new FileWriter(file);){
            if (template == null) {
                throw new RuntimeException("Template /Maven.tpl not found");
            }
            LineIterator iter = IOUtils.lineIterator(new InputStreamReader(template, StandardCharsets.UTF_8));
            block31: while (iter.hasNext()) {
                String line = iter.next();
                switch (line.trim()) {
                    case "${static}": {
                        for (Map.Entry<String, String> entry : RENAME_MAP.entrySet()) {
                            writer.append(String.format("        xlateName.put(\"%s\", \"%s\");%n", entry.getKey(), entry.getValue()));
                        }
                        for (Option option : MAVEN_FILTER_LIST) {
                            writer.append(String.format("        unsupportedArgs.add(\"%s\");%n", StringUtils.defaultIfEmpty(option.getLongOpt(), option.getOpt())));
                        }
                        continue block31;
                    }
                    case "${methods}": {
                        MavenGenerator.writeMethods(writer, options);
                        break;
                    }
                    case "${package}": {
                        writer.append(String.format("package %s;%n", packageName));
                        break;
                    }
                    case "${constructor}": {
                        writer.append(String.format("    protected %s() {}%n", className));
                        break;
                    }
                    case "${class}": {
                        writer.append(String.format("public abstract class %s extends AbstractMojo {%n", className));
                        break;
                    }
                    case "${commonArgs}": {
                        InputStream argsTpl = MavenGenerator.class.getResourceAsStream("/Args.tpl");
                        try {
                            if (argsTpl == null) {
                                throw new RuntimeException("Args.tpl not found");
                            }
                            IOUtils.copy(argsTpl, (Writer)writer, StandardCharsets.UTF_8);
                            continue block31;
                        }
                        finally {
                            if (argsTpl == null) continue block31;
                            argsTpl.close();
                            continue block31;
                        }
                    }
                    default: {
                        writer.append(line).append(System.lineSeparator());
                    }
                }
            }
        }
    }

    private static String getComment(MavenOption option) {
        String arg;
        String desc = option.getDescription();
        if (desc == null) {
            throw new IllegalStateException(String.format("Description for %s may not be null", option.getName()));
        }
        if (!desc.contains(".")) {
            throw new IllegalStateException(String.format("First sentence of description for %s must end with a '.'", option.getName()));
        }
        if (option.hasArg()) {
            arg = desc.substring(desc.indexOf(" "), desc.indexOf(".") + 1);
            arg = WordUtils.capitalize(arg.substring(0, 1)) + arg.substring(1);
        } else {
            arg = "the state";
        }
        if (option.hasArg() && option.getArgName() != null) {
            Supplier<String> sup = OptionCollection.getArgumentTypes().get(option.getArgName());
            if (sup == null) {
                throw new IllegalStateException(String.format("Argument type %s must be in OptionCollection.ARGUMENT_TYPES", option.getArgName()));
            }
            desc = String.format("%s Argument%s should be %s%s. (See Argument Types for clarification)", desc, option.hasArgs() ? "s" : "", option.hasArgs() ? "" : "a ", option.getArgName());
        }
        StringBuilder sb = new StringBuilder().append(String.format("    /**%n     * %s%n     * @param %s %s%n", StringEscapeUtils.escapeHtml4(desc), option.getName(), StringEscapeUtils.escapeHtml4(arg)));
        if (option.isDeprecated()) {
            sb.append(String.format("     * @deprecated %s%n", StringEscapeUtils.escapeHtml4(option.getDeprecated())));
        }
        return sb.append(String.format("     */%n", new Object[0])).toString();
    }

    private static void writeMethods(FileWriter writer, List<MavenOption> options) throws IOException {
        for (MavenOption option : options) {
            writer.append(MavenGenerator.getComment(option)).append(option.getMethodSignature("    ", option.hasArgs())).append(" {").append(System.lineSeparator()).append(MavenGenerator.getBody(option)).append("    }").append(System.lineSeparator());
            if (!option.hasArgs()) continue;
            writer.append(MavenGenerator.getComment(option)).append(option.getMethodSignature("    ", false)).append(" {").append(System.lineSeparator()).append(MavenGenerator.getBody(option)).append("    }").append(System.lineSeparator());
        }
    }

    private static String getBody(MavenOption option) {
        if (option.hasArg()) {
            return String.format("        %sArg(%s, %s);%n", option.hasArgs() ? "add" : "set", option.keyValue(), option.getName());
        }
        return String.format("        if (%1$s) {%n            setArg(%2$s, null);%n        } else {%n            removeArg(%2$s);%n        }%n", option.getName(), option.keyValue());
    }

    static String createName(Option option) {
        String name = StringUtils.defaultIfEmpty(option.getLongOpt(), option.getOpt());
        name = StringUtils.defaultIfEmpty(RENAME_MAP.get(name), name).toLowerCase(Locale.ROOT);
        return new CasedString(CasedString.StringCase.KEBAB, name).toCase(CasedString.StringCase.CAMEL);
    }

    static {
        RENAME_MAP.put("addLicense", "add-license");
        MAVEN_FILTER_LIST.addAll(Arg.DIR.group().getOptions());
        MAVEN_FILTER_LIST.addAll(Arg.LOG_LEVEL.group().getOptions());
        MAVEN_FILTER_LIST.add(OptionCollection.HELP);
        MAVEN_FILTER = option -> !MAVEN_FILTER_LIST.contains(option) && option.getLongOpt() != null;
    }
}

