/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.perf;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;

public class FileNamePerformance {
    private static final int NUOF_RESOLVES = 100000;

    public static void main(String[] args) throws FileSystemException {
        FileSystemManager mgr = VFS.getManager();
        FileObject root = mgr.resolveFile("smb://HOME\\vfsusr:vfs%2f%25\\te:st@10.0.1.54/vfsusr");
        FileName rootName = root.getName();
        FileNamePerformance.testNames(mgr, rootName);
        FileNamePerformance.testChildren(root);
        FileNamePerformance.testFiles(mgr);
    }

    private static void testChildren(FileObject root) throws FileSystemException {
        for (int i = 0; i < 10; ++i) {
            root.resolveFile("/many/path/elements/with%25esc/any%25where/to/file.txt");
        }
        long startMillis = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            root.resolveFile("/many/path/elements/with%25esc/any%25where/to/file.txt");
        }
        long endMillis = System.currentTimeMillis();
        System.err.println("time to resolve 100000 children: " + (endMillis - startMillis) + " milliseconds");
    }

    private static void testFiles(FileSystemManager mgr) throws FileSystemException {
        for (int i = 0; i < 10; ++i) {
            mgr.resolveFile("smb://HOME\\vfsusr:vfs%2f%25\\te:st@10.0.1.54/vfsusr/many/path/elements/with%25esc/any%25where/to/file.txt");
        }
        long startMillis = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            mgr.resolveFile("smb://HOME\\vfsusr:vfs%2f%25\\te:st@10.0.1.54/vfsusr/many/path/elements/with%25esc/any%25where/to/file.txt");
        }
        long endMillis = System.currentTimeMillis();
        System.err.println("time to resolve 100000 files: " + (endMillis - startMillis) + " milliseconds");
    }

    private static void testNames(FileSystemManager mgr, FileName rootName) throws FileSystemException {
        for (int i = 0; i < 10; ++i) {
            mgr.resolveName(rootName, "/many/path/elements/with%25esc/any%25where/to/file.txt");
        }
        long startMillis = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            mgr.resolveName(rootName, "/many/path/elements/with%25esc/any%25where/to/file.txt");
        }
        long endMillis = System.currentTimeMillis();
        System.err.println("time to resolve 100000 names: " + (endMillis - startMillis) + " milliseconds");
    }
}

