/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;

public final class KempSmallMeanPoissonSampler
implements SharedStateDiscreteSampler {
    private final UniformRandomProvider rng;
    private final double p0;
    private final double mean;

    private KempSmallMeanPoissonSampler(UniformRandomProvider rng, double p0, double mean) {
        this.rng = rng;
        this.p0 = p0;
        this.mean = mean;
    }

    @Override
    public int sample() {
        int x = 0;
        double p = this.p0;
        for (double u = this.rng.nextDouble(); u > p; u -= p) {
            if ((p *= this.mean / (double)(++x)) != 0.0) continue;
            return x;
        }
        return x;
    }

    public String toString() {
        return "Kemp Small Mean Poisson deviate [" + this.rng.toString() + "]";
    }

    @Override
    public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new KempSmallMeanPoissonSampler(rng, this.p0, this.mean);
    }

    public static SharedStateDiscreteSampler of(UniformRandomProvider rng, double mean) {
        InternalUtils.requireStrictlyPositive(mean, "mean");
        double p0 = Math.exp(-mean);
        if (p0 > 0.0) {
            return new KempSmallMeanPoissonSampler(rng, p0, mean);
        }
        throw new IllegalArgumentException("No probability for mean: " + mean);
    }
}

