/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import java.util.stream.Stream;
import org.apache.commons.rng.JumpableUniformRandomProvider;
import org.apache.commons.rng.SplittableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source64.AbstractL128;
import org.apache.commons.rng.core.source64.LXMSupport;
import org.apache.commons.rng.core.util.NumberFactory;
import org.apache.commons.rng.core.util.RandomStreams;

public class L128X128Mix
extends AbstractL128
implements SplittableUniformRandomProvider {
    private static final int SEED_SIZE = 6;
    private static final int XBG_STATE_SIZE = 2;
    private static final long ML = -3024805186288043011L;
    private long x0;
    private long x1;

    public L128X128Mix(long[] seed) {
        seed = L128X128Mix.extendSeed(seed, 6);
        super(seed);
        this.x0 = seed[4];
        this.x1 = seed[5];
    }

    public L128X128Mix(long seed0, long seed1, long seed2, long seed3, long seed4, long seed5) {
        super(seed0, seed1, seed2, seed3);
        this.x0 = seed4;
        this.x1 = seed5;
    }

    protected L128X128Mix(L128X128Mix source) {
        super(source);
        this.x0 = source.x0;
        this.x1 = source.x1;
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.x0, this.x1}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 16);
        long[] tmp = NumberFactory.makeLongArray(c[0]);
        this.x0 = tmp[0];
        this.x1 = tmp[1];
        super.setStateInternal(c[1]);
    }

    @Override
    public long next() {
        long s0 = this.x0;
        long sh = this.lsh;
        long z = LXMSupport.lea64(sh + s0);
        long sl = this.lsl;
        long al = this.lal;
        long u = -3024805186288043011L * sl;
        this.lsh = -3024805186288043011L * sh + LXMSupport.unsignedMultiplyHigh(-3024805186288043011L, sl) + sl + this.lah + LXMSupport.unsignedAddHigh(u, al);
        this.lsl = u + al;
        long s1 = this.x1;
        this.x0 = Long.rotateLeft(s0, 24) ^ (s1 ^= s0) ^ s1 << 16;
        this.x1 = Long.rotateLeft(s1, 37);
        return z;
    }

    @Override
    public UniformRandomProvider jump() {
        return super.jump();
    }

    @Override
    public JumpableUniformRandomProvider longJump() {
        return super.longJump();
    }

    @Override
    AbstractL128 copy() {
        return new L128X128Mix(this);
    }

    public SplittableUniformRandomProvider split(UniformRandomProvider source) {
        return L128X128Mix.create(source.nextLong(), source);
    }

    public Stream<SplittableUniformRandomProvider> splits(long streamSize, SplittableUniformRandomProvider source) {
        return RandomStreams.generateWithSeed(streamSize, source, L128X128Mix::create);
    }

    private static SplittableUniformRandomProvider create(long seed, UniformRandomProvider source) {
        long x1;
        long s0 = source.nextLong();
        long s1 = seed << 1;
        long s2 = source.nextLong();
        long s3 = source.nextLong();
        long x0 = source.nextLong();
        if ((x0 | (x1 = source.nextLong())) == 0L) {
            long z = s3;
            x0 = LXMSupport.lea64(z);
            x1 = LXMSupport.lea64(z + -7046029254386353131L);
        }
        return new L128X128Mix(s0, s1, s2, s3, x0, x1);
    }
}

