/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public class TwoCmres
extends LongProvider {
    private static final String INTERNAL_ERROR_MSG = "Internal error: Please file a bug report";
    private static final byte SEED_GUARD = 9;
    private static final Cmres.Factory FACTORY = new Cmres.Factory();
    private final Cmres x;
    private final Cmres y;
    private long xx;
    private long yy;

    private TwoCmres(int seed, Cmres x, Cmres y) {
        this.x = x;
        this.y = y;
        this.setSeedInternal(seed);
    }

    public TwoCmres(Integer seed) {
        this(seed, 0, 1);
    }

    public TwoCmres(Integer seed, int i, int j) {
        this((int)seed, FACTORY.getIfDifferent(i, j), FACTORY.get(j));
    }

    @Override
    public long next() {
        this.xx = this.x.transform(this.xx);
        this.yy = this.y.transform(this.yy);
        return this.xx + this.yy;
    }

    @Override
    public String toString() {
        return super.toString() + " (" + this.x + " + " + this.y + ")";
    }

    public static int numberOfSubcycleGenerators() {
        return FACTORY.numberOfSubcycleGenerators();
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.xx, this.yy}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 16);
        long[] state = NumberFactory.makeLongArray(c[0]);
        this.xx = state[0];
        this.yy = state[1];
        super.setStateInternal(c[1]);
    }

    private void setSeedInternal(int seed) {
        int i;
        int xMax = (seed & 0xFFFF) + 9;
        int yMax = (seed >>> 16) + 9;
        this.xx = this.x.getStart();
        for (i = xMax; i > 0; --i) {
            this.xx = this.x.transform(this.xx);
        }
        this.yy = this.y.getStart();
        for (i = yMax; i > 0; --i) {
            this.yy = this.y.transform(this.yy);
        }
    }

    static class Cmres {
        private static final String SEP = ", ";
        private static final String HEX_FORMAT = "0x%016xL";
        private final int start;
        private final long multiply;
        private final int rotate;

        Cmres(long multiply, int rotate, int start) {
            this.multiply = multiply;
            this.rotate = rotate;
            this.start = start;
        }

        public String toString() {
            String m = String.format((Locale)null, HEX_FORMAT, this.multiply);
            return "Cmres: [" + m + SEP + this.rotate + SEP + this.start + "]";
        }

        public long getMultiply() {
            return this.multiply;
        }

        public int getStart() {
            return this.start;
        }

        long transform(long state) {
            long s = state;
            s *= this.multiply;
            s = Long.rotateLeft(s, this.rotate);
            return s -= state;
        }

        static class Factory {
            private static final List<Cmres> TABLE = new ArrayList<Cmres>();

            Factory() {
            }

            int numberOfSubcycleGenerators() {
                return TABLE.size();
            }

            Cmres get(int index) {
                if (index < 0 || index >= TABLE.size()) {
                    throw new IndexOutOfBoundsException("Out of interval [0, " + (TABLE.size() - 1) + "]");
                }
                return TABLE.get(index);
            }

            Cmres getIfDifferent(int index, int other) {
                if (index == other) {
                    throw new IllegalArgumentException("Subcycle generators must be different");
                }
                return this.get(index);
            }

            private static void add(long multiply, int rotate, int start) {
                Factory.checkUnique(TABLE, multiply);
                TABLE.add(new Cmres(multiply, rotate, start));
            }

            static void checkUnique(List<Cmres> table, long multiply) {
                for (Cmres sg : table) {
                    if (multiply != sg.getMultiply()) continue;
                    throw new IllegalStateException(TwoCmres.INTERNAL_ERROR_MSG);
                }
            }

            static {
                Factory.add(-1311035227701529639L, 33, 330658535);
                Factory.add(-4200785911283159561L, 33, 331932042);
                Factory.add(-2480995517876793755L, 31, 115147686);
                Factory.add(8892696302929846813L, 31, 373734283);
                Factory.add(896991281930355499L, 33, 100747837);
                Factory.add(-2821069675138505015L, 33, 21922933);
                Factory.add(-3818034597552471025L, 31, 8815805);
                Factory.add(-8823573168932131537L, 32, 231265826);
                Factory.add(5515758818646274343L, 33, 191570124);
                Factory.add(1291046001440519745L, 32, 106120225);
                Factory.add(-4856050793788397315L, 31, 496739341);
                Factory.add(1086781239490809013L, 33, 0xB7B7B67);
                Factory.add(-5926327289273887825L, 31, 645874071);
                Factory.add(-8067236098409593127L, 31, 37513605);
            }
        }
    }
}

