/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.inference;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.exception.ConvergenceException;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.MaxCountExceededException;
import org.apache.commons.math4.legacy.exception.NoDataException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.exception.NumberIsTooLargeException;
import org.apache.commons.math4.legacy.stat.ranking.NaNStrategy;
import org.apache.commons.math4.legacy.stat.ranking.NaturalRanking;
import org.apache.commons.math4.legacy.stat.ranking.TiesStrategy;
import org.apache.commons.statistics.distribution.NormalDistribution;

public class WilcoxonSignedRankTest {
    private NaturalRanking naturalRanking;

    public WilcoxonSignedRankTest() {
        this.naturalRanking = new NaturalRanking(NaNStrategy.FIXED, TiesStrategy.AVERAGE);
    }

    public WilcoxonSignedRankTest(NaNStrategy nanStrategy, TiesStrategy tiesStrategy) {
        this.naturalRanking = new NaturalRanking(nanStrategy, tiesStrategy);
    }

    private void ensureDataConformance(double[] x, double[] y) throws NullArgumentException, NoDataException, DimensionMismatchException {
        if (x == null || y == null) {
            throw new NullArgumentException();
        }
        if (x.length == 0 || y.length == 0) {
            throw new NoDataException();
        }
        if (y.length != x.length) {
            throw new DimensionMismatchException(y.length, x.length);
        }
    }

    private double[] calculateDifferences(double[] x, double[] y) {
        double[] z = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            z[i] = y[i] - x[i];
        }
        return z;
    }

    private double[] calculateAbsoluteDifferences(double[] z) throws NullArgumentException, NoDataException {
        if (z == null) {
            throw new NullArgumentException();
        }
        if (z.length == 0) {
            throw new NoDataException();
        }
        double[] zAbs = new double[z.length];
        for (int i = 0; i < z.length; ++i) {
            zAbs[i] = JdkMath.abs((double)z[i]);
        }
        return zAbs;
    }

    public double wilcoxonSignedRank(double[] x, double[] y) throws NullArgumentException, NoDataException, DimensionMismatchException {
        this.ensureDataConformance(x, y);
        double[] z = this.calculateDifferences(x, y);
        double[] zAbs = this.calculateAbsoluteDifferences(z);
        double[] ranks = this.naturalRanking.rank(zAbs);
        double wPlus = 0.0;
        for (int i = 0; i < z.length; ++i) {
            if (!(z[i] > 0.0)) continue;
            wPlus += ranks[i];
        }
        int n = x.length;
        double wMinus = (double)(n * (n + 1)) / 2.0 - wPlus;
        return JdkMath.max((double)wPlus, (double)wMinus);
    }

    private double calculateExactPValue(double wMax, int n) {
        int m = 1 << n;
        int largerRankSums = 0;
        for (int i = 0; i < m; ++i) {
            int rankSum = 0;
            for (int j = 0; j < n; ++j) {
                if ((i >> j & 1) != 1) continue;
                rankSum += j + 1;
            }
            if (!((double)rankSum >= wMax)) continue;
            ++largerRankSums;
        }
        return 2.0 * (double)largerRankSums / (double)m;
    }

    private double calculateAsymptoticPValue(double wMin, int n) {
        double es = (double)(n * (n + 1)) / 4.0;
        double varS = es * ((double)(2 * n + 1) / 6.0);
        double z = (wMin - es - 0.5) / JdkMath.sqrt((double)varS);
        NormalDistribution standardNormal = NormalDistribution.of((double)0.0, (double)1.0);
        return 2.0 * standardNormal.cumulativeProbability(z);
    }

    public double wilcoxonSignedRankTest(double[] x, double[] y, boolean exactPValue) throws NullArgumentException, NoDataException, DimensionMismatchException, NumberIsTooLargeException, ConvergenceException, MaxCountExceededException {
        this.ensureDataConformance(x, y);
        int n = x.length;
        double wMax = this.wilcoxonSignedRank(x, y);
        if (exactPValue && n > 30) {
            throw new NumberIsTooLargeException((Number)n, (Number)30, true);
        }
        if (exactPValue) {
            return this.calculateExactPValue(wMax, n);
        }
        double wMin = (double)(n * (n + 1)) / 2.0 - wMax;
        return this.calculateAsymptoticPValue(wMin, n);
    }
}

