/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.CauchyDistribution;
import org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.junit.Assert;
import org.junit.Test;

public class CauchyDistributionTest
extends RealDistributionAbstractTest {
    protected double defaultTolerance = 1.0E-9;

    public void setUp() {
        super.setUp();
        this.setTolerance(this.defaultTolerance);
    }

    public CauchyDistribution makeDistribution() {
        return new CauchyDistribution(1.2, 2.1);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{-667.24856187, -65.6230835029, -25.483029946, -12.0588781808, -5.26313542807, 669.64856187, 68.0230835029, 27.883029946, 14.4588781808, 7.66313542807};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.001, 0.01, 0.025, 0.05, 0.1, 0.999, 0.99, 0.975, 0.95, 0.9};
    }

    public double[] makeDensityTestValues() {
        return new double[]{1.49599158008E-6, 1.49550440335E-4, 9.33076881878E-4, 0.00370933207799, 0.0144742330437, 1.49599158008E-6, 1.49550440335E-4, 9.33076881878E-4, 0.00370933207799, 0.0144742330437};
    }

    @Test
    public void testInverseCumulativeProbabilityExtremes() {
        this.setInverseCumulativeTestPoints(new double[]{0.0, 1.0});
        this.setInverseCumulativeTestValues(new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY});
        this.verifyInverseCumulativeProbabilities();
    }

    @Test
    public void testMedian() {
        CauchyDistribution distribution = (CauchyDistribution)this.getDistribution();
        Assert.assertEquals((double)1.2, (double)distribution.getMedian(), (double)0.0);
    }

    @Test
    public void testScale() {
        CauchyDistribution distribution = (CauchyDistribution)this.getDistribution();
        Assert.assertEquals((double)2.1, (double)distribution.getScale(), (double)0.0);
    }

    @Test
    public void testPreconditions() {
        try {
            new CauchyDistribution(0.0, 0.0);
            Assert.fail((String)"Cannot have zero scale");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
        try {
            new CauchyDistribution(0.0, -1.0);
            Assert.fail((String)"Cannot have negative scale");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
    }

    @Test
    public void testMoments() {
        CauchyDistribution dist = new CauchyDistribution(10.2, 0.15);
        Assert.assertTrue((boolean)Double.isNaN(dist.getNumericalMean()));
        Assert.assertTrue((boolean)Double.isNaN(dist.getNumericalVariance()));
        dist = new CauchyDistribution(23.12, 2.12);
        Assert.assertTrue((boolean)Double.isNaN(dist.getNumericalMean()));
        Assert.assertTrue((boolean)Double.isNaN(dist.getNumericalVariance()));
    }
}

